/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.v5_12.hive.aws.v1;

import io.fabric8.kubernetes.api.builder.v5_12.VisitableBuilder;
import io.fabric8.openshift.api.model.v5_12.hive.aws.v1.SpotMarketOptions;
import io.fabric8.openshift.api.model.v5_12.hive.aws.v1.SpotMarketOptionsFluent;
import io.fabric8.openshift.api.model.v5_12.hive.aws.v1.SpotMarketOptionsFluentImpl;
import java.util.Objects;

public class SpotMarketOptionsBuilder
extends SpotMarketOptionsFluentImpl<SpotMarketOptionsBuilder>
implements VisitableBuilder<SpotMarketOptions, SpotMarketOptionsBuilder> {
    SpotMarketOptionsFluent<?> fluent;
    Boolean validationEnabled;

    public SpotMarketOptionsBuilder() {
        this(false);
    }

    public SpotMarketOptionsBuilder(Boolean validationEnabled) {
        this(new SpotMarketOptions(), validationEnabled);
    }

    public SpotMarketOptionsBuilder(SpotMarketOptionsFluent<?> fluent) {
        this(fluent, (Boolean)false);
    }

    public SpotMarketOptionsBuilder(SpotMarketOptionsFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new SpotMarketOptions(), validationEnabled);
    }

    public SpotMarketOptionsBuilder(SpotMarketOptionsFluent<?> fluent, SpotMarketOptions instance) {
        this(fluent, instance, false);
    }

    public SpotMarketOptionsBuilder(SpotMarketOptionsFluent<?> fluent, SpotMarketOptions instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withMaxPrice(instance.getMaxPrice());
        fluent.withAdditionalProperties(instance.getAdditionalProperties());
        this.validationEnabled = validationEnabled;
    }

    public SpotMarketOptionsBuilder(SpotMarketOptions instance) {
        this(instance, (Boolean)false);
    }

    public SpotMarketOptionsBuilder(SpotMarketOptions instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withMaxPrice(instance.getMaxPrice());
        this.withAdditionalProperties(instance.getAdditionalProperties());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public SpotMarketOptions build() {
        SpotMarketOptions buildable = new SpotMarketOptions(this.fluent.getMaxPrice());
        buildable.setAdditionalProperties(this.fluent.getAdditionalProperties());
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SpotMarketOptionsBuilder that = (SpotMarketOptionsBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.fluent, this.validationEnabled, super.hashCode());
    }
}

