/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.v5_12;

import io.fabric8.kubernetes.api.builder.v5_12.BaseFluent;
import io.fabric8.kubernetes.api.builder.v5_12.Nested;
import io.fabric8.kubernetes.api.model.v5_12.PodTemplateSpec;
import io.fabric8.kubernetes.api.model.v5_12.PodTemplateSpecBuilder;
import io.fabric8.kubernetes.api.model.v5_12.PodTemplateSpecFluentImpl;
import io.fabric8.openshift.api.model.v5_12.PodSecurityPolicySubjectReviewSpec;
import io.fabric8.openshift.api.model.v5_12.PodSecurityPolicySubjectReviewSpecFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class PodSecurityPolicySubjectReviewSpecFluentImpl<A extends PodSecurityPolicySubjectReviewSpecFluent<A>>
extends BaseFluent<A>
implements PodSecurityPolicySubjectReviewSpecFluent<A> {
    private List<String> groups = new ArrayList<String>();
    private PodTemplateSpecBuilder template;
    private String user;
    private Map<String, Object> additionalProperties;

    public PodSecurityPolicySubjectReviewSpecFluentImpl() {
    }

    public PodSecurityPolicySubjectReviewSpecFluentImpl(PodSecurityPolicySubjectReviewSpec instance) {
        this.withGroups(instance.getGroups());
        this.withTemplate(instance.getTemplate());
        this.withUser(instance.getUser());
        this.withAdditionalProperties(instance.getAdditionalProperties());
    }

    @Override
    public A addToGroups(Integer index, String item) {
        if (this.groups == null) {
            this.groups = new ArrayList<String>();
        }
        this.groups.add(index, item);
        return (A)this;
    }

    @Override
    public A setToGroups(Integer index, String item) {
        if (this.groups == null) {
            this.groups = new ArrayList<String>();
        }
        this.groups.set(index, item);
        return (A)this;
    }

    @Override
    public A addToGroups(String ... items) {
        if (this.groups == null) {
            this.groups = new ArrayList<String>();
        }
        for (String item : items) {
            this.groups.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToGroups(Collection<String> items) {
        if (this.groups == null) {
            this.groups = new ArrayList<String>();
        }
        for (String item : items) {
            this.groups.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromGroups(String ... items) {
        for (String item : items) {
            if (this.groups == null) continue;
            this.groups.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromGroups(Collection<String> items) {
        for (String item : items) {
            if (this.groups == null) continue;
            this.groups.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getGroups() {
        return this.groups;
    }

    @Override
    public String getGroup(Integer index) {
        return this.groups.get(index);
    }

    @Override
    public String getFirstGroup() {
        return this.groups.get(0);
    }

    @Override
    public String getLastGroup() {
        return this.groups.get(this.groups.size() - 1);
    }

    @Override
    public String getMatchingGroup(Predicate<String> predicate) {
        for (String item : this.groups) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingGroup(Predicate<String> predicate) {
        for (String item : this.groups) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withGroups(List<String> groups) {
        if (groups != null) {
            this.groups = new ArrayList<String>();
            for (String item : groups) {
                this.addToGroups(item);
            }
        } else {
            this.groups = null;
        }
        return (A)this;
    }

    @Override
    public A withGroups(String ... groups) {
        if (this.groups != null) {
            this.groups.clear();
        }
        if (groups != null) {
            for (String item : groups) {
                this.addToGroups(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasGroups() {
        return this.groups != null && !this.groups.isEmpty();
    }

    @Override
    public A addNewGroup(String arg0) {
        return this.addToGroups(new String(arg0));
    }

    @Override
    @Deprecated
    public PodTemplateSpec getTemplate() {
        return this.template != null ? this.template.build() : null;
    }

    @Override
    public PodTemplateSpec buildTemplate() {
        return this.template != null ? this.template.build() : null;
    }

    @Override
    public A withTemplate(PodTemplateSpec template) {
        this._visitables.get("template").remove(this.template);
        if (template != null) {
            this.template = new PodTemplateSpecBuilder(template);
            this._visitables.get("template").add(this.template);
        }
        return (A)this;
    }

    @Override
    public Boolean hasTemplate() {
        return this.template != null;
    }

    @Override
    public PodSecurityPolicySubjectReviewSpecFluent.TemplateNested<A> withNewTemplate() {
        return new TemplateNestedImpl();
    }

    @Override
    public PodSecurityPolicySubjectReviewSpecFluent.TemplateNested<A> withNewTemplateLike(PodTemplateSpec item) {
        return new TemplateNestedImpl(item);
    }

    @Override
    public PodSecurityPolicySubjectReviewSpecFluent.TemplateNested<A> editTemplate() {
        return this.withNewTemplateLike(this.getTemplate());
    }

    @Override
    public PodSecurityPolicySubjectReviewSpecFluent.TemplateNested<A> editOrNewTemplate() {
        return this.withNewTemplateLike(this.getTemplate() != null ? this.getTemplate() : new PodTemplateSpecBuilder().build());
    }

    @Override
    public PodSecurityPolicySubjectReviewSpecFluent.TemplateNested<A> editOrNewTemplateLike(PodTemplateSpec item) {
        return this.withNewTemplateLike(this.getTemplate() != null ? this.getTemplate() : item);
    }

    @Override
    public String getUser() {
        return this.user;
    }

    @Override
    public A withUser(String user) {
        this.user = user;
        return (A)this;
    }

    @Override
    public Boolean hasUser() {
        return this.user != null;
    }

    @Override
    @Deprecated
    public A withNewUser(String arg0) {
        return this.withUser(new String(arg0));
    }

    @Override
    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    @Override
    public Boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PodSecurityPolicySubjectReviewSpecFluentImpl that = (PodSecurityPolicySubjectReviewSpecFluentImpl)o;
        if (this.groups != null ? !this.groups.equals(that.groups) : that.groups != null) {
            return false;
        }
        if (this.template != null ? !this.template.equals(that.template) : that.template != null) {
            return false;
        }
        if (this.user != null ? !this.user.equals(that.user) : that.user != null) {
            return false;
        }
        return !(this.additionalProperties != null ? !this.additionalProperties.equals(that.additionalProperties) : that.additionalProperties != null);
    }

    public int hashCode() {
        return Objects.hash(this.groups, this.template, this.user, this.additionalProperties, super.hashCode());
    }

    public class TemplateNestedImpl<N>
    extends PodTemplateSpecFluentImpl<PodSecurityPolicySubjectReviewSpecFluent.TemplateNested<N>>
    implements PodSecurityPolicySubjectReviewSpecFluent.TemplateNested<N>,
    Nested<N> {
        PodTemplateSpecBuilder builder;

        TemplateNestedImpl(PodTemplateSpec item) {
            this.builder = new PodTemplateSpecBuilder(this, item);
        }

        TemplateNestedImpl() {
            this.builder = new PodTemplateSpecBuilder(this);
        }

        @Override
        public N and() {
            return (N)PodSecurityPolicySubjectReviewSpecFluentImpl.this.withTemplate(this.builder.build());
        }

        @Override
        public N endTemplate() {
            return this.and();
        }
    }
}

