/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.clnt.v5_12.utils;

import io.fabric8.kubernetes.clnt.v5_12.Config;
import io.fabric8.kubernetes.clnt.v5_12.http.BasicBuilder;
import io.fabric8.kubernetes.clnt.v5_12.http.HttpClient;
import io.fabric8.kubernetes.clnt.v5_12.http.HttpHeaders;
import io.fabric8.kubernetes.clnt.v5_12.http.HttpResponse;
import io.fabric8.kubernetes.clnt.v5_12.http.Interceptor;
import io.fabric8.kubernetes.clnt.v5_12.utils.OpenIDConnectionUtils;
import io.fabric8.kubernetes.clnt.v5_12.utils.Utils;
import java.time.Instant;
import java.time.temporal.ChronoUnit;

public class TokenRefreshInterceptor
implements Interceptor {
    public static final String NAME = "TOKEN";
    private final Config config;
    private HttpClient.Factory factory;
    private Instant lastRefresh;

    public TokenRefreshInterceptor(Config config, HttpClient.Factory factory) {
        this.config = config;
        this.lastRefresh = Instant.now();
        this.factory = factory;
    }

    @Override
    public void before(BasicBuilder headerBuilder, HttpHeaders headers) {
        if (this.timeToRefresh()) {
            this.refreshToken(headerBuilder);
        }
    }

    @Override
    public boolean afterFailure(BasicBuilder headerBuilder, HttpResponse<?> response) {
        if (response.code() == 401) {
            return this.refreshToken(headerBuilder);
        }
        return false;
    }

    private boolean refreshToken(BasicBuilder headerBuilder) {
        Config newestConfig;
        String newAccessToken;
        boolean resubmit = false;
        String currentContextName = null;
        if (this.config.getCurrentContext() != null) {
            currentContextName = this.config.getCurrentContext().getName();
        }
        if (Utils.isNotNullOrEmpty(newAccessToken = (newestConfig = Config.autoConfigure(currentContextName)).getAuthProvider() != null && newestConfig.getAuthProvider().getName().equalsIgnoreCase("oidc") ? OpenIDConnectionUtils.resolveOIDCTokenFromAuthConfig(newestConfig.getAuthProvider().getConfig(), this.factory.newBuilder()) : newestConfig.getOauthToken())) {
            headerBuilder.setHeader("Authorization", "Bearer " + newAccessToken);
            this.config.setOauthToken(newAccessToken);
            resubmit = true;
        }
        return resubmit;
    }

    private boolean timeToRefresh() {
        return this.lastRefresh.plus(1L, ChronoUnit.MINUTES).isBefore(Instant.now());
    }

    void setLastRefresh(Instant lastRefresh) {
        this.lastRefresh = lastRefresh;
    }
}

