/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.clnt.v5_12.informers.cache;

import io.fabric8.kubernetes.api.model.v5_12.HasMetadata;
import io.fabric8.kubernetes.api.model.v5_12.KubernetesResourceList;
import io.fabric8.kubernetes.api.model.v5_12.ListOptionsBuilder;
import io.fabric8.kubernetes.clnt.v5_12.KubernetesClientException;
import io.fabric8.kubernetes.clnt.v5_12.Watch;
import io.fabric8.kubernetes.clnt.v5_12.Watcher;
import io.fabric8.kubernetes.clnt.v5_12.WatcherException;
import io.fabric8.kubernetes.clnt.v5_12.informers.ListerWatcher;
import io.fabric8.kubernetes.clnt.v5_12.informers.cache.SyncableStore;
import io.fabric8.kubernetes.clnt.v5_12.utils.Utils;
import java.util.LinkedHashSet;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Reflector<T extends HasMetadata, L extends KubernetesResourceList<T>> {
    private static final Logger log = LoggerFactory.getLogger(Reflector.class);
    private volatile String lastSyncResourceVersion;
    private final Class<T> apiTypeClass;
    private final ListerWatcher<T, L> listerWatcher;
    private final SyncableStore<T> store;
    private final ReflectorWatcher watcher;
    private volatile boolean running;
    private volatile boolean watching;
    private final AtomicReference<Watch> watch;
    private final CompletableFuture<Void> stopFuture = new CompletableFuture();

    public Reflector(Class<T> apiTypeClass, ListerWatcher<T, L> listerWatcher, SyncableStore<T> store) {
        this.apiTypeClass = apiTypeClass;
        this.listerWatcher = listerWatcher;
        this.store = store;
        this.watcher = new ReflectorWatcher();
        this.watch = new AtomicReference<Object>(null);
    }

    public void stop() {
        this.running = false;
        this.stopFuture.complete(null);
        this.stopWatcher();
    }

    private synchronized void stopWatcher() {
        Watch theWatch = this.watch.getAndSet(null);
        if (theWatch != null) {
            String ns = this.listerWatcher.getNamespace();
            log.debug("Stopping watcher for resource {} v{} in namespace {}", new Object[]{this.apiTypeClass, this.lastSyncResourceVersion, ns});
            theWatch.close();
            this.watchStopped();
        }
    }

    public void start() {
        try {
            this.listSyncAndWatch();
        }
        catch (Exception e) {
            this.running = false;
            this.stopFuture.completeExceptionally(e);
            throw KubernetesClientException.launderThrowable(e);
        }
    }

    public void listSyncAndWatch() {
        String latestResourceVersion;
        KubernetesResourceList result;
        this.running = true;
        String continueVal = null;
        LinkedHashSet<String> nextKeys = new LinkedHashSet<String>();
        do {
            result = (KubernetesResourceList)this.listerWatcher.list(((ListOptionsBuilder)((ListOptionsBuilder)new ListOptionsBuilder().withLimit(this.listerWatcher.getLimit())).withContinue(continueVal)).build());
            result.getItems().forEach(i -> {
                String key = this.store.getKey((HasMetadata)i);
                this.store.update((HasMetadata)i);
                nextKeys.add(key);
            });
        } while (Utils.isNotNullOrEmpty(continueVal = result.getMetadata().getContinue()));
        this.store.retainAll(nextKeys);
        this.lastSyncResourceVersion = latestResourceVersion = result.getMetadata().getResourceVersion();
        log.debug("Listing items ({}) for resource {} v{}", new Object[]{nextKeys.size(), this.apiTypeClass, latestResourceVersion});
        this.startWatcher(latestResourceVersion);
    }

    private synchronized void startWatcher(String latestResourceVersion) {
        if (!this.running) {
            return;
        }
        log.debug("Starting watcher for resource {} v{}", this.apiTypeClass, (Object)latestResourceVersion);
        this.watch.set(this.listerWatcher.watch(((ListOptionsBuilder)((ListOptionsBuilder)new ListOptionsBuilder().withResourceVersion(latestResourceVersion)).withTimeoutSeconds(null)).build(), this.watcher));
        this.watching = true;
    }

    private synchronized void watchStopped() {
        this.watching = false;
    }

    public String getLastSyncResourceVersion() {
        return this.lastSyncResourceVersion;
    }

    public boolean isRunning() {
        return this.running;
    }

    public boolean isWatching() {
        return this.watching;
    }

    public ReflectorWatcher getWatcher() {
        return this.watcher;
    }

    public CompletableFuture<Void> getStopFuture() {
        return this.stopFuture;
    }

    class ReflectorWatcher
    implements Watcher<T> {
        ReflectorWatcher() {
        }

        @Override
        public void eventReceived(Watcher.Action action, T resource) {
            if (action == null) {
                throw new KubernetesClientException("Unrecognized event");
            }
            if (resource == null) {
                throw new KubernetesClientException("Unrecognized resource");
            }
            if (log.isDebugEnabled()) {
                log.debug("Event received {} {} resourceVersion {}", new Object[]{action.name(), resource.getKind(), resource.getMetadata().getResourceVersion()});
            }
            switch (action) {
                case ERROR: {
                    throw new KubernetesClientException("ERROR event");
                }
                case ADDED: {
                    Reflector.this.store.add(resource);
                    break;
                }
                case MODIFIED: {
                    Reflector.this.store.update(resource);
                    break;
                }
                case DELETED: {
                    Reflector.this.store.delete(resource);
                }
            }
            Reflector.this.lastSyncResourceVersion = resource.getMetadata().getResourceVersion();
        }

        @Override
        public void onClose(WatcherException exception) {
            boolean restarted = false;
            try {
                if (exception.isHttpGone()) {
                    log.debug("Watch restarting due to http gone");
                    Reflector.this.listSyncAndWatch();
                    restarted = true;
                } else {
                    log.warn("Watch closing with exception", (Throwable)exception);
                    Reflector.this.running = false;
                    Reflector.this.stopFuture.completeExceptionally(exception);
                }
            }
            finally {
                if (!restarted) {
                    Reflector.this.watchStopped();
                }
            }
        }

        @Override
        public void onClose() {
            Reflector.this.watchStopped();
            log.debug("Watch gracefully closed");
        }

        @Override
        public boolean reconnecting() {
            return true;
        }
    }
}

