/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.clnt.v5_12.dsl.internal.uploadable;

import io.fabric8.kubernetes.api.model.v5_12.Status;
import io.fabric8.kubernetes.api.model.v5_12.StatusCause;
import io.fabric8.kubernetes.clnt.v5_12.KubernetesClientException;
import io.fabric8.kubernetes.clnt.v5_12.http.WebSocket;
import io.fabric8.kubernetes.clnt.v5_12.utils.Serialization;
import io.fabric8.kubernetes.clnt.v5_12.utils.Utils;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.TimeUnit;

public class PodUploadWebSocketListener
implements WebSocket.Listener {
    private static final byte FLAG_STDIN = 0;
    private static final long MAX_QUEUE_SIZE = 0x1000000L;
    private final CompletableFuture<WebSocket> webSocketRef = new CompletableFuture();
    private final CompletableFuture<Void> completeFuture = new CompletableFuture();

    @Override
    public void onOpen(WebSocket webSocket) {
        this.webSocketRef.complete(webSocket);
    }

    @Override
    public void onMessage(WebSocket webSocket, ByteBuffer bytes) {
        byte streamID = bytes.get(0);
        if (bytes.remaining() > 1) {
            bytes.position(1);
            KubernetesClientException exception = null;
            String stringValue = StandardCharsets.UTF_8.decode(bytes).toString();
            if (streamID == 3) {
                try {
                    Status status = Serialization.unmarshal(stringValue, Status.class);
                    if (status != null) {
                        if (this.parseExitCode(status) == 0) {
                            this.completeFuture.complete(null);
                            return;
                        }
                        exception = new KubernetesClientException(status);
                    }
                }
                catch (Exception exception2) {
                    // empty catch block
                }
            }
            if (exception == null) {
                exception = new KubernetesClientException(stringValue);
            }
            this.completeFuture.completeExceptionally(exception);
        }
    }

    @Override
    public void onClose(WebSocket webSocket, int code, String reason) {
        this.completeFuture.complete(null);
    }

    @Override
    public void onError(WebSocket webSocket, Throwable t) {
        this.webSocketRef.completeExceptionally(t);
        this.completeFuture.completeExceptionally(t);
    }

    final void checkError() {
        if (this.completeFuture.isDone()) {
            try {
                this.completeFuture.getNow(null);
            }
            catch (CompletionException e) {
                throw KubernetesClientException.launderThrowable(e.getCause());
            }
        }
    }

    final void waitUntilReady(int timeoutMilliseconds) {
        Utils.waitUntilReadyOrFail(this.webSocketRef, timeoutMilliseconds, TimeUnit.MILLISECONDS);
    }

    final void waitUntilComplete(int timeoutMilliseconds) throws InterruptedException {
        while (((WebSocket)this.webSocketRef.getNow(null)).queueSize() > 0L && !this.completeFuture.isDone()) {
            this.checkError();
            Thread.sleep(50L);
        }
        ((WebSocket)this.webSocketRef.getNow(null)).sendClose(1000, "Operation completed");
        Utils.waitUntilReadyOrFail(this.completeFuture, timeoutMilliseconds, TimeUnit.MILLISECONDS);
        this.checkError();
    }

    final void send(byte[] data, int length) {
        this.checkError();
        this.waitForQueue(length);
        byte[] toSend = new byte[length + 1];
        toSend[0] = 0;
        System.arraycopy(data, 0, toSend, 1, length);
        ((WebSocket)this.webSocketRef.getNow(null)).send(ByteBuffer.wrap(toSend));
    }

    final void waitForQueue(int length) {
        try {
            while (((WebSocket)this.webSocketRef.getNow(null)).queueSize() + (long)length > 0x1000000L && !Thread.interrupted()) {
                this.checkError();
                Thread.sleep(50L);
            }
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
        }
    }

    private int parseExitCode(Status status) {
        if ("Success".equals(status.getStatus())) {
            return 0;
        }
        if ("NonZeroExitCode".equals(status.getReason())) {
            if (status.getDetails() == null) {
                return -1;
            }
            List<StatusCause> causes = status.getDetails().getCauses();
            if (causes == null) {
                return -1;
            }
            return causes.stream().filter(c -> "ExitCode".equals(c.getReason())).map(StatusCause::getMessage).map(Integer::valueOf).findFirst().orElse(-1);
        }
        return 1;
    }
}

