/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.clnt.v5_12.dsl.internal.core.v1;

import io.fabric8.kubernetes.api.model.v5_12.DeleteOptions;
import io.fabric8.kubernetes.api.model.v5_12.HasMetadata;
import io.fabric8.kubernetes.api.model.v5_12.Pod;
import io.fabric8.kubernetes.api.model.v5_12.PodList;
import io.fabric8.kubernetes.api.model.v5_12.policy.v1beta1.Eviction;
import io.fabric8.kubernetes.api.model.v5_12.policy.v1beta1.EvictionBuilder;
import io.fabric8.kubernetes.api.model.v5_12.policy.v1beta1.EvictionFluent;
import io.fabric8.kubernetes.clnt.v5_12.ClientContext;
import io.fabric8.kubernetes.clnt.v5_12.KubernetesClientException;
import io.fabric8.kubernetes.clnt.v5_12.LocalPortForward;
import io.fabric8.kubernetes.clnt.v5_12.PortForward;
import io.fabric8.kubernetes.clnt.v5_12.dsl.BytesLimitTerminateTimeTailPrettyLoggable;
import io.fabric8.kubernetes.clnt.v5_12.dsl.ContainerResource;
import io.fabric8.kubernetes.clnt.v5_12.dsl.CopyOrReadable;
import io.fabric8.kubernetes.clnt.v5_12.dsl.ExecListenable;
import io.fabric8.kubernetes.clnt.v5_12.dsl.ExecListener;
import io.fabric8.kubernetes.clnt.v5_12.dsl.ExecWatch;
import io.fabric8.kubernetes.clnt.v5_12.dsl.Execable;
import io.fabric8.kubernetes.clnt.v5_12.dsl.LogWatch;
import io.fabric8.kubernetes.clnt.v5_12.dsl.Loggable;
import io.fabric8.kubernetes.clnt.v5_12.dsl.PodResource;
import io.fabric8.kubernetes.clnt.v5_12.dsl.PrettyLoggable;
import io.fabric8.kubernetes.clnt.v5_12.dsl.TailPrettyLoggable;
import io.fabric8.kubernetes.clnt.v5_12.dsl.TimeTailPrettyLoggable;
import io.fabric8.kubernetes.clnt.v5_12.dsl.TtyExecErrorChannelable;
import io.fabric8.kubernetes.clnt.v5_12.dsl.TtyExecErrorable;
import io.fabric8.kubernetes.clnt.v5_12.dsl.TtyExecOutputErrorable;
import io.fabric8.kubernetes.clnt.v5_12.dsl.TtyExecable;
import io.fabric8.kubernetes.clnt.v5_12.dsl.base.HasMetadataOperation;
import io.fabric8.kubernetes.clnt.v5_12.dsl.base.OperationContext;
import io.fabric8.kubernetes.clnt.v5_12.dsl.internal.ExecWebSocketListener;
import io.fabric8.kubernetes.clnt.v5_12.dsl.internal.HasMetadataOperationsImpl;
import io.fabric8.kubernetes.clnt.v5_12.dsl.internal.LogWatchCallback;
import io.fabric8.kubernetes.clnt.v5_12.dsl.internal.PodOperationContext;
import io.fabric8.kubernetes.clnt.v5_12.dsl.internal.PortForwarderWebsocket;
import io.fabric8.kubernetes.clnt.v5_12.dsl.internal.uploadable.PodUpload;
import io.fabric8.kubernetes.clnt.v5_12.http.HttpClient;
import io.fabric8.kubernetes.clnt.v5_12.http.HttpRequest;
import io.fabric8.kubernetes.clnt.v5_12.http.WebSocket;
import io.fabric8.kubernetes.clnt.v5_12.lib.FilenameUtils;
import io.fabric8.kubernetes.clnt.v5_12.utils.Base64;
import io.fabric8.kubernetes.clnt.v5_12.utils.OptionalDependencyWrapper;
import io.fabric8.kubernetes.clnt.v5_12.utils.PodOperationUtil;
import io.fabric8.kubernetes.clnt.v5_12.utils.URLUtils;
import io.fabric8.kubernetes.clnt.v5_12.utils.Utils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.Reader;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.Collections;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;

public class PodOperationsImpl
extends HasMetadataOperation<Pod, PodList, PodResource<Pod>>
implements PodResource<Pod>,
CopyOrReadable<Boolean, InputStream, Boolean> {
    public static final int HTTP_TOO_MANY_REQUESTS = 429;
    private static final Integer DEFAULT_POD_LOG_WAIT_TIMEOUT = 5;
    private static final String[] EMPTY_COMMAND = new String[]{"/bin/sh", "-i"};
    private final String containerId;
    private final InputStream in;
    private final OutputStream out;
    private final OutputStream err;
    private final OutputStream errChannel;
    private final PipedOutputStream inPipe;
    private final PipedInputStream outPipe;
    private final PipedInputStream errPipe;
    private final PipedInputStream errChannelPipe;
    private final boolean withTTY;
    private final boolean withTerminatedStatus;
    private final boolean withTimestamps;
    private final String sinceTimestamp;
    private final Integer sinceSeconds;
    private final Integer withTailingLines;
    private final boolean withPrettyOutput;
    private final ExecListener execListener;
    private final Integer limitBytes;
    private final Integer bufferSize;
    private final PodOperationContext podOperationContext;

    public PodOperationsImpl(ClientContext clientContext) {
        this(clientContext, null);
    }

    public PodOperationsImpl(ClientContext clientContext, String namespace) {
        this(new PodOperationContext(), HasMetadataOperationsImpl.defaultContext(clientContext).withNamespace(namespace));
    }

    public PodOperationsImpl(PodOperationContext context, OperationContext superContext) {
        super(superContext.withPlural("pods"), Pod.class, PodList.class);
        this.podOperationContext = context;
        this.containerId = context.getContainerId();
        this.in = context.getIn();
        this.inPipe = context.getInPipe();
        this.out = context.getOut();
        this.outPipe = context.getOutPipe();
        this.err = context.getErr();
        this.errPipe = context.getErrPipe();
        this.errChannel = context.getErrChannel();
        this.errChannelPipe = context.getErrChannelPipe();
        this.withTTY = context.isTty();
        this.withTerminatedStatus = context.isTerminatedStatus();
        this.withTimestamps = context.isTimestamps();
        this.sinceTimestamp = context.getSinceTimestamp();
        this.sinceSeconds = context.getSinceSeconds();
        this.withTailingLines = context.getTailingLines();
        this.withPrettyOutput = context.isPrettyOutput();
        this.execListener = context.getExecListener();
        this.limitBytes = context.getLimitBytes();
        this.bufferSize = context.getBufferSize();
    }

    public PodOperationsImpl newInstance(OperationContext context) {
        return new PodOperationsImpl(this.podOperationContext, context);
    }

    public PodOperationContext getContext() {
        return this.podOperationContext;
    }

    protected String getLogParameters() {
        StringBuilder sb = new StringBuilder();
        sb.append("log?pretty=").append(this.withPrettyOutput);
        if (this.containerId != null && !this.containerId.isEmpty()) {
            sb.append("&container=").append(this.containerId);
        }
        if (this.withTerminatedStatus) {
            sb.append("&previous=true");
        }
        if (this.sinceSeconds != null) {
            sb.append("&sinceSeconds=").append(this.sinceSeconds);
        } else if (this.sinceTimestamp != null) {
            sb.append("&sinceTime=").append(this.sinceTimestamp);
        }
        if (this.withTailingLines != null) {
            sb.append("&tailLines=").append(this.withTailingLines);
        }
        if (this.limitBytes != null) {
            sb.append("&limitBytes=").append(this.limitBytes);
        }
        if (this.withTimestamps) {
            sb.append("&timestamps=true");
        }
        return sb.toString();
    }

    protected <T> T doGetLog(Class<T> type) {
        try {
            URL url = new URL(URLUtils.join(this.getResourceUrl().toString(), this.getLogParameters()));
            return this.handleRawGet(url, type);
        }
        catch (IOException ioException) {
            throw KubernetesClientException.launderThrowable(this.forOperationType("doGetLog"), (Throwable)ioException);
        }
    }

    @Override
    public String getLog() {
        return this.doGetLog(String.class);
    }

    @Override
    public Reader getLogReader() {
        return this.doGetLog(Reader.class);
    }

    @Override
    public String getLog(Boolean isPretty) {
        return new PodOperationsImpl(this.getContext().withPrettyOutput(isPretty), this.context).getLog();
    }

    @Override
    public LogWatch watchLog() {
        return this.watchLog(null);
    }

    @Override
    public LogWatch watchLog(OutputStream out) {
        try {
            PodOperationUtil.waitUntilReadyBeforeFetchingLogs(this, this.getContext().getLogWaitTimeout() != null ? this.getContext().getLogWaitTimeout() : DEFAULT_POD_LOG_WAIT_TIMEOUT);
            URL url = new URL(URLUtils.join(this.getResourceUrl().toString(), this.getLogParameters() + "&follow=true"));
            LogWatchCallback callback = new LogWatchCallback(this.config, out);
            return callback.callAndWait(this.httpClient, url);
        }
        catch (IOException ioException) {
            throw KubernetesClientException.launderThrowable(this.forOperationType("watchLog"), (Throwable)ioException);
        }
    }

    @Override
    public Loggable<LogWatch> withLogWaitTimeout(Integer logWaitTimeout) {
        return new PodOperationsImpl(this.getContext().withLogWaitTimeout(logWaitTimeout), this.context);
    }

    @Override
    public PortForward portForward(int port, ReadableByteChannel in, WritableByteChannel out) {
        try {
            return new PortForwarderWebsocket(this.httpClient).forward(this.getResourceUrl(), port, in, out);
        }
        catch (Throwable t) {
            throw KubernetesClientException.launderThrowable(t);
        }
    }

    @Override
    public LocalPortForward portForward(int port) {
        try {
            return new PortForwarderWebsocket(this.httpClient).forward(this.getResourceUrl(), port);
        }
        catch (Throwable t) {
            throw KubernetesClientException.launderThrowable(t);
        }
    }

    @Override
    public LocalPortForward portForward(int port, int localPort) {
        try {
            return new PortForwarderWebsocket(this.httpClient).forward(this.getResourceUrl(), port, localPort);
        }
        catch (Throwable t) {
            throw KubernetesClientException.launderThrowable(t);
        }
    }

    @Override
    public LocalPortForward portForward(int port, InetAddress localInetAddress, int localPort) {
        try {
            return new PortForwarderWebsocket(this.httpClient).forward(this.getResourceUrl(), port, localInetAddress, localPort);
        }
        catch (MalformedURLException ex) {
            throw KubernetesClientException.launderThrowable(ex);
        }
    }

    @Override
    public Boolean evict() {
        Eviction eviction = ((EvictionBuilder)((EvictionBuilder)((EvictionFluent.MetadataNested)((EvictionFluent.MetadataNested)new EvictionBuilder().withNewMetadata().withName(this.getName())).withNamespace(this.getNamespace())).endMetadata()).withDeleteOptions(new DeleteOptions())).build();
        return this.handleEvict(eviction);
    }

    @Override
    public Boolean evict(io.fabric8.kubernetes.api.model.v5_12.policy.v1.Eviction eviction) {
        return this.handleEvict(eviction);
    }

    private Boolean handleEvict(HasMetadata eviction) {
        try {
            if (Utils.isNullOrEmpty(eviction.getMetadata().getNamespace())) {
                throw new KubernetesClientException("Namespace not specified, but operation requires it.");
            }
            if (Utils.isNullOrEmpty(eviction.getMetadata().getName())) {
                throw new KubernetesClientException("Name not specified, but operation requires it.");
            }
            URL requestUrl = new URL(URLUtils.join(this.getResourceUrl().toString(), "eviction"));
            HttpRequest.Builder requestBuilder = this.httpClient.newHttpRequestBuilder().post("application/json", JSON_MAPPER.writeValueAsString((Object)eviction)).url(requestUrl);
            this.handleResponse(requestBuilder, null, Collections.emptyMap());
            return true;
        }
        catch (KubernetesClientException e) {
            if (e.getCode() != 404 && e.getCode() != 429) {
                throw e;
            }
            return false;
        }
        catch (IOException exception) {
            throw KubernetesClientException.launderThrowable(this.forOperationType("evict"), (Throwable)exception);
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
            throw KubernetesClientException.launderThrowable(this.forOperationType("evict"), (Throwable)interruptedException);
        }
    }

    @Override
    public ContainerResource<LogWatch, InputStream, PipedOutputStream, OutputStream, PipedInputStream, String, ExecWatch, Boolean, InputStream, Boolean> inContainer(String containerId) {
        return new PodOperationsImpl(this.getContext().withContainerId(containerId), this.context);
    }

    public ExecWatch exec(String ... command) {
        String[] actualCommands = command.length >= 1 ? command : EMPTY_COMMAND;
        try {
            URL url = this.getURLWithCommandParams(actualCommands);
            HttpClient clone = this.httpClient.newBuilder().readTimeout(0L, TimeUnit.MILLISECONDS).build();
            ExecWebSocketListener execWebSocketListener = new ExecWebSocketListener(this.in, this.out, this.err, this.errChannel, this.inPipe, this.outPipe, this.errPipe, this.errChannelPipe, this.execListener, this.bufferSize);
            CompletableFuture<WebSocket> startedFuture = clone.newWebSocketBuilder().setHeader("Sec-WebSocket-Protocol", "v4.channel.k8s.io").uri(url.toURI()).buildAsync(execWebSocketListener);
            startedFuture.whenComplete((w, t) -> {
                if (t != null) {
                    execWebSocketListener.onError((WebSocket)w, (Throwable)t);
                }
            });
            Utils.waitUntilReadyOrFail(startedFuture, this.config.getWebsocketTimeout(), TimeUnit.MILLISECONDS);
            return execWebSocketListener;
        }
        catch (Throwable t2) {
            throw KubernetesClientException.launderThrowable(this.forOperationType("exec"), t2);
        }
    }

    URL getURLWithCommandParams(String[] commands) throws MalformedURLException {
        String url = URLUtils.join(this.getResourceUrl().toString(), "exec");
        URLUtils.URLBuilder httpUrlBuilder = new URLUtils.URLBuilder(url);
        for (String cmd : commands) {
            httpUrlBuilder.addQueryParameter("command", cmd);
        }
        if (this.containerId != null && !this.containerId.isEmpty()) {
            httpUrlBuilder.addQueryParameter("container", this.containerId);
        }
        if (this.withTTY) {
            httpUrlBuilder.addQueryParameter("tty", "true");
        }
        if (this.in != null || this.inPipe != null) {
            httpUrlBuilder.addQueryParameter("stdin", "true");
        }
        if (this.out != null || this.outPipe != null) {
            httpUrlBuilder.addQueryParameter("stdout", "true");
        }
        if (this.err != null || this.errPipe != null) {
            httpUrlBuilder.addQueryParameter("stderr", "true");
        }
        return httpUrlBuilder.build();
    }

    @Override
    public CopyOrReadable<Boolean, InputStream, Boolean> file(String file) {
        return new PodOperationsImpl(this.getContext().withFile(file), this.context);
    }

    @Override
    public CopyOrReadable<Boolean, InputStream, Boolean> dir(String dir) {
        return new PodOperationsImpl(this.getContext().withDir(dir), this.context);
    }

    @Override
    public Boolean copy(Path destination) {
        try {
            if (Utils.isNotNullOrEmpty(this.getContext().getFile())) {
                this.copyFile(this.getContext().getFile(), destination.toFile());
                return true;
            }
            if (Utils.isNotNullOrEmpty(this.getContext().getDir())) {
                this.copyDir(this.getContext().getDir(), destination.toFile());
                return true;
            }
            throw new IllegalStateException("No file or dir has been specified");
        }
        catch (Exception e) {
            throw KubernetesClientException.launderThrowable(e);
        }
    }

    @Override
    public Boolean upload(InputStream inputStream) {
        return OptionalDependencyWrapper.wrapRunWithOptionalDependency(() -> {
            try {
                return PodUpload.uploadFileData(this.httpClient, this.getContext(), this, inputStream);
            }
            catch (Exception ex) {
                Thread.currentThread().interrupt();
                throw KubernetesClientException.launderThrowable(ex);
            }
        }, "TarArchiveOutputStream is provided by commons-compress");
    }

    @Override
    public Boolean upload(Path path) {
        return OptionalDependencyWrapper.wrapRunWithOptionalDependency(() -> {
            try {
                return PodUpload.upload(this.httpClient, this.getContext(), this, path);
            }
            catch (Exception ex) {
                Thread.currentThread().interrupt();
                throw KubernetesClientException.launderThrowable(ex);
            }
        }, "TarArchiveOutputStream is provided by commons-compress");
    }

    @Override
    public InputStream read() {
        try {
            if (Utils.isNotNullOrEmpty(this.getContext().getFile())) {
                return this.readFile(this.getContext().getFile());
            }
            if (Utils.isNotNullOrEmpty(this.getContext().getDir())) {
                return this.readTar(this.getContext().getDir());
            }
            throw new IllegalStateException("No file or dir has been specified");
        }
        catch (Exception e) {
            throw KubernetesClientException.launderThrowable(e);
        }
    }

    private InputStream readFile(String source) {
        try {
            PipedOutputStream out = new PipedOutputStream();
            PipedInputStream in = new PipedInputStream(out, 1024);
            final ExecWatch watch = (ExecWatch)((Execable)this.writingOutput(out).usingListener((code, reason) -> {
                try {
                    out.flush();
                    out.close();
                }
                catch (IOException e) {
                    throw KubernetesClientException.launderThrowable(e);
                }
            })).exec("sh", "-c", String.format("cat %s | base64", PodOperationsImpl.shellQuote(source)));
            return new Base64.InputStream(in){

                @Override
                public void close() throws IOException {
                    watch.close();
                    super.close();
                }
            };
        }
        catch (Exception e) {
            throw KubernetesClientException.launderThrowable(e);
        }
    }

    private void copyFile(String source, File target) {
        File destination = target;
        if (!(destination.exists() || destination.getParentFile().exists() || destination.getParentFile().mkdirs())) {
            throw KubernetesClientException.launderThrowable(new IOException("Failed to create directory: " + destination.getParentFile()));
        }
        if (destination.isDirectory()) {
            String[] parts = source.split("\\/|\\\\");
            String filename = parts[parts.length - 1];
            destination = destination.toPath().resolve(filename).toFile();
        }
        try (InputStream is = this.readFile(source);){
            Files.copy(is, destination.toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
        catch (Exception e) {
            throw KubernetesClientException.launderThrowable(e);
        }
    }

    public InputStream readTar(String source) {
        try {
            PipedOutputStream out = new PipedOutputStream();
            PipedInputStream in = new PipedInputStream(out, 1024);
            final ExecWatch watch = (ExecWatch)((Execable)this.writingOutput(out).usingListener((code, reason) -> {
                try {
                    out.flush();
                    out.close();
                }
                catch (IOException e) {
                    throw KubernetesClientException.launderThrowable(e);
                }
            })).exec("sh", "-c", "tar -cf - " + source + "|base64");
            return new Base64.InputStream(in){

                @Override
                public void close() throws IOException {
                    watch.close();
                    super.close();
                }
            };
        }
        catch (Exception e) {
            throw KubernetesClientException.launderThrowable(e);
        }
    }

    private void copyDir(final String source, final File target) throws Exception {
        try {
            new Runnable(){

                @Override
                public void run() {
                    File destination = target;
                    if (!destination.isDirectory() && !destination.mkdirs()) {
                        throw KubernetesClientException.launderThrowable(new IOException("Failed to create directory: " + destination));
                    }
                    try (InputStream is = PodOperationsImpl.this.readTar(source);
                         TarArchiveInputStream tis = new TarArchiveInputStream(is);){
                        TarArchiveEntry entry = tis.getNextTarEntry();
                        while (entry != null) {
                            if (tis.canReadEntryData((ArchiveEntry)entry)) {
                                String normalizedEntryName = FilenameUtils.normalize(entry.getName());
                                if (normalizedEntryName == null) {
                                    throw new IOException("Tar entry '" + entry.getName() + "' has an invalid name");
                                }
                                File f = new File(destination, normalizedEntryName);
                                if (entry.isDirectory()) {
                                    if (!f.isDirectory() && !f.mkdirs()) {
                                        throw new IOException("Failed to create directory: " + f);
                                    }
                                } else {
                                    File parent = f.getParentFile();
                                    if (!parent.isDirectory() && !parent.mkdirs()) {
                                        throw new IOException("Failed to create directory: " + f);
                                    }
                                    Files.copy((InputStream)tis, f.toPath(), StandardCopyOption.REPLACE_EXISTING);
                                }
                            }
                            entry = tis.getNextEntry();
                        }
                    }
                    catch (Exception e) {
                        throw KubernetesClientException.launderThrowable(e);
                    }
                }
            }.run();
        }
        catch (NoClassDefFoundError e) {
            throw new KubernetesClientException("TarArchiveInputStream class is provided by commons-compress, an optional dependency. To use the read/copy functionality you must explicitly add this dependency to the classpath.");
        }
    }

    @Override
    public TtyExecOutputErrorable<String, OutputStream, PipedInputStream, ExecWatch> readingInput(InputStream in) {
        return new PodOperationsImpl(this.getContext().withIn(in), this.context);
    }

    @Override
    public TtyExecOutputErrorable<String, OutputStream, PipedInputStream, ExecWatch> writingInput(PipedOutputStream inPipe) {
        return new PodOperationsImpl(this.getContext().withInPipe(inPipe), this.context);
    }

    @Override
    public TtyExecOutputErrorable<String, OutputStream, PipedInputStream, ExecWatch> redirectingInput() {
        return this.redirectingInput(null);
    }

    @Override
    public TtyExecOutputErrorable<String, OutputStream, PipedInputStream, ExecWatch> redirectingInput(Integer bufferSize) {
        return new PodOperationsImpl(this.getContext().withInPipe(new PipedOutputStream()).withBufferSize(bufferSize), this.context);
    }

    @Override
    public TtyExecErrorable<String, OutputStream, PipedInputStream, ExecWatch> writingOutput(OutputStream out) {
        return new PodOperationsImpl(this.getContext().withOut(out), this.context);
    }

    @Override
    public TtyExecErrorable<String, OutputStream, PipedInputStream, ExecWatch> readingOutput(PipedInputStream outPipe) {
        return new PodOperationsImpl(this.getContext().withOutPipe(outPipe), this.context);
    }

    @Override
    public TtyExecErrorable<String, OutputStream, PipedInputStream, ExecWatch> redirectingOutput() {
        return this.readingOutput(new PipedInputStream());
    }

    @Override
    public TtyExecErrorChannelable<String, OutputStream, PipedInputStream, ExecWatch> writingError(OutputStream err) {
        return new PodOperationsImpl(this.getContext().withErr(err), this.context);
    }

    @Override
    public TtyExecErrorChannelable<String, OutputStream, PipedInputStream, ExecWatch> readingError(PipedInputStream errPipe) {
        return new PodOperationsImpl(this.getContext().withErrPipe(errPipe), this.context);
    }

    @Override
    public TtyExecErrorChannelable<String, OutputStream, PipedInputStream, ExecWatch> redirectingError() {
        return this.readingError(new PipedInputStream());
    }

    @Override
    public TtyExecable<String, ExecWatch> writingErrorChannel(OutputStream errChannel) {
        return new PodOperationsImpl(this.getContext().withErrChannel(errChannel), this.context);
    }

    @Override
    public TtyExecable<String, ExecWatch> readingErrorChannel(PipedInputStream errChannelPipe) {
        return new PodOperationsImpl(this.getContext().withErrChannelPipe(errChannelPipe), this.context);
    }

    @Override
    public TtyExecable<String, ExecWatch> redirectingErrorChannel() {
        return this.readingErrorChannel(new PipedInputStream());
    }

    @Override
    public ExecListenable<String, ExecWatch> withTTY() {
        return new PodOperationsImpl(this.getContext().withTty(true), this.context);
    }

    @Override
    public Loggable<LogWatch> withPrettyOutput() {
        return new PodOperationsImpl(this.getContext().withPrettyOutput(true), this.context);
    }

    @Override
    public PrettyLoggable<LogWatch> tailingLines(int withTailingLines) {
        return new PodOperationsImpl(this.getContext().withTailingLines(withTailingLines), this.context);
    }

    @Override
    public TailPrettyLoggable<LogWatch> sinceTime(String sinceTimestamp) {
        return new PodOperationsImpl(this.getContext().withSinceTimestamp(sinceTimestamp), this.context);
    }

    @Override
    public TailPrettyLoggable<LogWatch> sinceSeconds(int sinceSeconds) {
        return new PodOperationsImpl(this.getContext().withSinceSeconds(sinceSeconds), this.context);
    }

    @Override
    public TimeTailPrettyLoggable<LogWatch> terminated() {
        return new PodOperationsImpl(this.getContext().withTerminatedStatus(true), this.context);
    }

    @Override
    public Execable<String, ExecWatch> usingListener(ExecListener execListener) {
        return new PodOperationsImpl(this.getContext().withExecListener(execListener), this.context);
    }

    @Override
    public BytesLimitTerminateTimeTailPrettyLoggable<LogWatch> limitBytes(int limitBytes) {
        return new PodOperationsImpl(this.getContext().withLimitBytes(limitBytes), this.context);
    }

    @Override
    public BytesLimitTerminateTimeTailPrettyLoggable<LogWatch> usingTimestamps() {
        return new PodOperationsImpl(this.getContext().withTimestamps(true), this.context);
    }

    public static String shellQuote(String value) {
        return "'" + value.replace("'", "'\\\\''") + "'";
    }
}

