/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.clnt.v5_12.dsl.base;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.fabric8.kubernetes.api.model.v5_12.DeleteOptions;
import io.fabric8.kubernetes.api.model.v5_12.DeletionPropagation;
import io.fabric8.kubernetes.api.model.v5_12.HasMetadata;
import io.fabric8.kubernetes.api.model.v5_12.ObjectMeta;
import io.fabric8.kubernetes.api.model.v5_12.Preconditions;
import io.fabric8.kubernetes.api.model.v5_12.Status;
import io.fabric8.kubernetes.api.model.v5_12.StatusBuilder;
import io.fabric8.kubernetes.api.model.v5_12.autoscaling.v1.Scale;
import io.fabric8.kubernetes.api.model.v5_12.extensions.DeploymentRollback;
import io.fabric8.kubernetes.clnt.v5_12.Config;
import io.fabric8.kubernetes.clnt.v5_12.KubernetesClientException;
import io.fabric8.kubernetes.clnt.v5_12.dsl.base.OperationContext;
import io.fabric8.kubernetes.clnt.v5_12.dsl.base.PatchContext;
import io.fabric8.kubernetes.clnt.v5_12.dsl.base.PatchType;
import io.fabric8.kubernetes.clnt.v5_12.http.HttpClient;
import io.fabric8.kubernetes.clnt.v5_12.http.HttpRequest;
import io.fabric8.kubernetes.clnt.v5_12.http.HttpResponse;
import io.fabric8.kubernetes.clnt.v5_12.internal.PatchUtils;
import io.fabric8.kubernetes.clnt.v5_12.internal.VersionUsageUtils;
import io.fabric8.kubernetes.clnt.v5_12.utils.ExponentialBackoffIntervalCalculator;
import io.fabric8.kubernetes.clnt.v5_12.utils.KubernetesResourceUtil;
import io.fabric8.kubernetes.clnt.v5_12.utils.Serialization;
import io.fabric8.kubernetes.clnt.v5_12.utils.URLUtils;
import io.fabric8.kubernetes.clnt.v5_12.utils.Utils;
import io.fabric8.zjsonpatch.JsonDiff;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OperationSupport {
    public static final String JSON = "application/json";
    public static final String JSON_PATCH = "application/json-patch+json";
    public static final String STRATEGIC_MERGE_JSON_PATCH = "application/strategic-merge-patch+json";
    public static final String JSON_MERGE_PATCH = "application/merge-patch+json";
    protected static final ObjectMapper JSON_MAPPER = Serialization.jsonMapper();
    private static final Logger LOG = LoggerFactory.getLogger(OperationSupport.class);
    private static final String CLIENT_STATUS_FLAG = "CLIENT_STATUS_FLAG";
    private static final int maxRetryIntervalExponent = 5;
    protected OperationContext context;
    protected final HttpClient httpClient;
    protected final Config config;
    protected final String resourceT;
    protected String namespace;
    protected String name;
    protected String apiGroupName;
    protected String apiGroupVersion;
    protected boolean dryRun;
    private final ExponentialBackoffIntervalCalculator retryIntervalCalculator;
    private final int requestRetryBackoffLimit;

    public OperationSupport() {
        this(new OperationContext());
    }

    public OperationSupport(HttpClient client, Config config) {
        this(new OperationContext().withHttpClient(client).withConfig(config));
    }

    public OperationSupport(OperationContext ctx) {
        int requestRetryBackoffInterval;
        this.context = ctx;
        this.httpClient = ctx.getClient();
        this.config = ctx.getConfig();
        this.resourceT = ctx.getPlural();
        this.namespace = ctx.getNamespace();
        this.name = ctx.getName();
        this.apiGroupName = ctx.getApiGroupName();
        this.dryRun = ctx.getDryRun();
        this.apiGroupVersion = ctx.getApiGroupVersion() != null ? ctx.getApiGroupVersion() : (ctx.getConfig() != null ? ctx.getConfig().getApiVersion() : "v1");
        if (ctx.getConfig() != null) {
            requestRetryBackoffInterval = ctx.getConfig().getRequestRetryBackoffInterval();
            this.requestRetryBackoffLimit = ctx.getConfig().getRequestRetryBackoffLimit();
        } else {
            requestRetryBackoffInterval = Config.DEFAULT_REQUEST_RETRY_BACKOFFINTERVAL;
            this.requestRetryBackoffLimit = Config.DEFAULT_REQUEST_RETRY_BACKOFFLIMIT;
        }
        this.retryIntervalCalculator = new ExponentialBackoffIntervalCalculator(requestRetryBackoffInterval, 5);
    }

    public String getAPIGroupName() {
        return this.apiGroupName;
    }

    public String getAPIGroupVersion() {
        return this.apiGroupVersion;
    }

    public String getResourceT() {
        return this.resourceT;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getName() {
        return this.name;
    }

    public boolean isResourceNamespaced() {
        return true;
    }

    public URL getRootUrl() {
        try {
            if (!Utils.isNullOrEmpty(this.apiGroupName)) {
                return new URL(URLUtils.join(this.config.getMasterUrl().toString(), "apis", this.apiGroupName, this.apiGroupVersion));
            }
            return new URL(URLUtils.join(this.config.getMasterUrl().toString(), "api", this.apiGroupVersion));
        }
        catch (MalformedURLException e) {
            throw KubernetesClientException.launderThrowable(e);
        }
    }

    public URL getNamespacedUrl(String namespace) throws MalformedURLException {
        URL requestUrl = this.getRootUrl();
        if (this.isResourceNamespaced() && Utils.isNotNullOrEmpty(namespace)) {
            requestUrl = new URL(URLUtils.join(requestUrl.toString(), "namespaces", namespace));
        }
        requestUrl = new URL(URLUtils.join(requestUrl.toString(), this.resourceT));
        return requestUrl;
    }

    public URL getNamespacedUrl() throws MalformedURLException {
        return this.getNamespacedUrl(this.getNamespace());
    }

    public <T> URL getNamespacedUrl(T item) throws MalformedURLException {
        return this.getNamespacedUrl(this.checkNamespace(item));
    }

    public URL getResourceUrl(String namespace, String name) throws MalformedURLException {
        return this.getResourceUrl(namespace, name, false);
    }

    public URL getResourceUrl(String namespace, String name, boolean status) throws MalformedURLException {
        if (name == null) {
            if (status) {
                throw new KubernetesClientException("name not specified for an operation requiring one.");
            }
            return this.getNamespacedUrl(namespace);
        }
        if (status) {
            return new URL(URLUtils.join(this.getNamespacedUrl(namespace).toString(), name, "status"));
        }
        return new URL(URLUtils.join(this.getNamespacedUrl(namespace).toString(), name));
    }

    public URL getResourceUrl() throws MalformedURLException {
        if (this.name == null) {
            return this.getNamespacedUrl();
        }
        return new URL(URLUtils.join(this.getNamespacedUrl().toString(), this.name));
    }

    public URL getResourceURLForWriteOperation(URL resourceURL) throws MalformedURLException {
        if (this.dryRun) {
            return new URL(URLUtils.join(resourceURL.toString(), "?dryRun=All"));
        }
        return resourceURL;
    }

    public URL getResourceURLForPatchOperation(URL resourceUrl, PatchContext patchContext) throws MalformedURLException {
        if (patchContext != null) {
            String url = resourceUrl.toString();
            if (patchContext.getForce() != null) {
                url = URLUtils.join(url, "?force=" + patchContext.getForce());
            }
            if (patchContext.getDryRun() != null && !patchContext.getDryRun().isEmpty() || this.dryRun) {
                url = URLUtils.join(url, "?dryRun=All");
            }
            if (patchContext.getFieldManager() != null) {
                url = URLUtils.join(url, "?fieldManager=" + patchContext.getFieldManager());
            }
            return new URL(url);
        }
        return resourceUrl;
    }

    protected <T> String checkNamespace(T item) {
        String itemNs;
        String operationNs = this.getNamespace();
        String string = itemNs = item instanceof HasMetadata ? KubernetesResourceUtil.getNamespace((HasMetadata)item) : null;
        if (Utils.isNullOrEmpty(operationNs) && Utils.isNullOrEmpty(itemNs)) {
            if (!this.isResourceNamespaced()) {
                return null;
            }
            throw new KubernetesClientException("namespace not specified for an operation requiring one.");
        }
        if (Utils.isNullOrEmpty(itemNs)) {
            return operationNs;
        }
        if (Utils.isNullOrEmpty(operationNs)) {
            return itemNs;
        }
        if (itemNs.equals(operationNs)) {
            return itemNs;
        }
        throw new KubernetesClientException("Namespace mismatch. Item namespace:" + itemNs + ". Operation namespace:" + operationNs + ".");
    }

    protected <T> String checkName(T item) {
        String itemName;
        String operationName = this.getName();
        ObjectMeta metadata = item instanceof HasMetadata ? ((HasMetadata)item).getMetadata() : null;
        String string = itemName = metadata != null ? metadata.getName() : null;
        if (Utils.isNullOrEmpty(operationName) && Utils.isNullOrEmpty(itemName)) {
            return null;
        }
        if (Utils.isNullOrEmpty(itemName)) {
            return operationName;
        }
        if (Utils.isNullOrEmpty(operationName)) {
            return itemName;
        }
        if (itemName.equals(operationName)) {
            return itemName;
        }
        throw new KubernetesClientException("Name mismatch. Item name:" + itemName + ". Operation name:" + operationName + ".");
    }

    protected <T> T handleMetric(String resourceUrl, Class<T> type) throws InterruptedException, IOException {
        HttpRequest.Builder requestBuilder = this.httpClient.newHttpRequestBuilder().uri(resourceUrl);
        return this.handleResponse(requestBuilder, type);
    }

    protected <T> void handleDelete(T resource, long gracePeriodSeconds, DeletionPropagation propagationPolicy, String resourceVersion, boolean cascading) throws InterruptedException, IOException {
        this.handleDelete(this.getResourceURLForWriteOperation(this.getResourceUrl(this.checkNamespace(resource), this.checkName(resource))), gracePeriodSeconds, propagationPolicy, resourceVersion, cascading);
    }

    protected void handleDelete(URL requestUrl, long gracePeriodSeconds, DeletionPropagation propagationPolicy, String resourceVersion, boolean cascading) throws InterruptedException, IOException {
        DeleteOptions deleteOptions = new DeleteOptions();
        if (gracePeriodSeconds >= 0L) {
            deleteOptions.setGracePeriodSeconds(gracePeriodSeconds);
        }
        if (resourceVersion != null) {
            deleteOptions.setPreconditions(new Preconditions(resourceVersion, null));
        }
        if (propagationPolicy != null) {
            deleteOptions.setPropagationPolicy(propagationPolicy.toString());
        } else {
            deleteOptions.setOrphanDependents(!cascading);
        }
        if (this.dryRun) {
            deleteOptions.setDryRun(Collections.singletonList("All"));
        }
        HttpRequest.Builder requestBuilder = this.httpClient.newHttpRequestBuilder().delete(JSON, JSON_MAPPER.writeValueAsString((Object)deleteOptions)).url(requestUrl);
        this.handleResponse(requestBuilder, null, Collections.emptyMap());
    }

    protected <T, I> T handleCreate(I resource, Class<T> outputType) throws InterruptedException, IOException {
        HttpRequest.Builder requestBuilder = this.httpClient.newHttpRequestBuilder().post(JSON, JSON_MAPPER.writeValueAsString(resource)).url(this.getResourceURLForWriteOperation(this.getResourceUrl(this.checkNamespace(resource), null)));
        return this.handleResponse(requestBuilder, outputType, Collections.emptyMap());
    }

    protected <T> T handleUpdate(T updated, Class<T> type, boolean status) throws InterruptedException, IOException {
        return this.handleUpdate(updated, type, Collections.emptyMap(), status);
    }

    protected <T> T handleUpdate(T updated, Class<T> type, Map<String, String> parameters, boolean status) throws InterruptedException, IOException {
        HttpRequest.Builder requestBuilder = this.httpClient.newHttpRequestBuilder().put(JSON, JSON_MAPPER.writeValueAsString(updated)).url(this.getResourceURLForWriteOperation(this.getResourceUrl(this.checkNamespace(updated), this.checkName(updated), status)));
        return this.handleResponse(requestBuilder, type, parameters);
    }

    protected <T> T handlePatch(PatchContext patchContext, T current, T updated, Class<T> type, boolean status) throws InterruptedException, IOException {
        String patchForUpdate = null;
        if (current != null && (patchContext == null || patchContext.getPatchType() == PatchType.JSON)) {
            patchForUpdate = JSON_MAPPER.writeValueAsString((Object)JsonDiff.asJson((JsonNode)PatchUtils.patchMapper().valueToTree(current), (JsonNode)PatchUtils.patchMapper().valueToTree(updated)));
            if (patchContext == null) {
                patchContext = new PatchContext.Builder().withPatchType(PatchType.JSON).build();
            }
        } else {
            patchForUpdate = Serialization.asJson(updated);
            current = updated;
        }
        return this.handlePatch(patchContext, current, patchForUpdate, type, status);
    }

    protected <T> T handlePatch(T current, Map<String, Object> patchForUpdate, Class<T> type) throws InterruptedException, IOException {
        return this.handlePatch(new PatchContext.Builder().withPatchType(PatchType.STRATEGIC_MERGE).build(), current, JSON_MAPPER.writeValueAsString(patchForUpdate), type, false);
    }

    protected <T> T handlePatch(PatchContext patchContext, T current, String patchForUpdate, Class<T> type, boolean status) throws InterruptedException, IOException {
        String bodyContentType = this.getContentTypeFromPatchContextOrDefault(patchContext);
        HttpRequest.Builder requestBuilder = this.httpClient.newHttpRequestBuilder().patch(bodyContentType, patchForUpdate).url(this.getResourceURLForPatchOperation(this.getResourceUrl(this.checkNamespace(current), this.checkName(current), status), patchContext));
        return this.handleResponse(requestBuilder, type, Collections.emptyMap());
    }

    protected Scale handleScale(String resourceUrl, Scale scale) throws InterruptedException, IOException {
        HttpRequest.Builder requestBuilder = this.httpClient.newHttpRequestBuilder().uri(resourceUrl + "/scale");
        if (scale != null) {
            requestBuilder.put(JSON, JSON_MAPPER.writeValueAsString((Object)scale));
        }
        return this.handleResponse(requestBuilder, Scale.class);
    }

    protected Status handleDeploymentRollback(String resourceUrl, DeploymentRollback deploymentRollback) throws InterruptedException, IOException {
        HttpRequest.Builder requestBuilder = this.httpClient.newHttpRequestBuilder().uri(resourceUrl + "/rollback").post(JSON, JSON_MAPPER.writeValueAsString((Object)deploymentRollback));
        return this.handleResponse(requestBuilder, Status.class);
    }

    protected <T> T handleGet(URL resourceUrl, Class<T> type) throws InterruptedException, IOException {
        return this.handleGet(resourceUrl, type, Collections.emptyMap());
    }

    protected <T> T handleRawGet(URL resourceUrl, Class<T> type) throws IOException {
        HttpRequest.Builder requestBuilder = this.httpClient.newHttpRequestBuilder().url(resourceUrl);
        HttpRequest request = requestBuilder.build();
        HttpResponse<T> response = this.httpClient.send(request, type);
        this.assertResponseCode(request, response);
        return response.body();
    }

    protected <T> T handleGet(URL resourceUrl, Class<T> type, Map<String, String> parameters) throws InterruptedException, IOException {
        HttpRequest.Builder requestBuilder = this.httpClient.newHttpRequestBuilder().url(resourceUrl);
        return this.handleResponse(requestBuilder, type, parameters);
    }

    protected <T> T handleResponse(HttpRequest.Builder requestBuilder, Class<T> type) throws InterruptedException, IOException {
        return this.handleResponse(requestBuilder, type, Collections.emptyMap());
    }

    protected <T> T handleResponse(HttpRequest.Builder requestBuilder, Class<T> type, Map<String, String> parameters) throws InterruptedException, IOException {
        return this.handleResponse(this.httpClient, requestBuilder, type, parameters);
    }

    protected <T> T handleResponse(HttpClient client, HttpRequest.Builder requestBuilder, Class<T> type) throws InterruptedException, IOException {
        return this.handleResponse(client, requestBuilder, type, Collections.emptyMap());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected <T> T handleResponse(HttpClient client, HttpRequest.Builder requestBuilder, Class<T> type, Map<String, String> parameters) throws InterruptedException, IOException {
        VersionUsageUtils.log(this.resourceT, this.apiGroupVersion);
        HttpRequest request = requestBuilder.build();
        HttpResponse<InputStream> response = this.retryWithExponentialBackoff(client, request);
        try (InputStream bodyInputStream = response.body();){
            this.assertResponseCode(request, response);
            if (type != null) {
                T t = Serialization.unmarshal(bodyInputStream, type, parameters);
                return t;
            }
            T t = null;
            return t;
        }
        catch (Exception e) {
            if (!(e instanceof KubernetesClientException)) throw OperationSupport.requestException(request, e);
            throw e;
        }
    }

    protected HttpResponse<InputStream> retryWithExponentialBackoff(HttpClient client, HttpRequest request) throws InterruptedException, IOException {
        int numRetries = 0;
        while (true) {
            long retryInterval;
            block6: {
                try {
                    HttpResponse<InputStream> response = client.send(request, InputStream.class);
                    if (numRetries < this.requestRetryBackoffLimit && response.code() >= 500) {
                        retryInterval = this.retryIntervalCalculator.getInterval(numRetries);
                        LOG.debug("HTTP operation on url: {} should be retried as the response code was {}, retrying after {} millis", new Object[]{request.uri(), response.code(), retryInterval});
                        if (response.body() != null) {
                            response.body().close();
                        }
                        break block6;
                    }
                    return response;
                }
                catch (IOException ie) {
                    if (numRetries < this.requestRetryBackoffLimit) {
                        retryInterval = this.retryIntervalCalculator.getInterval(numRetries);
                        LOG.debug(String.format("HTTP operation on url: %s should be retried after %d millis because of IOException", request.uri(), retryInterval), (Throwable)ie);
                    }
                    throw ie;
                }
            }
            Thread.sleep(retryInterval);
            ++numRetries;
        }
    }

    protected void assertResponseCode(HttpRequest request, HttpResponse<?> response) {
        int statusCode = response.code();
        String customMessage = this.config.getErrorMessages().get(statusCode);
        if (response.isSuccessful()) {
            return;
        }
        if (customMessage != null) {
            throw OperationSupport.requestFailure(request, OperationSupport.createStatus(statusCode, this.combineMessages(customMessage, OperationSupport.createStatus(response))));
        }
        throw OperationSupport.requestFailure(request, OperationSupport.createStatus(response));
    }

    private String combineMessages(String customMessage, Status defaultStatus) {
        String message;
        if (defaultStatus != null && (message = defaultStatus.getMessage()) != null && message.length() > 0) {
            return customMessage + " " + message;
        }
        return customMessage;
    }

    public static Status createStatus(HttpResponse<?> response) {
        int statusCode;
        String statusMessage = "";
        int n = statusCode = response != null ? response.code() : 0;
        if (response == null) {
            statusMessage = "No response";
        } else {
            try {
                String bodyString = response.bodyString();
                if (Utils.isNotNullOrEmpty(bodyString)) {
                    Status status = (Status)JSON_MAPPER.readValue(bodyString, Status.class);
                    if (status.getCode() == null) {
                        status = ((StatusBuilder)new StatusBuilder(status).withCode(statusCode)).build();
                    }
                    return status;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (response.message() != null) {
                statusMessage = response.message();
            }
        }
        return OperationSupport.createStatus(statusCode, statusMessage);
    }

    public static Status createStatus(int statusCode, String message) {
        Status status = ((StatusBuilder)((StatusBuilder)new StatusBuilder().withCode(statusCode)).withMessage(message)).build();
        status.getAdditionalProperties().put(CLIENT_STATUS_FLAG, "true");
        return status;
    }

    public static KubernetesClientException requestFailure(HttpRequest request, Status status) {
        return OperationSupport.requestFailure(request, status, null);
    }

    public static KubernetesClientException requestFailure(HttpRequest request, Status status, String message) {
        StringBuilder sb = new StringBuilder();
        if (message != null && !message.isEmpty()) {
            sb.append(message).append(". ");
        }
        sb.append("Failure executing: ").append(request.method()).append(" at: ").append(request.uri()).append(".");
        if (status.getMessage() != null && !status.getMessage().isEmpty()) {
            sb.append(" Message: ").append(status.getMessage()).append(".");
        }
        if (!status.getAdditionalProperties().containsKey(CLIENT_STATUS_FLAG)) {
            sb.append(" Received status: ").append(status).append(".");
        }
        return new KubernetesClientException(sb.toString(), null, (int)status.getCode(), status, request);
    }

    public static KubernetesClientException requestException(HttpRequest request, Throwable e, String message) {
        StringBuilder sb = new StringBuilder();
        if (message != null && !message.isEmpty()) {
            sb.append(message).append(". ");
        }
        sb.append("Error executing: ").append(request.method()).append(" at: ").append(request.uri()).append(". Cause: ").append(e.getMessage());
        return new KubernetesClientException(sb.toString(), e, -1, null, request);
    }

    public static KubernetesClientException requestException(HttpRequest request, Exception e) {
        return OperationSupport.requestException(request, e, null);
    }

    protected static <T> T unmarshal(InputStream is) {
        return Serialization.unmarshal(is);
    }

    protected static <T> T unmarshal(InputStream is, Class<T> type) {
        return Serialization.unmarshal(is, type);
    }

    protected static <T> T unmarshal(InputStream is, TypeReference<T> type) {
        return Serialization.unmarshal(is, type);
    }

    protected static <T> Map getObjectValueAsMap(T object) {
        return (Map)JSON_MAPPER.convertValue(object, Map.class);
    }

    public Config getConfig() {
        return this.config;
    }

    private String getContentTypeFromPatchContextOrDefault(PatchContext patchContext) {
        if (patchContext != null && patchContext.getPatchType() != null) {
            return patchContext.getPatchType().getContentType();
        }
        return STRATEGIC_MERGE_JSON_PATCH;
    }

    public <R1> R1 restCall(Class<R1> result, String ... path) {
        try {
            URL requestUrl = new URL(this.config.getMasterUrl());
            String url = requestUrl.toString();
            if (path != null && path.length > 0) {
                url = URLUtils.join(url, URLUtils.pathJoin(path));
            }
            HttpRequest.Builder req = this.httpClient.newHttpRequestBuilder().uri(url);
            return this.handleResponse(req, result);
        }
        catch (KubernetesClientException e) {
            if (e.getCode() != 404) {
                throw e;
            }
            return null;
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
            throw KubernetesClientException.launderThrowable(ie);
        }
        catch (IOException e) {
            throw KubernetesClientException.launderThrowable(e);
        }
    }
}

