/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.clnt.v5_12;

import io.fabric8.kubernetes.api.builder.v5_12.VisitableBuilder;
import io.fabric8.kubernetes.api.model.v5_12.HasMetadata;
import io.fabric8.kubernetes.api.model.v5_12.KubernetesResourceList;
import io.fabric8.kubernetes.clnt.v5_12.ClientContext;
import io.fabric8.kubernetes.clnt.v5_12.KubernetesClientException;
import io.fabric8.kubernetes.clnt.v5_12.ResourceHandler;
import io.fabric8.kubernetes.clnt.v5_12.dsl.Resource;
import io.fabric8.kubernetes.clnt.v5_12.dsl.base.HasMetadataOperation;
import io.fabric8.kubernetes.clnt.v5_12.dsl.base.ResourceDefinitionContext;
import io.fabric8.kubernetes.clnt.v5_12.dsl.internal.HasMetadataOperationsImpl;
import io.fabric8.kubernetes.clnt.v5_12.utils.KubernetesResourceUtil;
import io.fabric8.kubernetes.clnt.v5_12.utils.Utils;
import java.lang.reflect.InvocationTargetException;
import java.util.function.Function;

class ResourceHandlerImpl<T extends HasMetadata, V extends VisitableBuilder<T, V>>
implements ResourceHandler<T, V> {
    private final ResourceDefinitionContext context;
    private final Class<T> type;
    private final Class<V> builderClass;
    private final Class<? extends KubernetesResourceList<T>> defaultListClass;
    private final Function<ClientContext, HasMetadataOperation<T, ?, Resource<T>>> operationConstructor;

    ResourceHandlerImpl(Class<T> type, Function<ClientContext, HasMetadataOperation<T, ?, Resource<T>>> operationConstructor) {
        this.type = type;
        this.context = ResourceDefinitionContext.fromResourceType(type);
        this.builderClass = KubernetesResourceUtil.inferBuilderType(type);
        this.defaultListClass = KubernetesResourceUtil.inferListType(type);
        this.operationConstructor = operationConstructor;
    }

    ResourceHandlerImpl(Class<T> type, Class<? extends KubernetesResourceList<T>> listClass, ResourceDefinitionContext context) {
        this.type = type;
        this.context = context;
        this.defaultListClass = listClass;
        this.builderClass = KubernetesResourceUtil.inferBuilderType(type);
        this.operationConstructor = null;
    }

    @Override
    public V edit(T item) {
        if (this.builderClass == null) {
            throw new KubernetesClientException(String.format("Cannot edit %s with visitors, no builder was found", this.type.getName()));
        }
        try {
            return (V)((VisitableBuilder)this.builderClass.getDeclaredConstructor(item.getClass()).newInstance(item));
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw KubernetesClientException.launderThrowable(e);
        }
    }

    @Override
    public <L extends KubernetesResourceList<T>> HasMetadataOperation<T, L, Resource<T>> operation(ClientContext clientContext, Class<L> listType) {
        if (this.operationConstructor != null) {
            if (listType != null && !listType.isAssignableFrom(this.defaultListClass)) {
                throw new IllegalArgumentException(String.format("Handler type %s with list %s not compatible with %s", this.type, this.defaultListClass.getName(), listType.getName()));
            }
            return this.operationConstructor.apply(clientContext);
        }
        return new HasMetadataOperationsImpl<T, KubernetesResourceList<T>>(clientContext, this.context, this.type, Utils.getNonNullOrElse(listType, this.defaultListClass));
    }

    @Override
    public boolean hasOperation() {
        return this.operationConstructor != null;
    }
}

