/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v5_12.admissionregistration.v1beta1;

import io.fabric8.kubernetes.api.builder.v5_12.BaseFluent;
import io.fabric8.kubernetes.api.builder.v5_12.Nested;
import io.fabric8.kubernetes.api.model.v5_12.LabelSelector;
import io.fabric8.kubernetes.api.model.v5_12.LabelSelectorBuilder;
import io.fabric8.kubernetes.api.model.v5_12.LabelSelectorFluentImpl;
import io.fabric8.kubernetes.api.model.v5_12.admissionregistration.v1beta1.MutatingWebhook;
import io.fabric8.kubernetes.api.model.v5_12.admissionregistration.v1beta1.MutatingWebhookFluent;
import io.fabric8.kubernetes.api.model.v5_12.admissionregistration.v1beta1.RuleWithOperations;
import io.fabric8.kubernetes.api.model.v5_12.admissionregistration.v1beta1.RuleWithOperationsBuilder;
import io.fabric8.kubernetes.api.model.v5_12.admissionregistration.v1beta1.RuleWithOperationsFluentImpl;
import io.fabric8.kubernetes.api.model.v5_12.admissionregistration.v1beta1.WebhookClientConfig;
import io.fabric8.kubernetes.api.model.v5_12.admissionregistration.v1beta1.WebhookClientConfigBuilder;
import io.fabric8.kubernetes.api.model.v5_12.admissionregistration.v1beta1.WebhookClientConfigFluentImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class MutatingWebhookFluentImpl<A extends MutatingWebhookFluent<A>>
extends BaseFluent<A>
implements MutatingWebhookFluent<A> {
    private List<String> admissionReviewVersions = new ArrayList<String>();
    private WebhookClientConfigBuilder clientConfig;
    private String failurePolicy;
    private String matchPolicy;
    private String name;
    private LabelSelectorBuilder namespaceSelector;
    private LabelSelectorBuilder objectSelector;
    private String reinvocationPolicy;
    private List<RuleWithOperationsBuilder> rules = new ArrayList<RuleWithOperationsBuilder>();
    private String sideEffects;
    private Integer timeoutSeconds;
    private Map<String, Object> additionalProperties;

    public MutatingWebhookFluentImpl() {
    }

    public MutatingWebhookFluentImpl(MutatingWebhook instance) {
        this.withAdmissionReviewVersions(instance.getAdmissionReviewVersions());
        this.withClientConfig(instance.getClientConfig());
        this.withFailurePolicy(instance.getFailurePolicy());
        this.withMatchPolicy(instance.getMatchPolicy());
        this.withName(instance.getName());
        this.withNamespaceSelector(instance.getNamespaceSelector());
        this.withObjectSelector(instance.getObjectSelector());
        this.withReinvocationPolicy(instance.getReinvocationPolicy());
        this.withRules(instance.getRules());
        this.withSideEffects(instance.getSideEffects());
        this.withTimeoutSeconds(instance.getTimeoutSeconds());
        this.withAdditionalProperties(instance.getAdditionalProperties());
    }

    @Override
    public A addToAdmissionReviewVersions(Integer index, String item) {
        if (this.admissionReviewVersions == null) {
            this.admissionReviewVersions = new ArrayList<String>();
        }
        this.admissionReviewVersions.add(index, item);
        return (A)this;
    }

    @Override
    public A setToAdmissionReviewVersions(Integer index, String item) {
        if (this.admissionReviewVersions == null) {
            this.admissionReviewVersions = new ArrayList<String>();
        }
        this.admissionReviewVersions.set(index, item);
        return (A)this;
    }

    @Override
    public A addToAdmissionReviewVersions(String ... items) {
        if (this.admissionReviewVersions == null) {
            this.admissionReviewVersions = new ArrayList<String>();
        }
        for (String item : items) {
            this.admissionReviewVersions.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToAdmissionReviewVersions(Collection<String> items) {
        if (this.admissionReviewVersions == null) {
            this.admissionReviewVersions = new ArrayList<String>();
        }
        for (String item : items) {
            this.admissionReviewVersions.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdmissionReviewVersions(String ... items) {
        for (String item : items) {
            if (this.admissionReviewVersions == null) continue;
            this.admissionReviewVersions.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromAdmissionReviewVersions(Collection<String> items) {
        for (String item : items) {
            if (this.admissionReviewVersions == null) continue;
            this.admissionReviewVersions.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getAdmissionReviewVersions() {
        return this.admissionReviewVersions;
    }

    @Override
    public String getAdmissionReviewVersion(Integer index) {
        return this.admissionReviewVersions.get(index);
    }

    @Override
    public String getFirstAdmissionReviewVersion() {
        return this.admissionReviewVersions.get(0);
    }

    @Override
    public String getLastAdmissionReviewVersion() {
        return this.admissionReviewVersions.get(this.admissionReviewVersions.size() - 1);
    }

    @Override
    public String getMatchingAdmissionReviewVersion(Predicate<String> predicate) {
        for (String item : this.admissionReviewVersions) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingAdmissionReviewVersion(Predicate<String> predicate) {
        for (String item : this.admissionReviewVersions) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withAdmissionReviewVersions(List<String> admissionReviewVersions) {
        if (admissionReviewVersions != null) {
            this.admissionReviewVersions = new ArrayList<String>();
            for (String item : admissionReviewVersions) {
                this.addToAdmissionReviewVersions(item);
            }
        } else {
            this.admissionReviewVersions = null;
        }
        return (A)this;
    }

    @Override
    public A withAdmissionReviewVersions(String ... admissionReviewVersions) {
        if (this.admissionReviewVersions != null) {
            this.admissionReviewVersions.clear();
        }
        if (admissionReviewVersions != null) {
            for (String item : admissionReviewVersions) {
                this.addToAdmissionReviewVersions(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasAdmissionReviewVersions() {
        return this.admissionReviewVersions != null && !this.admissionReviewVersions.isEmpty();
    }

    @Override
    public A addNewAdmissionReviewVersion(String arg0) {
        return this.addToAdmissionReviewVersions(new String(arg0));
    }

    @Override
    @Deprecated
    public WebhookClientConfig getClientConfig() {
        return this.clientConfig != null ? this.clientConfig.build() : null;
    }

    @Override
    public WebhookClientConfig buildClientConfig() {
        return this.clientConfig != null ? this.clientConfig.build() : null;
    }

    @Override
    public A withClientConfig(WebhookClientConfig clientConfig) {
        this._visitables.get("clientConfig").remove(this.clientConfig);
        if (clientConfig != null) {
            this.clientConfig = new WebhookClientConfigBuilder(clientConfig);
            this._visitables.get("clientConfig").add(this.clientConfig);
        }
        return (A)this;
    }

    @Override
    public Boolean hasClientConfig() {
        return this.clientConfig != null;
    }

    @Override
    public MutatingWebhookFluent.ClientConfigNested<A> withNewClientConfig() {
        return new ClientConfigNestedImpl();
    }

    @Override
    public MutatingWebhookFluent.ClientConfigNested<A> withNewClientConfigLike(WebhookClientConfig item) {
        return new ClientConfigNestedImpl(item);
    }

    @Override
    public MutatingWebhookFluent.ClientConfigNested<A> editClientConfig() {
        return this.withNewClientConfigLike(this.getClientConfig());
    }

    @Override
    public MutatingWebhookFluent.ClientConfigNested<A> editOrNewClientConfig() {
        return this.withNewClientConfigLike(this.getClientConfig() != null ? this.getClientConfig() : new WebhookClientConfigBuilder().build());
    }

    @Override
    public MutatingWebhookFluent.ClientConfigNested<A> editOrNewClientConfigLike(WebhookClientConfig item) {
        return this.withNewClientConfigLike(this.getClientConfig() != null ? this.getClientConfig() : item);
    }

    @Override
    public String getFailurePolicy() {
        return this.failurePolicy;
    }

    @Override
    public A withFailurePolicy(String failurePolicy) {
        this.failurePolicy = failurePolicy;
        return (A)this;
    }

    @Override
    public Boolean hasFailurePolicy() {
        return this.failurePolicy != null;
    }

    @Override
    @Deprecated
    public A withNewFailurePolicy(String arg0) {
        return this.withFailurePolicy(new String(arg0));
    }

    @Override
    public String getMatchPolicy() {
        return this.matchPolicy;
    }

    @Override
    public A withMatchPolicy(String matchPolicy) {
        this.matchPolicy = matchPolicy;
        return (A)this;
    }

    @Override
    public Boolean hasMatchPolicy() {
        return this.matchPolicy != null;
    }

    @Override
    @Deprecated
    public A withNewMatchPolicy(String arg0) {
        return this.withMatchPolicy(new String(arg0));
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public A withName(String name) {
        this.name = name;
        return (A)this;
    }

    @Override
    public Boolean hasName() {
        return this.name != null;
    }

    @Override
    @Deprecated
    public A withNewName(String arg0) {
        return this.withName(new String(arg0));
    }

    @Override
    @Deprecated
    public LabelSelector getNamespaceSelector() {
        return this.namespaceSelector != null ? this.namespaceSelector.build() : null;
    }

    @Override
    public LabelSelector buildNamespaceSelector() {
        return this.namespaceSelector != null ? this.namespaceSelector.build() : null;
    }

    @Override
    public A withNamespaceSelector(LabelSelector namespaceSelector) {
        this._visitables.get("namespaceSelector").remove(this.namespaceSelector);
        if (namespaceSelector != null) {
            this.namespaceSelector = new LabelSelectorBuilder(namespaceSelector);
            this._visitables.get("namespaceSelector").add(this.namespaceSelector);
        }
        return (A)this;
    }

    @Override
    public Boolean hasNamespaceSelector() {
        return this.namespaceSelector != null;
    }

    @Override
    public MutatingWebhookFluent.NamespaceSelectorNested<A> withNewNamespaceSelector() {
        return new NamespaceSelectorNestedImpl();
    }

    @Override
    public MutatingWebhookFluent.NamespaceSelectorNested<A> withNewNamespaceSelectorLike(LabelSelector item) {
        return new NamespaceSelectorNestedImpl(item);
    }

    @Override
    public MutatingWebhookFluent.NamespaceSelectorNested<A> editNamespaceSelector() {
        return this.withNewNamespaceSelectorLike(this.getNamespaceSelector());
    }

    @Override
    public MutatingWebhookFluent.NamespaceSelectorNested<A> editOrNewNamespaceSelector() {
        return this.withNewNamespaceSelectorLike(this.getNamespaceSelector() != null ? this.getNamespaceSelector() : new LabelSelectorBuilder().build());
    }

    @Override
    public MutatingWebhookFluent.NamespaceSelectorNested<A> editOrNewNamespaceSelectorLike(LabelSelector item) {
        return this.withNewNamespaceSelectorLike(this.getNamespaceSelector() != null ? this.getNamespaceSelector() : item);
    }

    @Override
    @Deprecated
    public LabelSelector getObjectSelector() {
        return this.objectSelector != null ? this.objectSelector.build() : null;
    }

    @Override
    public LabelSelector buildObjectSelector() {
        return this.objectSelector != null ? this.objectSelector.build() : null;
    }

    @Override
    public A withObjectSelector(LabelSelector objectSelector) {
        this._visitables.get("objectSelector").remove(this.objectSelector);
        if (objectSelector != null) {
            this.objectSelector = new LabelSelectorBuilder(objectSelector);
            this._visitables.get("objectSelector").add(this.objectSelector);
        }
        return (A)this;
    }

    @Override
    public Boolean hasObjectSelector() {
        return this.objectSelector != null;
    }

    @Override
    public MutatingWebhookFluent.ObjectSelectorNested<A> withNewObjectSelector() {
        return new ObjectSelectorNestedImpl();
    }

    @Override
    public MutatingWebhookFluent.ObjectSelectorNested<A> withNewObjectSelectorLike(LabelSelector item) {
        return new ObjectSelectorNestedImpl(item);
    }

    @Override
    public MutatingWebhookFluent.ObjectSelectorNested<A> editObjectSelector() {
        return this.withNewObjectSelectorLike(this.getObjectSelector());
    }

    @Override
    public MutatingWebhookFluent.ObjectSelectorNested<A> editOrNewObjectSelector() {
        return this.withNewObjectSelectorLike(this.getObjectSelector() != null ? this.getObjectSelector() : new LabelSelectorBuilder().build());
    }

    @Override
    public MutatingWebhookFluent.ObjectSelectorNested<A> editOrNewObjectSelectorLike(LabelSelector item) {
        return this.withNewObjectSelectorLike(this.getObjectSelector() != null ? this.getObjectSelector() : item);
    }

    @Override
    public String getReinvocationPolicy() {
        return this.reinvocationPolicy;
    }

    @Override
    public A withReinvocationPolicy(String reinvocationPolicy) {
        this.reinvocationPolicy = reinvocationPolicy;
        return (A)this;
    }

    @Override
    public Boolean hasReinvocationPolicy() {
        return this.reinvocationPolicy != null;
    }

    @Override
    @Deprecated
    public A withNewReinvocationPolicy(String arg0) {
        return this.withReinvocationPolicy(new String(arg0));
    }

    @Override
    public A addToRules(Integer index, RuleWithOperations item) {
        if (this.rules == null) {
            this.rules = new ArrayList<RuleWithOperationsBuilder>();
        }
        RuleWithOperationsBuilder builder = new RuleWithOperationsBuilder(item);
        this._visitables.get("rules").add(index >= 0 ? index.intValue() : this._visitables.get("rules").size(), builder);
        this.rules.add(index >= 0 ? index.intValue() : this.rules.size(), builder);
        return (A)this;
    }

    @Override
    public A setToRules(Integer index, RuleWithOperations item) {
        if (this.rules == null) {
            this.rules = new ArrayList<RuleWithOperationsBuilder>();
        }
        RuleWithOperationsBuilder builder = new RuleWithOperationsBuilder(item);
        if (index < 0 || index >= this._visitables.get("rules").size()) {
            this._visitables.get("rules").add(builder);
        } else {
            this._visitables.get("rules").set(index, builder);
        }
        if (index < 0 || index >= this.rules.size()) {
            this.rules.add(builder);
        } else {
            this.rules.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToRules(RuleWithOperations ... items) {
        if (this.rules == null) {
            this.rules = new ArrayList<RuleWithOperationsBuilder>();
        }
        for (RuleWithOperations item : items) {
            RuleWithOperationsBuilder builder = new RuleWithOperationsBuilder(item);
            this._visitables.get("rules").add(builder);
            this.rules.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToRules(Collection<RuleWithOperations> items) {
        if (this.rules == null) {
            this.rules = new ArrayList<RuleWithOperationsBuilder>();
        }
        for (RuleWithOperations item : items) {
            RuleWithOperationsBuilder builder = new RuleWithOperationsBuilder(item);
            this._visitables.get("rules").add(builder);
            this.rules.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromRules(RuleWithOperations ... items) {
        for (RuleWithOperations item : items) {
            RuleWithOperationsBuilder builder = new RuleWithOperationsBuilder(item);
            this._visitables.get("rules").remove(builder);
            if (this.rules == null) continue;
            this.rules.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromRules(Collection<RuleWithOperations> items) {
        for (RuleWithOperations item : items) {
            RuleWithOperationsBuilder builder = new RuleWithOperationsBuilder(item);
            this._visitables.get("rules").remove(builder);
            if (this.rules == null) continue;
            this.rules.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromRules(Predicate<RuleWithOperationsBuilder> predicate) {
        if (this.rules == null) {
            return (A)this;
        }
        Iterator<RuleWithOperationsBuilder> each = this.rules.iterator();
        Object visitables = this._visitables.get("rules");
        while (each.hasNext()) {
            RuleWithOperationsBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<RuleWithOperations> getRules() {
        return MutatingWebhookFluentImpl.build(this.rules);
    }

    @Override
    public List<RuleWithOperations> buildRules() {
        return MutatingWebhookFluentImpl.build(this.rules);
    }

    @Override
    public RuleWithOperations buildRule(Integer index) {
        return this.rules.get(index).build();
    }

    @Override
    public RuleWithOperations buildFirstRule() {
        return this.rules.get(0).build();
    }

    @Override
    public RuleWithOperations buildLastRule() {
        return this.rules.get(this.rules.size() - 1).build();
    }

    @Override
    public RuleWithOperations buildMatchingRule(Predicate<RuleWithOperationsBuilder> predicate) {
        for (RuleWithOperationsBuilder item : this.rules) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingRule(Predicate<RuleWithOperationsBuilder> predicate) {
        for (RuleWithOperationsBuilder item : this.rules) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withRules(List<RuleWithOperations> rules) {
        if (this.rules != null) {
            this._visitables.get("rules").removeAll(this.rules);
        }
        if (rules != null) {
            this.rules = new ArrayList<RuleWithOperationsBuilder>();
            for (RuleWithOperations item : rules) {
                this.addToRules(item);
            }
        } else {
            this.rules = null;
        }
        return (A)this;
    }

    @Override
    public A withRules(RuleWithOperations ... rules) {
        if (this.rules != null) {
            this.rules.clear();
        }
        if (rules != null) {
            for (RuleWithOperations item : rules) {
                this.addToRules(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasRules() {
        return this.rules != null && !this.rules.isEmpty();
    }

    @Override
    public MutatingWebhookFluent.RulesNested<A> addNewRule() {
        return new RulesNestedImpl();
    }

    @Override
    public MutatingWebhookFluent.RulesNested<A> addNewRuleLike(RuleWithOperations item) {
        return new RulesNestedImpl(-1, item);
    }

    @Override
    public MutatingWebhookFluent.RulesNested<A> setNewRuleLike(Integer index, RuleWithOperations item) {
        return new RulesNestedImpl(index, item);
    }

    @Override
    public MutatingWebhookFluent.RulesNested<A> editRule(Integer index) {
        if (this.rules.size() <= index) {
            throw new RuntimeException("Can't edit rules. Index exceeds size.");
        }
        return this.setNewRuleLike(index, this.buildRule(index));
    }

    @Override
    public MutatingWebhookFluent.RulesNested<A> editFirstRule() {
        if (this.rules.size() == 0) {
            throw new RuntimeException("Can't edit first rules. The list is empty.");
        }
        return this.setNewRuleLike(0, this.buildRule(0));
    }

    @Override
    public MutatingWebhookFluent.RulesNested<A> editLastRule() {
        int index = this.rules.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last rules. The list is empty.");
        }
        return this.setNewRuleLike(index, this.buildRule(index));
    }

    @Override
    public MutatingWebhookFluent.RulesNested<A> editMatchingRule(Predicate<RuleWithOperationsBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.rules.size(); ++i) {
            if (!predicate.test(this.rules.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching rules. No match found.");
        }
        return this.setNewRuleLike(index, this.buildRule(index));
    }

    @Override
    public String getSideEffects() {
        return this.sideEffects;
    }

    @Override
    public A withSideEffects(String sideEffects) {
        this.sideEffects = sideEffects;
        return (A)this;
    }

    @Override
    public Boolean hasSideEffects() {
        return this.sideEffects != null;
    }

    @Override
    @Deprecated
    public A withNewSideEffects(String arg0) {
        return this.withSideEffects(new String(arg0));
    }

    @Override
    public Integer getTimeoutSeconds() {
        return this.timeoutSeconds;
    }

    @Override
    public A withTimeoutSeconds(Integer timeoutSeconds) {
        this.timeoutSeconds = timeoutSeconds;
        return (A)this;
    }

    @Override
    public Boolean hasTimeoutSeconds() {
        return this.timeoutSeconds != null;
    }

    @Override
    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    @Override
    public Boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MutatingWebhookFluentImpl that = (MutatingWebhookFluentImpl)o;
        if (this.admissionReviewVersions != null ? !this.admissionReviewVersions.equals(that.admissionReviewVersions) : that.admissionReviewVersions != null) {
            return false;
        }
        if (this.clientConfig != null ? !this.clientConfig.equals(that.clientConfig) : that.clientConfig != null) {
            return false;
        }
        if (this.failurePolicy != null ? !this.failurePolicy.equals(that.failurePolicy) : that.failurePolicy != null) {
            return false;
        }
        if (this.matchPolicy != null ? !this.matchPolicy.equals(that.matchPolicy) : that.matchPolicy != null) {
            return false;
        }
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        if (this.namespaceSelector != null ? !this.namespaceSelector.equals(that.namespaceSelector) : that.namespaceSelector != null) {
            return false;
        }
        if (this.objectSelector != null ? !this.objectSelector.equals(that.objectSelector) : that.objectSelector != null) {
            return false;
        }
        if (this.reinvocationPolicy != null ? !this.reinvocationPolicy.equals(that.reinvocationPolicy) : that.reinvocationPolicy != null) {
            return false;
        }
        if (this.rules != null ? !this.rules.equals(that.rules) : that.rules != null) {
            return false;
        }
        if (this.sideEffects != null ? !this.sideEffects.equals(that.sideEffects) : that.sideEffects != null) {
            return false;
        }
        if (this.timeoutSeconds != null ? !this.timeoutSeconds.equals(that.timeoutSeconds) : that.timeoutSeconds != null) {
            return false;
        }
        return !(this.additionalProperties != null ? !this.additionalProperties.equals(that.additionalProperties) : that.additionalProperties != null);
    }

    public int hashCode() {
        return Objects.hash(this.admissionReviewVersions, this.clientConfig, this.failurePolicy, this.matchPolicy, this.name, this.namespaceSelector, this.objectSelector, this.reinvocationPolicy, this.rules, this.sideEffects, this.timeoutSeconds, this.additionalProperties, super.hashCode());
    }

    public class RulesNestedImpl<N>
    extends RuleWithOperationsFluentImpl<MutatingWebhookFluent.RulesNested<N>>
    implements MutatingWebhookFluent.RulesNested<N>,
    Nested<N> {
        RuleWithOperationsBuilder builder;
        Integer index;

        RulesNestedImpl(Integer index, RuleWithOperations item) {
            this.index = index;
            this.builder = new RuleWithOperationsBuilder(this, item);
        }

        RulesNestedImpl() {
            this.index = -1;
            this.builder = new RuleWithOperationsBuilder(this);
        }

        @Override
        public N and() {
            return (N)MutatingWebhookFluentImpl.this.setToRules(this.index, this.builder.build());
        }

        @Override
        public N endRule() {
            return this.and();
        }
    }

    public class ObjectSelectorNestedImpl<N>
    extends LabelSelectorFluentImpl<MutatingWebhookFluent.ObjectSelectorNested<N>>
    implements MutatingWebhookFluent.ObjectSelectorNested<N>,
    Nested<N> {
        LabelSelectorBuilder builder;

        ObjectSelectorNestedImpl(LabelSelector item) {
            this.builder = new LabelSelectorBuilder(this, item);
        }

        ObjectSelectorNestedImpl() {
            this.builder = new LabelSelectorBuilder(this);
        }

        @Override
        public N and() {
            return (N)MutatingWebhookFluentImpl.this.withObjectSelector(this.builder.build());
        }

        @Override
        public N endObjectSelector() {
            return this.and();
        }
    }

    public class NamespaceSelectorNestedImpl<N>
    extends LabelSelectorFluentImpl<MutatingWebhookFluent.NamespaceSelectorNested<N>>
    implements MutatingWebhookFluent.NamespaceSelectorNested<N>,
    Nested<N> {
        LabelSelectorBuilder builder;

        NamespaceSelectorNestedImpl(LabelSelector item) {
            this.builder = new LabelSelectorBuilder(this, item);
        }

        NamespaceSelectorNestedImpl() {
            this.builder = new LabelSelectorBuilder(this);
        }

        @Override
        public N and() {
            return (N)MutatingWebhookFluentImpl.this.withNamespaceSelector(this.builder.build());
        }

        @Override
        public N endNamespaceSelector() {
            return this.and();
        }
    }

    public class ClientConfigNestedImpl<N>
    extends WebhookClientConfigFluentImpl<MutatingWebhookFluent.ClientConfigNested<N>>
    implements MutatingWebhookFluent.ClientConfigNested<N>,
    Nested<N> {
        WebhookClientConfigBuilder builder;

        ClientConfigNestedImpl(WebhookClientConfig item) {
            this.builder = new WebhookClientConfigBuilder(this, item);
        }

        ClientConfigNestedImpl() {
            this.builder = new WebhookClientConfigBuilder(this);
        }

        @Override
        public N and() {
            return (N)MutatingWebhookFluentImpl.this.withClientConfig(this.builder.build());
        }

        @Override
        public N endClientConfig() {
            return this.and();
        }
    }
}

