/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v5_12;

import io.fabric8.kubernetes.api.builder.v5_12.VisitableBuilder;
import io.fabric8.kubernetes.api.model.v5_12.SecretKeySelector;
import io.fabric8.kubernetes.api.model.v5_12.SecretKeySelectorFluent;
import io.fabric8.kubernetes.api.model.v5_12.SecretKeySelectorFluentImpl;
import java.util.Objects;

public class SecretKeySelectorBuilder
extends SecretKeySelectorFluentImpl<SecretKeySelectorBuilder>
implements VisitableBuilder<SecretKeySelector, SecretKeySelectorBuilder> {
    SecretKeySelectorFluent<?> fluent;
    Boolean validationEnabled;

    public SecretKeySelectorBuilder() {
        this(false);
    }

    public SecretKeySelectorBuilder(Boolean validationEnabled) {
        this(new SecretKeySelector(), validationEnabled);
    }

    public SecretKeySelectorBuilder(SecretKeySelectorFluent<?> fluent) {
        this(fluent, (Boolean)false);
    }

    public SecretKeySelectorBuilder(SecretKeySelectorFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new SecretKeySelector(), validationEnabled);
    }

    public SecretKeySelectorBuilder(SecretKeySelectorFluent<?> fluent, SecretKeySelector instance) {
        this(fluent, instance, false);
    }

    public SecretKeySelectorBuilder(SecretKeySelectorFluent<?> fluent, SecretKeySelector instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withKey(instance.getKey());
        fluent.withName(instance.getName());
        fluent.withOptional(instance.getOptional());
        fluent.withAdditionalProperties(instance.getAdditionalProperties());
        this.validationEnabled = validationEnabled;
    }

    public SecretKeySelectorBuilder(SecretKeySelector instance) {
        this(instance, (Boolean)false);
    }

    public SecretKeySelectorBuilder(SecretKeySelector instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withKey(instance.getKey());
        this.withName(instance.getName());
        this.withOptional(instance.getOptional());
        this.withAdditionalProperties(instance.getAdditionalProperties());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public SecretKeySelector build() {
        SecretKeySelector buildable = new SecretKeySelector(this.fluent.getKey(), this.fluent.getName(), this.fluent.getOptional());
        buildable.setAdditionalProperties(this.fluent.getAdditionalProperties());
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SecretKeySelectorBuilder that = (SecretKeySelectorBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.fluent, this.validationEnabled, super.hashCode());
    }
}

