/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v5_12;

import io.fabric8.kubernetes.api.builder.v5_12.BaseFluent;
import io.fabric8.kubernetes.api.model.v5_12.LabelSelectorRequirement;
import io.fabric8.kubernetes.api.model.v5_12.LabelSelectorRequirementFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class LabelSelectorRequirementFluentImpl<A extends LabelSelectorRequirementFluent<A>>
extends BaseFluent<A>
implements LabelSelectorRequirementFluent<A> {
    private String key;
    private String operator;
    private List<String> values = new ArrayList<String>();
    private Map<String, Object> additionalProperties;

    public LabelSelectorRequirementFluentImpl() {
    }

    public LabelSelectorRequirementFluentImpl(LabelSelectorRequirement instance) {
        this.withKey(instance.getKey());
        this.withOperator(instance.getOperator());
        this.withValues(instance.getValues());
        this.withAdditionalProperties(instance.getAdditionalProperties());
    }

    @Override
    public String getKey() {
        return this.key;
    }

    @Override
    public A withKey(String key) {
        this.key = key;
        return (A)this;
    }

    @Override
    public Boolean hasKey() {
        return this.key != null;
    }

    @Override
    @Deprecated
    public A withNewKey(String arg0) {
        return this.withKey(new String(arg0));
    }

    @Override
    public String getOperator() {
        return this.operator;
    }

    @Override
    public A withOperator(String operator) {
        this.operator = operator;
        return (A)this;
    }

    @Override
    public Boolean hasOperator() {
        return this.operator != null;
    }

    @Override
    @Deprecated
    public A withNewOperator(String arg0) {
        return this.withOperator(new String(arg0));
    }

    @Override
    public A addToValues(Integer index, String item) {
        if (this.values == null) {
            this.values = new ArrayList<String>();
        }
        this.values.add(index, item);
        return (A)this;
    }

    @Override
    public A setToValues(Integer index, String item) {
        if (this.values == null) {
            this.values = new ArrayList<String>();
        }
        this.values.set(index, item);
        return (A)this;
    }

    @Override
    public A addToValues(String ... items) {
        if (this.values == null) {
            this.values = new ArrayList<String>();
        }
        for (String item : items) {
            this.values.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToValues(Collection<String> items) {
        if (this.values == null) {
            this.values = new ArrayList<String>();
        }
        for (String item : items) {
            this.values.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromValues(String ... items) {
        for (String item : items) {
            if (this.values == null) continue;
            this.values.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromValues(Collection<String> items) {
        for (String item : items) {
            if (this.values == null) continue;
            this.values.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getValues() {
        return this.values;
    }

    @Override
    public String getValue(Integer index) {
        return this.values.get(index);
    }

    @Override
    public String getFirstValue() {
        return this.values.get(0);
    }

    @Override
    public String getLastValue() {
        return this.values.get(this.values.size() - 1);
    }

    @Override
    public String getMatchingValue(Predicate<String> predicate) {
        for (String item : this.values) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingValue(Predicate<String> predicate) {
        for (String item : this.values) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withValues(List<String> values) {
        if (values != null) {
            this.values = new ArrayList<String>();
            for (String item : values) {
                this.addToValues(item);
            }
        } else {
            this.values = null;
        }
        return (A)this;
    }

    @Override
    public A withValues(String ... values) {
        if (this.values != null) {
            this.values.clear();
        }
        if (values != null) {
            for (String item : values) {
                this.addToValues(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasValues() {
        return this.values != null && !this.values.isEmpty();
    }

    @Override
    public A addNewValue(String arg0) {
        return this.addToValues(new String(arg0));
    }

    @Override
    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    @Override
    public Boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LabelSelectorRequirementFluentImpl that = (LabelSelectorRequirementFluentImpl)o;
        if (this.key != null ? !this.key.equals(that.key) : that.key != null) {
            return false;
        }
        if (this.operator != null ? !this.operator.equals(that.operator) : that.operator != null) {
            return false;
        }
        if (this.values != null ? !this.values.equals(that.values) : that.values != null) {
            return false;
        }
        return !(this.additionalProperties != null ? !this.additionalProperties.equals(that.additionalProperties) : that.additionalProperties != null);
    }

    public int hashCode() {
        return Objects.hash(this.key, this.operator, this.values, this.additionalProperties, super.hashCode());
    }
}

