/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v5_12;

import io.fabric8.kubernetes.api.builder.v5_12.BaseFluent;
import io.fabric8.kubernetes.api.model.v5_12.HostAlias;
import io.fabric8.kubernetes.api.model.v5_12.HostAliasFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class HostAliasFluentImpl<A extends HostAliasFluent<A>>
extends BaseFluent<A>
implements HostAliasFluent<A> {
    private List<String> hostnames = new ArrayList<String>();
    private String ip;
    private Map<String, Object> additionalProperties;

    public HostAliasFluentImpl() {
    }

    public HostAliasFluentImpl(HostAlias instance) {
        this.withHostnames(instance.getHostnames());
        this.withIp(instance.getIp());
        this.withAdditionalProperties(instance.getAdditionalProperties());
    }

    @Override
    public A addToHostnames(Integer index, String item) {
        if (this.hostnames == null) {
            this.hostnames = new ArrayList<String>();
        }
        this.hostnames.add(index, item);
        return (A)this;
    }

    @Override
    public A setToHostnames(Integer index, String item) {
        if (this.hostnames == null) {
            this.hostnames = new ArrayList<String>();
        }
        this.hostnames.set(index, item);
        return (A)this;
    }

    @Override
    public A addToHostnames(String ... items) {
        if (this.hostnames == null) {
            this.hostnames = new ArrayList<String>();
        }
        for (String item : items) {
            this.hostnames.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToHostnames(Collection<String> items) {
        if (this.hostnames == null) {
            this.hostnames = new ArrayList<String>();
        }
        for (String item : items) {
            this.hostnames.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromHostnames(String ... items) {
        for (String item : items) {
            if (this.hostnames == null) continue;
            this.hostnames.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromHostnames(Collection<String> items) {
        for (String item : items) {
            if (this.hostnames == null) continue;
            this.hostnames.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getHostnames() {
        return this.hostnames;
    }

    @Override
    public String getHostname(Integer index) {
        return this.hostnames.get(index);
    }

    @Override
    public String getFirstHostname() {
        return this.hostnames.get(0);
    }

    @Override
    public String getLastHostname() {
        return this.hostnames.get(this.hostnames.size() - 1);
    }

    @Override
    public String getMatchingHostname(Predicate<String> predicate) {
        for (String item : this.hostnames) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingHostname(Predicate<String> predicate) {
        for (String item : this.hostnames) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withHostnames(List<String> hostnames) {
        if (hostnames != null) {
            this.hostnames = new ArrayList<String>();
            for (String item : hostnames) {
                this.addToHostnames(item);
            }
        } else {
            this.hostnames = null;
        }
        return (A)this;
    }

    @Override
    public A withHostnames(String ... hostnames) {
        if (this.hostnames != null) {
            this.hostnames.clear();
        }
        if (hostnames != null) {
            for (String item : hostnames) {
                this.addToHostnames(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasHostnames() {
        return this.hostnames != null && !this.hostnames.isEmpty();
    }

    @Override
    public A addNewHostname(String arg0) {
        return this.addToHostnames(new String(arg0));
    }

    @Override
    public String getIp() {
        return this.ip;
    }

    @Override
    public A withIp(String ip) {
        this.ip = ip;
        return (A)this;
    }

    @Override
    public Boolean hasIp() {
        return this.ip != null;
    }

    @Override
    @Deprecated
    public A withNewIp(String arg0) {
        return this.withIp(new String(arg0));
    }

    @Override
    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    @Override
    public Boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HostAliasFluentImpl that = (HostAliasFluentImpl)o;
        if (this.hostnames != null ? !this.hostnames.equals(that.hostnames) : that.hostnames != null) {
            return false;
        }
        if (this.ip != null ? !this.ip.equals(that.ip) : that.ip != null) {
            return false;
        }
        return !(this.additionalProperties != null ? !this.additionalProperties.equals(that.additionalProperties) : that.additionalProperties != null);
    }

    public int hashCode() {
        return Objects.hash(this.hostnames, this.ip, this.additionalProperties, super.hashCode());
    }
}

