/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.clnt.v5_12.dsl.internal.build;

import io.fabric8.kubernetes.api.builder.v5_12.VisitableBuilder;
import io.fabric8.kubernetes.api.model.v5_12.Pod;
import io.fabric8.kubernetes.clnt.v5_12.KubernetesClientException;
import io.fabric8.kubernetes.clnt.v5_12.dsl.BytesLimitTerminateTimeTailPrettyLoggable;
import io.fabric8.kubernetes.clnt.v5_12.dsl.LogWatch;
import io.fabric8.kubernetes.clnt.v5_12.dsl.Loggable;
import io.fabric8.kubernetes.clnt.v5_12.dsl.PodResource;
import io.fabric8.kubernetes.clnt.v5_12.dsl.PrettyLoggable;
import io.fabric8.kubernetes.clnt.v5_12.dsl.TailPrettyLoggable;
import io.fabric8.kubernetes.clnt.v5_12.dsl.TimeTailPrettyLoggable;
import io.fabric8.kubernetes.clnt.v5_12.dsl.base.OperationContext;
import io.fabric8.kubernetes.clnt.v5_12.dsl.internal.HasMetadataOperationsImpl;
import io.fabric8.kubernetes.clnt.v5_12.dsl.internal.LogWatchCallback;
import io.fabric8.kubernetes.clnt.v5_12.internal.PatchUtils;
import io.fabric8.kubernetes.clnt.v5_12.utils.PodOperationUtil;
import io.fabric8.kubernetes.clnt.v5_12.utils.URLUtils;
import io.fabric8.openshift.api.model.v5_12.Build;
import io.fabric8.openshift.api.model.v5_12.BuildBuilder;
import io.fabric8.openshift.api.model.v5_12.BuildList;
import io.fabric8.openshift.clnt.v5_12.OpenshiftClientContext;
import io.fabric8.openshift.clnt.v5_12.dsl.BuildResource;
import io.fabric8.openshift.clnt.v5_12.dsl.internal.BuildOperationContext;
import io.fabric8.openshift.clnt.v5_12.dsl.internal.OpenShiftOperation;
import io.fabric8.openshift.clnt.v5_12.internal.patchmixins.BuildMixIn;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class BuildOperationsImpl
extends OpenShiftOperation<Build, BuildList, BuildResource<Build, LogWatch>>
implements BuildResource<Build, LogWatch> {
    public static final String OPENSHIFT_IO_BUILD_NAME = "openshift.io/build.name";
    private final boolean withTerminatedStatus;
    private final boolean withTimestamps;
    private final String sinceTimestamp;
    private final Integer sinceSeconds;
    private final Integer withTailingLines;
    private final boolean withPrettyOutput;
    private final String version;
    private final Integer limitBytes;
    private static final Integer DEFAULT_POD_LOG_WAIT_TIMEOUT = 5;
    private Integer podLogWaitTimeout;
    private final BuildOperationContext buildOperationContext;

    public BuildOperationsImpl(OpenshiftClientContext clientContext) {
        this(new BuildOperationContext(), HasMetadataOperationsImpl.defaultContext(clientContext));
    }

    public BuildOperationsImpl(BuildOperationContext context, OperationContext superContext) {
        super(superContext.withApiGroupName("build.openshift.io").withPlural("builds"), Build.class, BuildList.class);
        this.buildOperationContext = context;
        this.withTerminatedStatus = context.isTerminatedStatus();
        this.withTimestamps = context.isTimestamps();
        this.sinceTimestamp = context.getSinceTimestamp();
        this.sinceSeconds = context.getSinceSeconds();
        this.withTailingLines = context.getTailingLines();
        this.withPrettyOutput = context.isPrettyOutput();
        this.version = context.getVersion();
        this.limitBytes = context.getLimitBytes();
        PatchUtils.addMixInToMapper(Build.class, BuildMixIn.class);
    }

    public BuildOperationsImpl newInstance(OperationContext context) {
        return new BuildOperationsImpl(this.buildOperationContext, context);
    }

    BuildOperationContext getContext() {
        return this.buildOperationContext;
    }

    protected String getLogParameters() {
        StringBuilder sb = new StringBuilder();
        sb.append("log?pretty=").append(this.withPrettyOutput);
        if (this.version != null && !this.version.isEmpty()) {
            sb.append("&version=").append(this.version);
        }
        if (this.withTerminatedStatus) {
            sb.append("&previous=true");
        }
        if (this.sinceSeconds != null) {
            sb.append("&sinceSeconds=").append(this.sinceSeconds);
        } else if (this.sinceTimestamp != null) {
            sb.append("&sinceTime=").append(this.sinceTimestamp);
        }
        if (this.withTailingLines != null) {
            sb.append("&tailLines=").append(this.withTailingLines);
        }
        if (this.limitBytes != null) {
            sb.append("&limitBytes=").append(this.limitBytes);
        }
        if (this.withTimestamps) {
            sb.append("&timestamps=true");
        }
        return sb.toString();
    }

    protected <T> T doGetLog(Class<T> type) {
        try {
            URL url = new URL(URLUtils.join(this.getResourceUrl().toString(), this.getLogParameters()));
            return this.handleRawGet(url, type);
        }
        catch (IOException t) {
            throw KubernetesClientException.launderThrowable(this.forOperationType("doGetLog"), (Throwable)t);
        }
    }

    @Override
    public String getLog() {
        return this.doGetLog(String.class);
    }

    @Override
    public String getLog(Boolean isPretty) {
        return new BuildOperationsImpl(this.getContext().withPrettyOutput(isPretty), this.context).getLog();
    }

    @Override
    public Reader getLogReader() {
        return this.doGetLog(Reader.class);
    }

    @Override
    public LogWatch watchLog() {
        return this.watchLog(null);
    }

    @Override
    public LogWatch watchLog(OutputStream out) {
        try {
            this.waitUntilBuildPodBecomesReady((Build)this.fromServer().get());
            URL url = new URL(URLUtils.join(this.getResourceUrl().toString(), this.getLogParameters() + "&follow=true"));
            LogWatchCallback callback = new LogWatchCallback(this.config, out);
            return callback.callAndWait(this.httpClient, url);
        }
        catch (IOException t) {
            throw KubernetesClientException.launderThrowable(this.forOperationType("watchLog"), (Throwable)t);
        }
    }

    @Override
    public Loggable<LogWatch> withLogWaitTimeout(Integer logWaitTimeout) {
        BuildOperationsImpl result = this.newInstance(this.context);
        result.podLogWaitTimeout = logWaitTimeout;
        return result;
    }

    @Override
    public Loggable<LogWatch> withPrettyOutput() {
        return new BuildOperationsImpl(this.getContext().withPrettyOutput(true), this.context);
    }

    @Override
    public PrettyLoggable<LogWatch> tailingLines(int tailingLines) {
        return new BuildOperationsImpl(this.getContext().withTailingLines(tailingLines), this.context);
    }

    @Override
    public TimeTailPrettyLoggable<LogWatch> terminated() {
        return new BuildOperationsImpl(this.getContext().withTerminatedStatus(true), this.context);
    }

    @Override
    public TailPrettyLoggable<LogWatch> sinceTime(String sinceTimestamp) {
        return new BuildOperationsImpl(this.getContext().withSinceTimestamp(sinceTimestamp), this.context);
    }

    @Override
    public TailPrettyLoggable<LogWatch> sinceSeconds(int sinceSeconds) {
        return new BuildOperationsImpl(this.getContext().withSinceSeconds(sinceSeconds), this.context);
    }

    @Override
    public BytesLimitTerminateTimeTailPrettyLoggable<LogWatch> limitBytes(int limitBytes) {
        return new BuildOperationsImpl(this.getContext().withLimitBytes(limitBytes), this.context);
    }

    @Override
    public BytesLimitTerminateTimeTailPrettyLoggable<LogWatch> usingTimestamps() {
        return new BuildOperationsImpl(this.getContext().withTimestamps(true), this.context);
    }

    @Override
    protected VisitableBuilder<Build, ?> createVisitableBuilder(Build item) {
        return new BuildBuilder(item);
    }

    private void waitUntilBuildPodBecomesReady(Build build) {
        List<PodResource<Pod>> podOps = PodOperationUtil.getPodOperationsForController(this.context, build.getMetadata().getUid(), BuildOperationsImpl.getBuildPodLabels(build), this.withPrettyOutput, this.podLogWaitTimeout, null);
        BuildOperationsImpl.waitForBuildPodToBecomeReady(podOps, this.podLogWaitTimeout != null ? this.podLogWaitTimeout : DEFAULT_POD_LOG_WAIT_TIMEOUT);
    }

    private static void waitForBuildPodToBecomeReady(List<PodResource<Pod>> podOps, Integer podLogWaitTimeout) {
        for (PodResource<Pod> podOp : podOps) {
            PodOperationUtil.waitUntilReadyBeforeFetchingLogs(podOp, podLogWaitTimeout);
        }
    }

    static Map<String, String> getBuildPodLabels(Build build) {
        HashMap<String, String> labels = new HashMap<String, String>();
        if (build != null && build.getMetadata() != null) {
            labels.put(OPENSHIFT_IO_BUILD_NAME, build.getMetadata().getName());
        }
        return labels;
    }
}

