/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.v5_12.operator.v1;

import io.fabric8.kubernetes.api.builder.v5_12.BaseFluent;
import io.fabric8.openshift.api.model.v5_12.operator.v1.StaticIPAMDNS;
import io.fabric8.openshift.api.model.v5_12.operator.v1.StaticIPAMDNSFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class StaticIPAMDNSFluentImpl<A extends StaticIPAMDNSFluent<A>>
extends BaseFluent<A>
implements StaticIPAMDNSFluent<A> {
    private String domain;
    private List<String> nameservers = new ArrayList<String>();
    private List<String> search = new ArrayList<String>();
    private Map<String, Object> additionalProperties;

    public StaticIPAMDNSFluentImpl() {
    }

    public StaticIPAMDNSFluentImpl(StaticIPAMDNS instance) {
        this.withDomain(instance.getDomain());
        this.withNameservers(instance.getNameservers());
        this.withSearch(instance.getSearch());
        this.withAdditionalProperties(instance.getAdditionalProperties());
    }

    @Override
    public String getDomain() {
        return this.domain;
    }

    @Override
    public A withDomain(String domain) {
        this.domain = domain;
        return (A)this;
    }

    @Override
    public Boolean hasDomain() {
        return this.domain != null;
    }

    @Override
    @Deprecated
    public A withNewDomain(String arg0) {
        return this.withDomain(new String(arg0));
    }

    @Override
    public A addToNameservers(Integer index, String item) {
        if (this.nameservers == null) {
            this.nameservers = new ArrayList<String>();
        }
        this.nameservers.add(index, item);
        return (A)this;
    }

    @Override
    public A setToNameservers(Integer index, String item) {
        if (this.nameservers == null) {
            this.nameservers = new ArrayList<String>();
        }
        this.nameservers.set(index, item);
        return (A)this;
    }

    @Override
    public A addToNameservers(String ... items) {
        if (this.nameservers == null) {
            this.nameservers = new ArrayList<String>();
        }
        for (String item : items) {
            this.nameservers.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToNameservers(Collection<String> items) {
        if (this.nameservers == null) {
            this.nameservers = new ArrayList<String>();
        }
        for (String item : items) {
            this.nameservers.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromNameservers(String ... items) {
        for (String item : items) {
            if (this.nameservers == null) continue;
            this.nameservers.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromNameservers(Collection<String> items) {
        for (String item : items) {
            if (this.nameservers == null) continue;
            this.nameservers.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getNameservers() {
        return this.nameservers;
    }

    @Override
    public String getNameserver(Integer index) {
        return this.nameservers.get(index);
    }

    @Override
    public String getFirstNameserver() {
        return this.nameservers.get(0);
    }

    @Override
    public String getLastNameserver() {
        return this.nameservers.get(this.nameservers.size() - 1);
    }

    @Override
    public String getMatchingNameserver(Predicate<String> predicate) {
        for (String item : this.nameservers) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingNameserver(Predicate<String> predicate) {
        for (String item : this.nameservers) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withNameservers(List<String> nameservers) {
        if (nameservers != null) {
            this.nameservers = new ArrayList<String>();
            for (String item : nameservers) {
                this.addToNameservers(item);
            }
        } else {
            this.nameservers = null;
        }
        return (A)this;
    }

    @Override
    public A withNameservers(String ... nameservers) {
        if (this.nameservers != null) {
            this.nameservers.clear();
        }
        if (nameservers != null) {
            for (String item : nameservers) {
                this.addToNameservers(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasNameservers() {
        return this.nameservers != null && !this.nameservers.isEmpty();
    }

    @Override
    public A addNewNameserver(String arg0) {
        return this.addToNameservers(new String(arg0));
    }

    @Override
    public A addToSearch(Integer index, String item) {
        if (this.search == null) {
            this.search = new ArrayList<String>();
        }
        this.search.add(index, item);
        return (A)this;
    }

    @Override
    public A setToSearch(Integer index, String item) {
        if (this.search == null) {
            this.search = new ArrayList<String>();
        }
        this.search.set(index, item);
        return (A)this;
    }

    @Override
    public A addToSearch(String ... items) {
        if (this.search == null) {
            this.search = new ArrayList<String>();
        }
        for (String item : items) {
            this.search.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToSearch(Collection<String> items) {
        if (this.search == null) {
            this.search = new ArrayList<String>();
        }
        for (String item : items) {
            this.search.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromSearch(String ... items) {
        for (String item : items) {
            if (this.search == null) continue;
            this.search.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromSearch(Collection<String> items) {
        for (String item : items) {
            if (this.search == null) continue;
            this.search.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getSearch() {
        return this.search;
    }

    @Override
    public String getSearch(Integer index) {
        return this.search.get(index);
    }

    @Override
    public String getFirstSearch() {
        return this.search.get(0);
    }

    @Override
    public String getLastSearch() {
        return this.search.get(this.search.size() - 1);
    }

    @Override
    public String getMatchingSearch(Predicate<String> predicate) {
        for (String item : this.search) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingSearch(Predicate<String> predicate) {
        for (String item : this.search) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withSearch(List<String> search) {
        if (search != null) {
            this.search = new ArrayList<String>();
            for (String item : search) {
                this.addToSearch(item);
            }
        } else {
            this.search = null;
        }
        return (A)this;
    }

    @Override
    public A withSearch(String ... search) {
        if (this.search != null) {
            this.search.clear();
        }
        if (search != null) {
            for (String item : search) {
                this.addToSearch(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasSearch() {
        return this.search != null && !this.search.isEmpty();
    }

    @Override
    public A addNewSearch(String arg0) {
        return this.addToSearch(new String(arg0));
    }

    @Override
    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    @Override
    public Boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StaticIPAMDNSFluentImpl that = (StaticIPAMDNSFluentImpl)o;
        if (this.domain != null ? !this.domain.equals(that.domain) : that.domain != null) {
            return false;
        }
        if (this.nameservers != null ? !this.nameservers.equals(that.nameservers) : that.nameservers != null) {
            return false;
        }
        if (this.search != null ? !this.search.equals(that.search) : that.search != null) {
            return false;
        }
        return !(this.additionalProperties != null ? !this.additionalProperties.equals(that.additionalProperties) : that.additionalProperties != null);
    }

    public int hashCode() {
        return Objects.hash(this.domain, this.nameservers, this.search, this.additionalProperties, super.hashCode());
    }
}

