/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.v5_12.operator.v1;

import io.fabric8.kubernetes.api.builder.v5_12.VisitableBuilder;
import io.fabric8.openshift.api.model.v5_12.operator.v1.AWSLoadBalancerParameters;
import io.fabric8.openshift.api.model.v5_12.operator.v1.AWSLoadBalancerParametersFluent;
import io.fabric8.openshift.api.model.v5_12.operator.v1.AWSLoadBalancerParametersFluentImpl;
import java.util.Objects;

public class AWSLoadBalancerParametersBuilder
extends AWSLoadBalancerParametersFluentImpl<AWSLoadBalancerParametersBuilder>
implements VisitableBuilder<AWSLoadBalancerParameters, AWSLoadBalancerParametersBuilder> {
    AWSLoadBalancerParametersFluent<?> fluent;
    Boolean validationEnabled;

    public AWSLoadBalancerParametersBuilder() {
        this(false);
    }

    public AWSLoadBalancerParametersBuilder(Boolean validationEnabled) {
        this(new AWSLoadBalancerParameters(), validationEnabled);
    }

    public AWSLoadBalancerParametersBuilder(AWSLoadBalancerParametersFluent<?> fluent) {
        this(fluent, (Boolean)false);
    }

    public AWSLoadBalancerParametersBuilder(AWSLoadBalancerParametersFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new AWSLoadBalancerParameters(), validationEnabled);
    }

    public AWSLoadBalancerParametersBuilder(AWSLoadBalancerParametersFluent<?> fluent, AWSLoadBalancerParameters instance) {
        this(fluent, instance, false);
    }

    public AWSLoadBalancerParametersBuilder(AWSLoadBalancerParametersFluent<?> fluent, AWSLoadBalancerParameters instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withClassicLoadBalancer(instance.getClassicLoadBalancer());
        fluent.withNetworkLoadBalancer(instance.getNetworkLoadBalancer());
        fluent.withType(instance.getType());
        fluent.withAdditionalProperties(instance.getAdditionalProperties());
        this.validationEnabled = validationEnabled;
    }

    public AWSLoadBalancerParametersBuilder(AWSLoadBalancerParameters instance) {
        this(instance, (Boolean)false);
    }

    public AWSLoadBalancerParametersBuilder(AWSLoadBalancerParameters instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withClassicLoadBalancer(instance.getClassicLoadBalancer());
        this.withNetworkLoadBalancer(instance.getNetworkLoadBalancer());
        this.withType(instance.getType());
        this.withAdditionalProperties(instance.getAdditionalProperties());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public AWSLoadBalancerParameters build() {
        AWSLoadBalancerParameters buildable = new AWSLoadBalancerParameters(this.fluent.getClassicLoadBalancer(), this.fluent.getNetworkLoadBalancer(), this.fluent.getType());
        buildable.setAdditionalProperties(this.fluent.getAdditionalProperties());
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        AWSLoadBalancerParametersBuilder that = (AWSLoadBalancerParametersBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.fluent, this.validationEnabled, super.hashCode());
    }
}

