/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.v5_12.installer.openstack.v1;

import io.fabric8.kubernetes.api.builder.v5_12.BaseFluent;
import io.fabric8.openshift.api.model.v5_12.installer.openstack.v1.RootVolume;
import io.fabric8.openshift.api.model.v5_12.installer.openstack.v1.RootVolumeFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class RootVolumeFluentImpl<A extends RootVolumeFluent<A>>
extends BaseFluent<A>
implements RootVolumeFluent<A> {
    private Integer size;
    private String type;
    private List<String> zones = new ArrayList<String>();
    private Map<String, Object> additionalProperties;

    public RootVolumeFluentImpl() {
    }

    public RootVolumeFluentImpl(RootVolume instance) {
        this.withSize(instance.getSize());
        this.withType(instance.getType());
        this.withZones(instance.getZones());
        this.withAdditionalProperties(instance.getAdditionalProperties());
    }

    @Override
    public Integer getSize() {
        return this.size;
    }

    @Override
    public A withSize(Integer size) {
        this.size = size;
        return (A)this;
    }

    @Override
    public Boolean hasSize() {
        return this.size != null;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public A withType(String type) {
        this.type = type;
        return (A)this;
    }

    @Override
    public Boolean hasType() {
        return this.type != null;
    }

    @Override
    @Deprecated
    public A withNewType(String arg0) {
        return this.withType(new String(arg0));
    }

    @Override
    public A addToZones(Integer index, String item) {
        if (this.zones == null) {
            this.zones = new ArrayList<String>();
        }
        this.zones.add(index, item);
        return (A)this;
    }

    @Override
    public A setToZones(Integer index, String item) {
        if (this.zones == null) {
            this.zones = new ArrayList<String>();
        }
        this.zones.set(index, item);
        return (A)this;
    }

    @Override
    public A addToZones(String ... items) {
        if (this.zones == null) {
            this.zones = new ArrayList<String>();
        }
        for (String item : items) {
            this.zones.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToZones(Collection<String> items) {
        if (this.zones == null) {
            this.zones = new ArrayList<String>();
        }
        for (String item : items) {
            this.zones.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromZones(String ... items) {
        for (String item : items) {
            if (this.zones == null) continue;
            this.zones.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromZones(Collection<String> items) {
        for (String item : items) {
            if (this.zones == null) continue;
            this.zones.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getZones() {
        return this.zones;
    }

    @Override
    public String getZone(Integer index) {
        return this.zones.get(index);
    }

    @Override
    public String getFirstZone() {
        return this.zones.get(0);
    }

    @Override
    public String getLastZone() {
        return this.zones.get(this.zones.size() - 1);
    }

    @Override
    public String getMatchingZone(Predicate<String> predicate) {
        for (String item : this.zones) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingZone(Predicate<String> predicate) {
        for (String item : this.zones) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withZones(List<String> zones) {
        if (zones != null) {
            this.zones = new ArrayList<String>();
            for (String item : zones) {
                this.addToZones(item);
            }
        } else {
            this.zones = null;
        }
        return (A)this;
    }

    @Override
    public A withZones(String ... zones) {
        if (this.zones != null) {
            this.zones.clear();
        }
        if (zones != null) {
            for (String item : zones) {
                this.addToZones(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasZones() {
        return this.zones != null && !this.zones.isEmpty();
    }

    @Override
    public A addNewZone(String arg0) {
        return this.addToZones(new String(arg0));
    }

    @Override
    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    @Override
    public Boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RootVolumeFluentImpl that = (RootVolumeFluentImpl)o;
        if (this.size != null ? !this.size.equals(that.size) : that.size != null) {
            return false;
        }
        if (this.type != null ? !this.type.equals(that.type) : that.type != null) {
            return false;
        }
        if (this.zones != null ? !this.zones.equals(that.zones) : that.zones != null) {
            return false;
        }
        return !(this.additionalProperties != null ? !this.additionalProperties.equals(that.additionalProperties) : that.additionalProperties != null);
    }

    public int hashCode() {
        return Objects.hash(this.size, this.type, this.zones, this.additionalProperties, super.hashCode());
    }
}

