/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.v5_12.hive.v1;

import io.fabric8.kubernetes.api.builder.v5_12.VisitableBuilder;
import io.fabric8.openshift.api.model.v5_12.hive.v1.BackupConfig;
import io.fabric8.openshift.api.model.v5_12.hive.v1.BackupConfigFluent;
import io.fabric8.openshift.api.model.v5_12.hive.v1.BackupConfigFluentImpl;
import java.util.Objects;

public class BackupConfigBuilder
extends BackupConfigFluentImpl<BackupConfigBuilder>
implements VisitableBuilder<BackupConfig, BackupConfigBuilder> {
    BackupConfigFluent<?> fluent;
    Boolean validationEnabled;

    public BackupConfigBuilder() {
        this(false);
    }

    public BackupConfigBuilder(Boolean validationEnabled) {
        this(new BackupConfig(), validationEnabled);
    }

    public BackupConfigBuilder(BackupConfigFluent<?> fluent) {
        this(fluent, (Boolean)false);
    }

    public BackupConfigBuilder(BackupConfigFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new BackupConfig(), validationEnabled);
    }

    public BackupConfigBuilder(BackupConfigFluent<?> fluent, BackupConfig instance) {
        this(fluent, instance, false);
    }

    public BackupConfigBuilder(BackupConfigFluent<?> fluent, BackupConfig instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withMinBackupPeriodSeconds(instance.getMinBackupPeriodSeconds());
        fluent.withVelero(instance.getVelero());
        fluent.withAdditionalProperties(instance.getAdditionalProperties());
        this.validationEnabled = validationEnabled;
    }

    public BackupConfigBuilder(BackupConfig instance) {
        this(instance, (Boolean)false);
    }

    public BackupConfigBuilder(BackupConfig instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withMinBackupPeriodSeconds(instance.getMinBackupPeriodSeconds());
        this.withVelero(instance.getVelero());
        this.withAdditionalProperties(instance.getAdditionalProperties());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public BackupConfig build() {
        BackupConfig buildable = new BackupConfig(this.fluent.getMinBackupPeriodSeconds(), this.fluent.getVelero());
        buildable.setAdditionalProperties(this.fluent.getAdditionalProperties());
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        BackupConfigBuilder that = (BackupConfigBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.fluent, this.validationEnabled, super.hashCode());
    }
}

