/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.clnt.v5_12.dsl.internal.apps.v1;

import com.fasterxml.jackson.core.JsonProcessingException;
import io.fabric8.kubernetes.api.model.v5_12.HasMetadata;
import io.fabric8.kubernetes.api.model.v5_12.LabelSelector;
import io.fabric8.kubernetes.api.model.v5_12.Pod;
import io.fabric8.kubernetes.api.model.v5_12.PodBuilder;
import io.fabric8.kubernetes.api.model.v5_12.PodCondition;
import io.fabric8.kubernetes.api.model.v5_12.PodFluent;
import io.fabric8.kubernetes.api.model.v5_12.PodList;
import io.fabric8.kubernetes.clnt.v5_12.ClientContext;
import io.fabric8.kubernetes.clnt.v5_12.KubernetesClientException;
import io.fabric8.kubernetes.clnt.v5_12.dsl.EditReplacePatchDeletable;
import io.fabric8.kubernetes.clnt.v5_12.dsl.FilterWatchListDeletable;
import io.fabric8.kubernetes.clnt.v5_12.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.clnt.v5_12.dsl.Operation;
import io.fabric8.kubernetes.clnt.v5_12.dsl.PodResource;
import io.fabric8.kubernetes.clnt.v5_12.dsl.RollableScalableResource;
import io.fabric8.kubernetes.clnt.v5_12.dsl.WatchListDeletable;
import io.fabric8.kubernetes.clnt.v5_12.dsl.internal.core.v1.PodOperationsImpl;
import io.fabric8.kubernetes.clnt.v5_12.internal.SerializationUtils;
import io.fabric8.kubernetes.clnt.v5_12.utils.Utils;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class RollingUpdater<T extends HasMetadata, L> {
    public static final String DEPLOYMENT_KEY = "deployment";
    private static final Long DEFAULT_ROLLING_TIMEOUT = 900000L;
    private static final Long DEFAULT_SERVER_GC_WAIT_TIMEOUT = 60000L;
    private static final transient Logger LOG = LoggerFactory.getLogger(RollingUpdater.class);
    protected final ClientContext clientContext;
    protected final String namespace;
    private final long rollingTimeoutMillis;
    private final long loggingIntervalMillis;

    protected RollingUpdater(ClientContext clientContext, String namespace) {
        this(clientContext, namespace, DEFAULT_ROLLING_TIMEOUT, 20000L);
    }

    protected RollingUpdater(ClientContext clientContext, String namespace, long rollingTimeoutMillis, long loggingIntervalMillis) {
        this.clientContext = clientContext;
        this.namespace = namespace;
        this.rollingTimeoutMillis = rollingTimeoutMillis;
        this.loggingIntervalMillis = loggingIntervalMillis;
    }

    protected abstract T createClone(T var1, String var2, String var3);

    protected abstract WatchListDeletable<Pod, PodList> selectedPodLister(T var1);

    protected abstract T updateDeploymentKey(String var1, String var2);

    protected abstract T removeDeploymentKey(String var1);

    protected abstract int getReplicas(T var1);

    protected abstract T setReplicas(T var1, int var2);

    public T rollUpdate(T oldObj, T newObj) {
        try {
            String namespace = oldObj.getMetadata().getNamespace();
            String oldName = oldObj.getMetadata().getName();
            String oldDeploymentHash = this.md5sum((HasMetadata)oldObj);
            PodList oldPods = (PodList)this.selectedPodLister(oldObj).list();
            for (Pod pod : oldPods.getItems()) {
                try {
                    Pod old = (Pod)((PodResource)((NonNamespaceOperation)this.pods().inNamespace(namespace)).withName(pod.getMetadata().getName())).get();
                    Pod updated = ((PodBuilder)((PodFluent.MetadataNested)new PodBuilder(old).editMetadata().addToLabels(DEPLOYMENT_KEY, oldDeploymentHash)).endMetadata()).build();
                    ((PodResource)((NonNamespaceOperation)this.pods().inNamespace(namespace)).withName(pod.getMetadata().getName())).replace(updated);
                }
                catch (KubernetesClientException e) {
                    LOG.warn("Unable to add deployment key to pod: {}", (Object)e.getMessage());
                }
            }
            oldObj = this.updateDeploymentKey(oldName, oldDeploymentHash);
            String newDeploymentHash = this.md5sum((HasMetadata)newObj);
            String newName = newObj.getMetadata().getName();
            if (newName == null || newName.equals(oldName)) {
                newName = newName + "-" + newDeploymentHash;
            }
            T clonedObj = this.createClone(newObj, newName, newDeploymentHash);
            HasMetadata createdObj = (HasMetadata)((NonNamespaceOperation)this.resources().inNamespace(namespace)).create(clonedObj);
            int oldReplicas = this.getReplicas(oldObj);
            while (this.getReplicas(createdObj) < this.getReplicas(newObj)) {
                int newReplicas = this.getReplicas(createdObj) + 1;
                ((RollableScalableResource)((NonNamespaceOperation)this.resources().inNamespace(namespace)).withName(createdObj.getMetadata().getName())).scale(newReplicas, true);
                this.waitUntilPodsAreReady(createdObj, namespace, newReplicas);
                createdObj = this.setReplicas(createdObj, newReplicas);
                if (oldReplicas <= 0) continue;
                ((RollableScalableResource)((NonNamespaceOperation)this.resources().inNamespace(namespace)).withName(oldName)).scale(--oldReplicas, true);
                this.waitUntilPodsAreReady(oldObj, namespace, oldReplicas);
            }
            ((RollableScalableResource)((NonNamespaceOperation)this.resources().inNamespace(namespace)).withName(oldName)).delete();
            if (Objects.equals(oldName, newObj.getMetadata().getName())) {
                ((EditReplacePatchDeletable)((RollableScalableResource)((NonNamespaceOperation)this.resources().inNamespace(namespace)).withName(newName)).cascading(false)).delete();
                this.waitUntilDeleted(namespace, newName);
                createdObj.getMetadata().setResourceVersion(null);
                createdObj.getMetadata().setName(oldName);
                createdObj = (HasMetadata)((NonNamespaceOperation)this.resources().inNamespace(namespace)).create(createdObj);
                createdObj = this.removeDeploymentKey(createdObj.getMetadata().getName());
            }
            return (T)createdObj;
        }
        catch (JsonProcessingException | NoSuchAlgorithmException e) {
            throw new KubernetesClientException("Could not calculate MD5 of RC", e);
        }
    }

    public static Map<String, Object> requestPayLoadForRolloutPause() {
        HashMap<String, Object> jsonPatchPayload = new HashMap<String, Object>();
        HashMap<String, Boolean> spec = new HashMap<String, Boolean>();
        spec.put("paused", true);
        jsonPatchPayload.put("spec", spec);
        return jsonPatchPayload;
    }

    public static Map<String, Object> requestPayLoadForRolloutResume() {
        HashMap<String, Object> jsonPatchPayload = new HashMap<String, Object>();
        HashMap<String, Object> spec = new HashMap<String, Object>();
        spec.put("paused", null);
        jsonPatchPayload.put("spec", spec);
        return jsonPatchPayload;
    }

    public static Map<String, Object> requestPayLoadForRolloutRestart() {
        HashMap<String, Object> jsonPatchPayload = new HashMap<String, Object>();
        HashMap<String, String> annotations = new HashMap<String, String>();
        annotations.put("kubectl.kubernetes.io/restartedAt", new Date().toInstant().atOffset(ZoneOffset.UTC).format(DateTimeFormatter.ISO_LOCAL_DATE_TIME));
        HashMap<String, HashMap<String, String>> templateMetadata = new HashMap<String, HashMap<String, String>>();
        templateMetadata.put("annotations", annotations);
        HashMap<String, HashMap<String, HashMap<String, String>>> template = new HashMap<String, HashMap<String, HashMap<String, String>>>();
        template.put("metadata", templateMetadata);
        HashMap<String, HashMap<String, HashMap<String, HashMap<String, String>>>> deploymentSpec = new HashMap<String, HashMap<String, HashMap<String, HashMap<String, String>>>>();
        deploymentSpec.put("template", template);
        jsonPatchPayload.put("spec", deploymentSpec);
        return jsonPatchPayload;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitUntilPodsAreReady(T obj, String namespace, int requiredPodCount) {
        AtomicInteger podCount = new AtomicInteger(0);
        CompletableFuture future = this.selectedPodLister(obj).informOnCondition(items -> {
            int count = 0;
            for (Pod item : items) {
                for (PodCondition c : item.getStatus().getConditions()) {
                    if (!c.getType().equals("Ready") || !c.getStatus().equals("True")) continue;
                    ++count;
                }
            }
            podCount.set(count);
            return count == requiredPodCount;
        });
        ScheduledFuture<?> logger = Utils.scheduleAtFixedRate(Utils.getCommonExecutorSerive(), () -> LOG.debug("Only {}/{} pod(s) ready for {}: {} in namespace: {} seconds so waiting...", new Object[]{podCount.get(), requiredPodCount, obj.getKind(), obj.getMetadata().getName(), namespace}), 0L, this.loggingIntervalMillis, TimeUnit.MILLISECONDS);
        try {
            if (!Utils.waitUntilReady(future, this.rollingTimeoutMillis, TimeUnit.MILLISECONDS)) {
                LOG.warn("Only {}/{} pod(s) ready for {}: {} in namespace: {}  after waiting for {} seconds so giving up", new Object[]{podCount.get(), requiredPodCount, obj.getKind(), obj.getMetadata().getName(), namespace, TimeUnit.MILLISECONDS.toSeconds(this.rollingTimeoutMillis)});
            }
        }
        finally {
            future.cancel(true);
            logger.cancel(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitUntilDeleted(String namespace, String name) {
        ScheduledFuture<?> logger = Utils.scheduleAtFixedRate(Utils.getCommonExecutorSerive(), () -> LOG.debug("Found resource {}/{} not yet deleted on server, so waiting...", (Object)namespace, (Object)name), 0L, this.loggingIntervalMillis, TimeUnit.MILLISECONDS);
        try {
            ((RollableScalableResource)((NonNamespaceOperation)this.resources().inNamespace(namespace)).withName(name)).waitUntilCondition(Objects::isNull, DEFAULT_SERVER_GC_WAIT_TIMEOUT, TimeUnit.MILLISECONDS);
        }
        finally {
            logger.cancel(true);
        }
    }

    private String md5sum(HasMetadata obj) throws NoSuchAlgorithmException, JsonProcessingException {
        byte[] digest = MessageDigest.getInstance("MD5").digest(SerializationUtils.dumpWithoutRuntimeStateAsYaml(obj).getBytes());
        BigInteger i = new BigInteger(1, digest);
        return String.format("%1$032x", i);
    }

    protected abstract Operation<T, L, RollableScalableResource<T>> resources();

    protected Operation<Pod, PodList, PodResource<Pod>> pods() {
        return new PodOperationsImpl(this.clientContext);
    }

    protected FilterWatchListDeletable<Pod, PodList> selectedPodLister(LabelSelector selector) {
        return (FilterWatchListDeletable)((NonNamespaceOperation)this.pods().inNamespace(this.namespace)).withLabelSelector(selector);
    }
}

