/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v5_12.autoscaling.v1;

import io.fabric8.kubernetes.api.builder.v5_12.BaseFluent;
import io.fabric8.kubernetes.api.builder.v5_12.Nested;
import io.fabric8.kubernetes.api.model.v5_12.ListMeta;
import io.fabric8.kubernetes.api.model.v5_12.autoscaling.v1.HorizontalPodAutoscaler;
import io.fabric8.kubernetes.api.model.v5_12.autoscaling.v1.HorizontalPodAutoscalerBuilder;
import io.fabric8.kubernetes.api.model.v5_12.autoscaling.v1.HorizontalPodAutoscalerFluentImpl;
import io.fabric8.kubernetes.api.model.v5_12.autoscaling.v1.HorizontalPodAutoscalerList;
import io.fabric8.kubernetes.api.model.v5_12.autoscaling.v1.HorizontalPodAutoscalerListFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class HorizontalPodAutoscalerListFluentImpl<A extends HorizontalPodAutoscalerListFluent<A>>
extends BaseFluent<A>
implements HorizontalPodAutoscalerListFluent<A> {
    private String apiVersion;
    private List<HorizontalPodAutoscalerBuilder> items = new ArrayList<HorizontalPodAutoscalerBuilder>();
    private String kind;
    private ListMeta metadata;
    private Map<String, Object> additionalProperties;

    public HorizontalPodAutoscalerListFluentImpl() {
    }

    public HorizontalPodAutoscalerListFluentImpl(HorizontalPodAutoscalerList instance) {
        this.withApiVersion(instance.getApiVersion());
        this.withItems(instance.getItems());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
        this.withAdditionalProperties(instance.getAdditionalProperties());
    }

    @Override
    public String getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public A withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (A)this;
    }

    @Override
    public Boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    @Override
    @Deprecated
    public A withNewApiVersion(String arg0) {
        return this.withApiVersion(new String(arg0));
    }

    @Override
    public A addToItems(Integer index, HorizontalPodAutoscaler item) {
        if (this.items == null) {
            this.items = new ArrayList<HorizontalPodAutoscalerBuilder>();
        }
        HorizontalPodAutoscalerBuilder builder = new HorizontalPodAutoscalerBuilder(item);
        this._visitables.get("items").add(index >= 0 ? index.intValue() : this._visitables.get("items").size(), builder);
        this.items.add(index >= 0 ? index.intValue() : this.items.size(), builder);
        return (A)this;
    }

    @Override
    public A setToItems(Integer index, HorizontalPodAutoscaler item) {
        if (this.items == null) {
            this.items = new ArrayList<HorizontalPodAutoscalerBuilder>();
        }
        HorizontalPodAutoscalerBuilder builder = new HorizontalPodAutoscalerBuilder(item);
        if (index < 0 || index >= this._visitables.get("items").size()) {
            this._visitables.get("items").add(builder);
        } else {
            this._visitables.get("items").set(index, builder);
        }
        if (index < 0 || index >= this.items.size()) {
            this.items.add(builder);
        } else {
            this.items.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToItems(HorizontalPodAutoscaler ... items) {
        if (this.items == null) {
            this.items = new ArrayList<HorizontalPodAutoscalerBuilder>();
        }
        for (HorizontalPodAutoscaler item : items) {
            HorizontalPodAutoscalerBuilder builder = new HorizontalPodAutoscalerBuilder(item);
            this._visitables.get("items").add(builder);
            this.items.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToItems(Collection<HorizontalPodAutoscaler> items) {
        if (this.items == null) {
            this.items = new ArrayList<HorizontalPodAutoscalerBuilder>();
        }
        for (HorizontalPodAutoscaler item : items) {
            HorizontalPodAutoscalerBuilder builder = new HorizontalPodAutoscalerBuilder(item);
            this._visitables.get("items").add(builder);
            this.items.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromItems(HorizontalPodAutoscaler ... items) {
        for (HorizontalPodAutoscaler item : items) {
            HorizontalPodAutoscalerBuilder builder = new HorizontalPodAutoscalerBuilder(item);
            this._visitables.get("items").remove(builder);
            if (this.items == null) continue;
            this.items.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromItems(Collection<HorizontalPodAutoscaler> items) {
        for (HorizontalPodAutoscaler item : items) {
            HorizontalPodAutoscalerBuilder builder = new HorizontalPodAutoscalerBuilder(item);
            this._visitables.get("items").remove(builder);
            if (this.items == null) continue;
            this.items.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromItems(Predicate<HorizontalPodAutoscalerBuilder> predicate) {
        if (this.items == null) {
            return (A)this;
        }
        Iterator<HorizontalPodAutoscalerBuilder> each = this.items.iterator();
        Object visitables = this._visitables.get("items");
        while (each.hasNext()) {
            HorizontalPodAutoscalerBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<HorizontalPodAutoscaler> getItems() {
        return HorizontalPodAutoscalerListFluentImpl.build(this.items);
    }

    @Override
    public List<HorizontalPodAutoscaler> buildItems() {
        return HorizontalPodAutoscalerListFluentImpl.build(this.items);
    }

    @Override
    public HorizontalPodAutoscaler buildItem(Integer index) {
        return this.items.get(index).build();
    }

    @Override
    public HorizontalPodAutoscaler buildFirstItem() {
        return this.items.get(0).build();
    }

    @Override
    public HorizontalPodAutoscaler buildLastItem() {
        return this.items.get(this.items.size() - 1).build();
    }

    @Override
    public HorizontalPodAutoscaler buildMatchingItem(Predicate<HorizontalPodAutoscalerBuilder> predicate) {
        for (HorizontalPodAutoscalerBuilder item : this.items) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingItem(Predicate<HorizontalPodAutoscalerBuilder> predicate) {
        for (HorizontalPodAutoscalerBuilder item : this.items) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withItems(List<HorizontalPodAutoscaler> items) {
        if (this.items != null) {
            this._visitables.get("items").removeAll(this.items);
        }
        if (items != null) {
            this.items = new ArrayList<HorizontalPodAutoscalerBuilder>();
            for (HorizontalPodAutoscaler item : items) {
                this.addToItems(item);
            }
        } else {
            this.items = null;
        }
        return (A)this;
    }

    @Override
    public A withItems(HorizontalPodAutoscaler ... items) {
        if (this.items != null) {
            this.items.clear();
        }
        if (items != null) {
            for (HorizontalPodAutoscaler item : items) {
                this.addToItems(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasItems() {
        return this.items != null && !this.items.isEmpty();
    }

    @Override
    public HorizontalPodAutoscalerListFluent.ItemsNested<A> addNewItem() {
        return new ItemsNestedImpl();
    }

    @Override
    public HorizontalPodAutoscalerListFluent.ItemsNested<A> addNewItemLike(HorizontalPodAutoscaler item) {
        return new ItemsNestedImpl(-1, item);
    }

    @Override
    public HorizontalPodAutoscalerListFluent.ItemsNested<A> setNewItemLike(Integer index, HorizontalPodAutoscaler item) {
        return new ItemsNestedImpl(index, item);
    }

    @Override
    public HorizontalPodAutoscalerListFluent.ItemsNested<A> editItem(Integer index) {
        if (this.items.size() <= index) {
            throw new RuntimeException("Can't edit items. Index exceeds size.");
        }
        return this.setNewItemLike(index, this.buildItem(index));
    }

    @Override
    public HorizontalPodAutoscalerListFluent.ItemsNested<A> editFirstItem() {
        if (this.items.size() == 0) {
            throw new RuntimeException("Can't edit first items. The list is empty.");
        }
        return this.setNewItemLike(0, this.buildItem(0));
    }

    @Override
    public HorizontalPodAutoscalerListFluent.ItemsNested<A> editLastItem() {
        int index = this.items.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last items. The list is empty.");
        }
        return this.setNewItemLike(index, this.buildItem(index));
    }

    @Override
    public HorizontalPodAutoscalerListFluent.ItemsNested<A> editMatchingItem(Predicate<HorizontalPodAutoscalerBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.items.size(); ++i) {
            if (!predicate.test(this.items.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching items. No match found.");
        }
        return this.setNewItemLike(index, this.buildItem(index));
    }

    @Override
    public String getKind() {
        return this.kind;
    }

    @Override
    public A withKind(String kind) {
        this.kind = kind;
        return (A)this;
    }

    @Override
    public Boolean hasKind() {
        return this.kind != null;
    }

    @Override
    @Deprecated
    public A withNewKind(String arg0) {
        return this.withKind(new String(arg0));
    }

    @Override
    public ListMeta getMetadata() {
        return this.metadata;
    }

    @Override
    public A withMetadata(ListMeta metadata) {
        this.metadata = metadata;
        return (A)this;
    }

    @Override
    public Boolean hasMetadata() {
        return this.metadata != null;
    }

    @Override
    public A withNewMetadata(String _continue, Long remainingItemCount, String resourceVersion, String selfLink) {
        return this.withMetadata(new ListMeta(_continue, remainingItemCount, resourceVersion, selfLink));
    }

    @Override
    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    @Override
    public Boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HorizontalPodAutoscalerListFluentImpl that = (HorizontalPodAutoscalerListFluentImpl)o;
        if (this.apiVersion != null ? !this.apiVersion.equals(that.apiVersion) : that.apiVersion != null) {
            return false;
        }
        if (this.items != null ? !this.items.equals(that.items) : that.items != null) {
            return false;
        }
        if (this.kind != null ? !this.kind.equals(that.kind) : that.kind != null) {
            return false;
        }
        if (this.metadata != null ? !this.metadata.equals(that.metadata) : that.metadata != null) {
            return false;
        }
        return !(this.additionalProperties != null ? !this.additionalProperties.equals(that.additionalProperties) : that.additionalProperties != null);
    }

    public int hashCode() {
        return Objects.hash(this.apiVersion, this.items, this.kind, this.metadata, this.additionalProperties, super.hashCode());
    }

    public class ItemsNestedImpl<N>
    extends HorizontalPodAutoscalerFluentImpl<HorizontalPodAutoscalerListFluent.ItemsNested<N>>
    implements HorizontalPodAutoscalerListFluent.ItemsNested<N>,
    Nested<N> {
        HorizontalPodAutoscalerBuilder builder;
        Integer index;

        ItemsNestedImpl(Integer index, HorizontalPodAutoscaler item) {
            this.index = index;
            this.builder = new HorizontalPodAutoscalerBuilder(this, item);
        }

        ItemsNestedImpl() {
            this.index = -1;
            this.builder = new HorizontalPodAutoscalerBuilder(this);
        }

        @Override
        public N and() {
            return (N)HorizontalPodAutoscalerListFluentImpl.this.setToItems(this.index, this.builder.build());
        }

        @Override
        public N endItem() {
            return this.and();
        }
    }
}

