/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v5_12;

import io.fabric8.kubernetes.api.builder.v5_12.VisitableBuilder;
import io.fabric8.kubernetes.api.model.v5_12.APIResourceList;
import io.fabric8.kubernetes.api.model.v5_12.APIResourceListFluent;
import io.fabric8.kubernetes.api.model.v5_12.APIResourceListFluentImpl;
import java.util.Objects;

public class APIResourceListBuilder
extends APIResourceListFluentImpl<APIResourceListBuilder>
implements VisitableBuilder<APIResourceList, APIResourceListBuilder> {
    APIResourceListFluent<?> fluent;
    Boolean validationEnabled;

    public APIResourceListBuilder() {
        this(false);
    }

    public APIResourceListBuilder(Boolean validationEnabled) {
        this(new APIResourceList(), validationEnabled);
    }

    public APIResourceListBuilder(APIResourceListFluent<?> fluent) {
        this(fluent, (Boolean)false);
    }

    public APIResourceListBuilder(APIResourceListFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new APIResourceList(), validationEnabled);
    }

    public APIResourceListBuilder(APIResourceListFluent<?> fluent, APIResourceList instance) {
        this(fluent, instance, false);
    }

    public APIResourceListBuilder(APIResourceListFluent<?> fluent, APIResourceList instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withApiVersion(instance.getApiVersion());
        fluent.withGroupVersion(instance.getGroupVersion());
        fluent.withKind(instance.getKind());
        fluent.withResources(instance.getResources());
        fluent.withAdditionalProperties(instance.getAdditionalProperties());
        this.validationEnabled = validationEnabled;
    }

    public APIResourceListBuilder(APIResourceList instance) {
        this(instance, (Boolean)false);
    }

    public APIResourceListBuilder(APIResourceList instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withApiVersion(instance.getApiVersion());
        this.withGroupVersion(instance.getGroupVersion());
        this.withKind(instance.getKind());
        this.withResources(instance.getResources());
        this.withAdditionalProperties(instance.getAdditionalProperties());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public APIResourceList build() {
        APIResourceList buildable = new APIResourceList(this.fluent.getApiVersion(), this.fluent.getGroupVersion(), this.fluent.getKind(), this.fluent.getResources());
        buildable.setAdditionalProperties(this.fluent.getAdditionalProperties());
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        APIResourceListBuilder that = (APIResourceListBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.fluent, this.validationEnabled, super.hashCode());
    }
}

