/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.installer.ibmcloud.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openshift.api.model.installer.ibmcloud.v1.MachinePool;
import io.fabric8.openshift.api.model.installer.ibmcloud.v1.MachinePoolBuilder;
import io.fabric8.openshift.api.model.installer.ibmcloud.v1.MachinePoolFluentImpl;
import io.fabric8.openshift.api.model.installer.ibmcloud.v1.Platform;
import io.fabric8.openshift.api.model.installer.ibmcloud.v1.PlatformFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class PlatformFluentImpl<A extends PlatformFluent<A>>
extends BaseFluent<A>
implements PlatformFluent<A> {
    private MachinePoolBuilder defaultMachinePlatform;
    private String region;
    private String resourceGroupName;
    private List<String> subnets = new ArrayList<String>();
    private String vpc;
    private String vpcResourceGroupName;
    private Map<String, Object> additionalProperties;

    public PlatformFluentImpl() {
    }

    public PlatformFluentImpl(Platform instance) {
        this.withDefaultMachinePlatform(instance.getDefaultMachinePlatform());
        this.withRegion(instance.getRegion());
        this.withResourceGroupName(instance.getResourceGroupName());
        this.withSubnets(instance.getSubnets());
        this.withVpc(instance.getVpc());
        this.withVpcResourceGroupName(instance.getVpcResourceGroupName());
        this.withAdditionalProperties(instance.getAdditionalProperties());
    }

    @Override
    @Deprecated
    public MachinePool getDefaultMachinePlatform() {
        return this.defaultMachinePlatform != null ? this.defaultMachinePlatform.build() : null;
    }

    @Override
    public MachinePool buildDefaultMachinePlatform() {
        return this.defaultMachinePlatform != null ? this.defaultMachinePlatform.build() : null;
    }

    @Override
    public A withDefaultMachinePlatform(MachinePool defaultMachinePlatform) {
        this._visitables.get("defaultMachinePlatform").remove(this.defaultMachinePlatform);
        if (defaultMachinePlatform != null) {
            this.defaultMachinePlatform = new MachinePoolBuilder(defaultMachinePlatform);
            this._visitables.get("defaultMachinePlatform").add(this.defaultMachinePlatform);
        }
        return (A)this;
    }

    @Override
    public Boolean hasDefaultMachinePlatform() {
        return this.defaultMachinePlatform != null;
    }

    @Override
    public PlatformFluent.DefaultMachinePlatformNested<A> withNewDefaultMachinePlatform() {
        return new DefaultMachinePlatformNestedImpl();
    }

    @Override
    public PlatformFluent.DefaultMachinePlatformNested<A> withNewDefaultMachinePlatformLike(MachinePool item) {
        return new DefaultMachinePlatformNestedImpl(item);
    }

    @Override
    public PlatformFluent.DefaultMachinePlatformNested<A> editDefaultMachinePlatform() {
        return this.withNewDefaultMachinePlatformLike(this.getDefaultMachinePlatform());
    }

    @Override
    public PlatformFluent.DefaultMachinePlatformNested<A> editOrNewDefaultMachinePlatform() {
        return this.withNewDefaultMachinePlatformLike(this.getDefaultMachinePlatform() != null ? this.getDefaultMachinePlatform() : new MachinePoolBuilder().build());
    }

    @Override
    public PlatformFluent.DefaultMachinePlatformNested<A> editOrNewDefaultMachinePlatformLike(MachinePool item) {
        return this.withNewDefaultMachinePlatformLike(this.getDefaultMachinePlatform() != null ? this.getDefaultMachinePlatform() : item);
    }

    @Override
    public String getRegion() {
        return this.region;
    }

    @Override
    public A withRegion(String region) {
        this.region = region;
        return (A)this;
    }

    @Override
    public Boolean hasRegion() {
        return this.region != null;
    }

    @Override
    @Deprecated
    public A withNewRegion(String arg0) {
        return this.withRegion(new String(arg0));
    }

    @Override
    public String getResourceGroupName() {
        return this.resourceGroupName;
    }

    @Override
    public A withResourceGroupName(String resourceGroupName) {
        this.resourceGroupName = resourceGroupName;
        return (A)this;
    }

    @Override
    public Boolean hasResourceGroupName() {
        return this.resourceGroupName != null;
    }

    @Override
    @Deprecated
    public A withNewResourceGroupName(String arg0) {
        return this.withResourceGroupName(new String(arg0));
    }

    @Override
    public A addToSubnets(Integer index, String item) {
        if (this.subnets == null) {
            this.subnets = new ArrayList<String>();
        }
        this.subnets.add(index, item);
        return (A)this;
    }

    @Override
    public A setToSubnets(Integer index, String item) {
        if (this.subnets == null) {
            this.subnets = new ArrayList<String>();
        }
        this.subnets.set(index, item);
        return (A)this;
    }

    @Override
    public A addToSubnets(String ... items) {
        if (this.subnets == null) {
            this.subnets = new ArrayList<String>();
        }
        for (String item : items) {
            this.subnets.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToSubnets(Collection<String> items) {
        if (this.subnets == null) {
            this.subnets = new ArrayList<String>();
        }
        for (String item : items) {
            this.subnets.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromSubnets(String ... items) {
        for (String item : items) {
            if (this.subnets == null) continue;
            this.subnets.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromSubnets(Collection<String> items) {
        for (String item : items) {
            if (this.subnets == null) continue;
            this.subnets.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getSubnets() {
        return this.subnets;
    }

    @Override
    public String getSubnet(Integer index) {
        return this.subnets.get(index);
    }

    @Override
    public String getFirstSubnet() {
        return this.subnets.get(0);
    }

    @Override
    public String getLastSubnet() {
        return this.subnets.get(this.subnets.size() - 1);
    }

    @Override
    public String getMatchingSubnet(Predicate<String> predicate) {
        for (String item : this.subnets) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingSubnet(Predicate<String> predicate) {
        for (String item : this.subnets) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withSubnets(List<String> subnets) {
        if (subnets != null) {
            this.subnets = new ArrayList<String>();
            for (String item : subnets) {
                this.addToSubnets(item);
            }
        } else {
            this.subnets = null;
        }
        return (A)this;
    }

    @Override
    public A withSubnets(String ... subnets) {
        if (this.subnets != null) {
            this.subnets.clear();
        }
        if (subnets != null) {
            for (String item : subnets) {
                this.addToSubnets(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasSubnets() {
        return this.subnets != null && !this.subnets.isEmpty();
    }

    @Override
    public A addNewSubnet(String arg0) {
        return this.addToSubnets(new String(arg0));
    }

    @Override
    public String getVpc() {
        return this.vpc;
    }

    @Override
    public A withVpc(String vpc) {
        this.vpc = vpc;
        return (A)this;
    }

    @Override
    public Boolean hasVpc() {
        return this.vpc != null;
    }

    @Override
    @Deprecated
    public A withNewVpc(String arg0) {
        return this.withVpc(new String(arg0));
    }

    @Override
    public String getVpcResourceGroupName() {
        return this.vpcResourceGroupName;
    }

    @Override
    public A withVpcResourceGroupName(String vpcResourceGroupName) {
        this.vpcResourceGroupName = vpcResourceGroupName;
        return (A)this;
    }

    @Override
    public Boolean hasVpcResourceGroupName() {
        return this.vpcResourceGroupName != null;
    }

    @Override
    @Deprecated
    public A withNewVpcResourceGroupName(String arg0) {
        return this.withVpcResourceGroupName(new String(arg0));
    }

    @Override
    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    @Override
    public Boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PlatformFluentImpl that = (PlatformFluentImpl)o;
        if (this.defaultMachinePlatform != null ? !this.defaultMachinePlatform.equals(that.defaultMachinePlatform) : that.defaultMachinePlatform != null) {
            return false;
        }
        if (this.region != null ? !this.region.equals(that.region) : that.region != null) {
            return false;
        }
        if (this.resourceGroupName != null ? !this.resourceGroupName.equals(that.resourceGroupName) : that.resourceGroupName != null) {
            return false;
        }
        if (this.subnets != null ? !this.subnets.equals(that.subnets) : that.subnets != null) {
            return false;
        }
        if (this.vpc != null ? !this.vpc.equals(that.vpc) : that.vpc != null) {
            return false;
        }
        if (this.vpcResourceGroupName != null ? !this.vpcResourceGroupName.equals(that.vpcResourceGroupName) : that.vpcResourceGroupName != null) {
            return false;
        }
        return !(this.additionalProperties != null ? !this.additionalProperties.equals(that.additionalProperties) : that.additionalProperties != null);
    }

    public int hashCode() {
        return Objects.hash(this.defaultMachinePlatform, this.region, this.resourceGroupName, this.subnets, this.vpc, this.vpcResourceGroupName, this.additionalProperties, super.hashCode());
    }

    public class DefaultMachinePlatformNestedImpl<N>
    extends MachinePoolFluentImpl<PlatformFluent.DefaultMachinePlatformNested<N>>
    implements PlatformFluent.DefaultMachinePlatformNested<N>,
    Nested<N> {
        MachinePoolBuilder builder;

        DefaultMachinePlatformNestedImpl(MachinePool item) {
            this.builder = new MachinePoolBuilder(this, item);
        }

        DefaultMachinePlatformNestedImpl() {
            this.builder = new MachinePoolBuilder(this);
        }

        @Override
        public N and() {
            return (N)PlatformFluentImpl.this.withDefaultMachinePlatform(this.builder.build());
        }

        @Override
        public N endDefaultMachinePlatform() {
            return this.and();
        }
    }
}

