/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openshift.api.model.HubSourceStatus;
import io.fabric8.openshift.api.model.HubSourceStatusBuilder;
import io.fabric8.openshift.api.model.HubSourceStatusFluentImpl;
import io.fabric8.openshift.api.model.OperatorHubStatus;
import io.fabric8.openshift.api.model.OperatorHubStatusFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class OperatorHubStatusFluentImpl<A extends OperatorHubStatusFluent<A>>
extends BaseFluent<A>
implements OperatorHubStatusFluent<A> {
    private List<HubSourceStatusBuilder> sources = new ArrayList<HubSourceStatusBuilder>();
    private Map<String, Object> additionalProperties;

    public OperatorHubStatusFluentImpl() {
    }

    public OperatorHubStatusFluentImpl(OperatorHubStatus instance) {
        this.withSources(instance.getSources());
        this.withAdditionalProperties(instance.getAdditionalProperties());
    }

    @Override
    public A addToSources(Integer index, HubSourceStatus item) {
        if (this.sources == null) {
            this.sources = new ArrayList<HubSourceStatusBuilder>();
        }
        HubSourceStatusBuilder builder = new HubSourceStatusBuilder(item);
        this._visitables.get("sources").add(index >= 0 ? index.intValue() : this._visitables.get("sources").size(), builder);
        this.sources.add(index >= 0 ? index.intValue() : this.sources.size(), builder);
        return (A)this;
    }

    @Override
    public A setToSources(Integer index, HubSourceStatus item) {
        if (this.sources == null) {
            this.sources = new ArrayList<HubSourceStatusBuilder>();
        }
        HubSourceStatusBuilder builder = new HubSourceStatusBuilder(item);
        if (index < 0 || index >= this._visitables.get("sources").size()) {
            this._visitables.get("sources").add(builder);
        } else {
            this._visitables.get("sources").set(index, builder);
        }
        if (index < 0 || index >= this.sources.size()) {
            this.sources.add(builder);
        } else {
            this.sources.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToSources(HubSourceStatus ... items) {
        if (this.sources == null) {
            this.sources = new ArrayList<HubSourceStatusBuilder>();
        }
        for (HubSourceStatus item : items) {
            HubSourceStatusBuilder builder = new HubSourceStatusBuilder(item);
            this._visitables.get("sources").add(builder);
            this.sources.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToSources(Collection<HubSourceStatus> items) {
        if (this.sources == null) {
            this.sources = new ArrayList<HubSourceStatusBuilder>();
        }
        for (HubSourceStatus item : items) {
            HubSourceStatusBuilder builder = new HubSourceStatusBuilder(item);
            this._visitables.get("sources").add(builder);
            this.sources.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromSources(HubSourceStatus ... items) {
        for (HubSourceStatus item : items) {
            HubSourceStatusBuilder builder = new HubSourceStatusBuilder(item);
            this._visitables.get("sources").remove(builder);
            if (this.sources == null) continue;
            this.sources.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromSources(Collection<HubSourceStatus> items) {
        for (HubSourceStatus item : items) {
            HubSourceStatusBuilder builder = new HubSourceStatusBuilder(item);
            this._visitables.get("sources").remove(builder);
            if (this.sources == null) continue;
            this.sources.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromSources(Predicate<HubSourceStatusBuilder> predicate) {
        if (this.sources == null) {
            return (A)this;
        }
        Iterator<HubSourceStatusBuilder> each = this.sources.iterator();
        Object visitables = this._visitables.get("sources");
        while (each.hasNext()) {
            HubSourceStatusBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<HubSourceStatus> getSources() {
        return OperatorHubStatusFluentImpl.build(this.sources);
    }

    @Override
    public List<HubSourceStatus> buildSources() {
        return OperatorHubStatusFluentImpl.build(this.sources);
    }

    @Override
    public HubSourceStatus buildSource(Integer index) {
        return this.sources.get(index).build();
    }

    @Override
    public HubSourceStatus buildFirstSource() {
        return this.sources.get(0).build();
    }

    @Override
    public HubSourceStatus buildLastSource() {
        return this.sources.get(this.sources.size() - 1).build();
    }

    @Override
    public HubSourceStatus buildMatchingSource(Predicate<HubSourceStatusBuilder> predicate) {
        for (HubSourceStatusBuilder item : this.sources) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingSource(Predicate<HubSourceStatusBuilder> predicate) {
        for (HubSourceStatusBuilder item : this.sources) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withSources(List<HubSourceStatus> sources) {
        if (this.sources != null) {
            this._visitables.get("sources").removeAll(this.sources);
        }
        if (sources != null) {
            this.sources = new ArrayList<HubSourceStatusBuilder>();
            for (HubSourceStatus item : sources) {
                this.addToSources(item);
            }
        } else {
            this.sources = null;
        }
        return (A)this;
    }

    @Override
    public A withSources(HubSourceStatus ... sources) {
        if (this.sources != null) {
            this.sources.clear();
        }
        if (sources != null) {
            for (HubSourceStatus item : sources) {
                this.addToSources(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasSources() {
        return this.sources != null && !this.sources.isEmpty();
    }

    @Override
    public A addNewSource(Boolean disabled, String message, String name, String status) {
        return this.addToSources(new HubSourceStatus(disabled, message, name, status));
    }

    @Override
    public OperatorHubStatusFluent.SourcesNested<A> addNewSource() {
        return new SourcesNestedImpl();
    }

    @Override
    public OperatorHubStatusFluent.SourcesNested<A> addNewSourceLike(HubSourceStatus item) {
        return new SourcesNestedImpl(-1, item);
    }

    @Override
    public OperatorHubStatusFluent.SourcesNested<A> setNewSourceLike(Integer index, HubSourceStatus item) {
        return new SourcesNestedImpl(index, item);
    }

    @Override
    public OperatorHubStatusFluent.SourcesNested<A> editSource(Integer index) {
        if (this.sources.size() <= index) {
            throw new RuntimeException("Can't edit sources. Index exceeds size.");
        }
        return this.setNewSourceLike(index, this.buildSource(index));
    }

    @Override
    public OperatorHubStatusFluent.SourcesNested<A> editFirstSource() {
        if (this.sources.size() == 0) {
            throw new RuntimeException("Can't edit first sources. The list is empty.");
        }
        return this.setNewSourceLike(0, this.buildSource(0));
    }

    @Override
    public OperatorHubStatusFluent.SourcesNested<A> editLastSource() {
        int index = this.sources.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last sources. The list is empty.");
        }
        return this.setNewSourceLike(index, this.buildSource(index));
    }

    @Override
    public OperatorHubStatusFluent.SourcesNested<A> editMatchingSource(Predicate<HubSourceStatusBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.sources.size(); ++i) {
            if (!predicate.test(this.sources.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching sources. No match found.");
        }
        return this.setNewSourceLike(index, this.buildSource(index));
    }

    @Override
    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    @Override
    public Boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OperatorHubStatusFluentImpl that = (OperatorHubStatusFluentImpl)o;
        if (this.sources != null ? !this.sources.equals(that.sources) : that.sources != null) {
            return false;
        }
        return !(this.additionalProperties != null ? !this.additionalProperties.equals(that.additionalProperties) : that.additionalProperties != null);
    }

    public int hashCode() {
        return Objects.hash(this.sources, this.additionalProperties, super.hashCode());
    }

    public class SourcesNestedImpl<N>
    extends HubSourceStatusFluentImpl<OperatorHubStatusFluent.SourcesNested<N>>
    implements OperatorHubStatusFluent.SourcesNested<N>,
    Nested<N> {
        HubSourceStatusBuilder builder;
        Integer index;

        SourcesNestedImpl(Integer index, HubSourceStatus item) {
            this.index = index;
            this.builder = new HubSourceStatusBuilder(this, item);
        }

        SourcesNestedImpl() {
            this.index = -1;
            this.builder = new HubSourceStatusBuilder(this);
        }

        @Override
        public N and() {
            return (N)OperatorHubStatusFluentImpl.this.setToSources(this.index, this.builder.build());
        }

        @Override
        public N endSource() {
            return this.and();
        }
    }
}

