/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.v5_12.miscellaneous.metal3.v1alpha1;

import io.fabric8.kubernetes.api.builder.v5_12.BaseFluent;
import io.fabric8.openshift.api.model.v5_12.miscellaneous.metal3.v1alpha1.CPU;
import io.fabric8.openshift.api.model.v5_12.miscellaneous.metal3.v1alpha1.CPUFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class CPUFluentImpl<A extends CPUFluent<A>>
extends BaseFluent<A>
implements CPUFluent<A> {
    private String arch;
    private Double clockMegahertz;
    private Integer count;
    private List<String> flags = new ArrayList<String>();
    private String model;
    private Map<String, Object> additionalProperties;

    public CPUFluentImpl() {
    }

    public CPUFluentImpl(CPU instance) {
        this.withArch(instance.getArch());
        this.withClockMegahertz(instance.getClockMegahertz());
        this.withCount(instance.getCount());
        this.withFlags(instance.getFlags());
        this.withModel(instance.getModel());
        this.withAdditionalProperties(instance.getAdditionalProperties());
    }

    @Override
    public String getArch() {
        return this.arch;
    }

    @Override
    public A withArch(String arch) {
        this.arch = arch;
        return (A)this;
    }

    @Override
    public Boolean hasArch() {
        return this.arch != null;
    }

    @Override
    @Deprecated
    public A withNewArch(String arg0) {
        return this.withArch(new String(arg0));
    }

    @Override
    public Double getClockMegahertz() {
        return this.clockMegahertz;
    }

    @Override
    public A withClockMegahertz(Double clockMegahertz) {
        this.clockMegahertz = clockMegahertz;
        return (A)this;
    }

    @Override
    public Boolean hasClockMegahertz() {
        return this.clockMegahertz != null;
    }

    @Override
    public Integer getCount() {
        return this.count;
    }

    @Override
    public A withCount(Integer count) {
        this.count = count;
        return (A)this;
    }

    @Override
    public Boolean hasCount() {
        return this.count != null;
    }

    @Override
    public A addToFlags(Integer index, String item) {
        if (this.flags == null) {
            this.flags = new ArrayList<String>();
        }
        this.flags.add(index, item);
        return (A)this;
    }

    @Override
    public A setToFlags(Integer index, String item) {
        if (this.flags == null) {
            this.flags = new ArrayList<String>();
        }
        this.flags.set(index, item);
        return (A)this;
    }

    @Override
    public A addToFlags(String ... items) {
        if (this.flags == null) {
            this.flags = new ArrayList<String>();
        }
        for (String item : items) {
            this.flags.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToFlags(Collection<String> items) {
        if (this.flags == null) {
            this.flags = new ArrayList<String>();
        }
        for (String item : items) {
            this.flags.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromFlags(String ... items) {
        for (String item : items) {
            if (this.flags == null) continue;
            this.flags.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromFlags(Collection<String> items) {
        for (String item : items) {
            if (this.flags == null) continue;
            this.flags.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getFlags() {
        return this.flags;
    }

    @Override
    public String getFlag(Integer index) {
        return this.flags.get(index);
    }

    @Override
    public String getFirstFlag() {
        return this.flags.get(0);
    }

    @Override
    public String getLastFlag() {
        return this.flags.get(this.flags.size() - 1);
    }

    @Override
    public String getMatchingFlag(Predicate<String> predicate) {
        for (String item : this.flags) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingFlag(Predicate<String> predicate) {
        for (String item : this.flags) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withFlags(List<String> flags) {
        if (flags != null) {
            this.flags = new ArrayList<String>();
            for (String item : flags) {
                this.addToFlags(item);
            }
        } else {
            this.flags = null;
        }
        return (A)this;
    }

    @Override
    public A withFlags(String ... flags) {
        if (this.flags != null) {
            this.flags.clear();
        }
        if (flags != null) {
            for (String item : flags) {
                this.addToFlags(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasFlags() {
        return this.flags != null && !this.flags.isEmpty();
    }

    @Override
    public A addNewFlag(String arg0) {
        return this.addToFlags(new String(arg0));
    }

    @Override
    public String getModel() {
        return this.model;
    }

    @Override
    public A withModel(String model) {
        this.model = model;
        return (A)this;
    }

    @Override
    public Boolean hasModel() {
        return this.model != null;
    }

    @Override
    @Deprecated
    public A withNewModel(String arg0) {
        return this.withModel(new String(arg0));
    }

    @Override
    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    @Override
    public Boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CPUFluentImpl that = (CPUFluentImpl)o;
        if (this.arch != null ? !this.arch.equals(that.arch) : that.arch != null) {
            return false;
        }
        if (this.clockMegahertz != null ? !this.clockMegahertz.equals(that.clockMegahertz) : that.clockMegahertz != null) {
            return false;
        }
        if (this.count != null ? !this.count.equals(that.count) : that.count != null) {
            return false;
        }
        if (this.flags != null ? !this.flags.equals(that.flags) : that.flags != null) {
            return false;
        }
        if (this.model != null ? !this.model.equals(that.model) : that.model != null) {
            return false;
        }
        return !(this.additionalProperties != null ? !this.additionalProperties.equals(that.additionalProperties) : that.additionalProperties != null);
    }

    public int hashCode() {
        return Objects.hash(this.arch, this.clockMegahertz, this.count, this.flags, this.model, this.additionalProperties, super.hashCode());
    }
}

