/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.v5_12.installer.ovirt.v1;

import io.fabric8.kubernetes.api.builder.v5_12.BaseFluent;
import io.fabric8.kubernetes.api.builder.v5_12.Nested;
import io.fabric8.openshift.api.model.v5_12.installer.ovirt.v1.CPU;
import io.fabric8.openshift.api.model.v5_12.installer.ovirt.v1.CPUBuilder;
import io.fabric8.openshift.api.model.v5_12.installer.ovirt.v1.CPUFluentImpl;
import io.fabric8.openshift.api.model.v5_12.installer.ovirt.v1.Disk;
import io.fabric8.openshift.api.model.v5_12.installer.ovirt.v1.DiskBuilder;
import io.fabric8.openshift.api.model.v5_12.installer.ovirt.v1.DiskFluentImpl;
import io.fabric8.openshift.api.model.v5_12.installer.ovirt.v1.MachinePool;
import io.fabric8.openshift.api.model.v5_12.installer.ovirt.v1.MachinePoolFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class MachinePoolFluentImpl<A extends MachinePoolFluent<A>>
extends BaseFluent<A>
implements MachinePoolFluent<A> {
    private List<String> affinityGroupsNames = new ArrayList<String>();
    private String autoPinningPolicy;
    private CPUBuilder cpu;
    private Integer hugepages;
    private String instanceTypeID;
    private Integer memoryMB;
    private DiskBuilder osDisk;
    private String vmType;
    private Map<String, Object> additionalProperties;

    public MachinePoolFluentImpl() {
    }

    public MachinePoolFluentImpl(MachinePool instance) {
        this.withAffinityGroupsNames(instance.getAffinityGroupsNames());
        this.withAutoPinningPolicy(instance.getAutoPinningPolicy());
        this.withCpu(instance.getCpu());
        this.withHugepages(instance.getHugepages());
        this.withInstanceTypeID(instance.getInstanceTypeID());
        this.withMemoryMB(instance.getMemoryMB());
        this.withOsDisk(instance.getOsDisk());
        this.withVmType(instance.getVmType());
        this.withAdditionalProperties(instance.getAdditionalProperties());
    }

    @Override
    public A addToAffinityGroupsNames(Integer index, String item) {
        if (this.affinityGroupsNames == null) {
            this.affinityGroupsNames = new ArrayList<String>();
        }
        this.affinityGroupsNames.add(index, item);
        return (A)this;
    }

    @Override
    public A setToAffinityGroupsNames(Integer index, String item) {
        if (this.affinityGroupsNames == null) {
            this.affinityGroupsNames = new ArrayList<String>();
        }
        this.affinityGroupsNames.set(index, item);
        return (A)this;
    }

    @Override
    public A addToAffinityGroupsNames(String ... items) {
        if (this.affinityGroupsNames == null) {
            this.affinityGroupsNames = new ArrayList<String>();
        }
        for (String item : items) {
            this.affinityGroupsNames.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToAffinityGroupsNames(Collection<String> items) {
        if (this.affinityGroupsNames == null) {
            this.affinityGroupsNames = new ArrayList<String>();
        }
        for (String item : items) {
            this.affinityGroupsNames.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromAffinityGroupsNames(String ... items) {
        for (String item : items) {
            if (this.affinityGroupsNames == null) continue;
            this.affinityGroupsNames.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromAffinityGroupsNames(Collection<String> items) {
        for (String item : items) {
            if (this.affinityGroupsNames == null) continue;
            this.affinityGroupsNames.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getAffinityGroupsNames() {
        return this.affinityGroupsNames;
    }

    @Override
    public String getAffinityGroupsName(Integer index) {
        return this.affinityGroupsNames.get(index);
    }

    @Override
    public String getFirstAffinityGroupsName() {
        return this.affinityGroupsNames.get(0);
    }

    @Override
    public String getLastAffinityGroupsName() {
        return this.affinityGroupsNames.get(this.affinityGroupsNames.size() - 1);
    }

    @Override
    public String getMatchingAffinityGroupsName(Predicate<String> predicate) {
        for (String item : this.affinityGroupsNames) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingAffinityGroupsName(Predicate<String> predicate) {
        for (String item : this.affinityGroupsNames) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withAffinityGroupsNames(List<String> affinityGroupsNames) {
        if (affinityGroupsNames != null) {
            this.affinityGroupsNames = new ArrayList<String>();
            for (String item : affinityGroupsNames) {
                this.addToAffinityGroupsNames(item);
            }
        } else {
            this.affinityGroupsNames = null;
        }
        return (A)this;
    }

    @Override
    public A withAffinityGroupsNames(String ... affinityGroupsNames) {
        if (this.affinityGroupsNames != null) {
            this.affinityGroupsNames.clear();
        }
        if (affinityGroupsNames != null) {
            for (String item : affinityGroupsNames) {
                this.addToAffinityGroupsNames(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasAffinityGroupsNames() {
        return this.affinityGroupsNames != null && !this.affinityGroupsNames.isEmpty();
    }

    @Override
    public A addNewAffinityGroupsName(String arg0) {
        return this.addToAffinityGroupsNames(new String(arg0));
    }

    @Override
    public String getAutoPinningPolicy() {
        return this.autoPinningPolicy;
    }

    @Override
    public A withAutoPinningPolicy(String autoPinningPolicy) {
        this.autoPinningPolicy = autoPinningPolicy;
        return (A)this;
    }

    @Override
    public Boolean hasAutoPinningPolicy() {
        return this.autoPinningPolicy != null;
    }

    @Override
    @Deprecated
    public A withNewAutoPinningPolicy(String arg0) {
        return this.withAutoPinningPolicy(new String(arg0));
    }

    @Override
    @Deprecated
    public CPU getCpu() {
        return this.cpu != null ? this.cpu.build() : null;
    }

    @Override
    public CPU buildCpu() {
        return this.cpu != null ? this.cpu.build() : null;
    }

    @Override
    public A withCpu(CPU cpu) {
        this._visitables.get("cpu").remove(this.cpu);
        if (cpu != null) {
            this.cpu = new CPUBuilder(cpu);
            this._visitables.get("cpu").add(this.cpu);
        }
        return (A)this;
    }

    @Override
    public Boolean hasCpu() {
        return this.cpu != null;
    }

    @Override
    public A withNewCpu(Integer cores, Integer sockets) {
        return this.withCpu(new CPU(cores, sockets));
    }

    @Override
    public MachinePoolFluent.CpuNested<A> withNewCpu() {
        return new CpuNestedImpl();
    }

    @Override
    public MachinePoolFluent.CpuNested<A> withNewCpuLike(CPU item) {
        return new CpuNestedImpl(item);
    }

    @Override
    public MachinePoolFluent.CpuNested<A> editCpu() {
        return this.withNewCpuLike(this.getCpu());
    }

    @Override
    public MachinePoolFluent.CpuNested<A> editOrNewCpu() {
        return this.withNewCpuLike(this.getCpu() != null ? this.getCpu() : new CPUBuilder().build());
    }

    @Override
    public MachinePoolFluent.CpuNested<A> editOrNewCpuLike(CPU item) {
        return this.withNewCpuLike(this.getCpu() != null ? this.getCpu() : item);
    }

    @Override
    public Integer getHugepages() {
        return this.hugepages;
    }

    @Override
    public A withHugepages(Integer hugepages) {
        this.hugepages = hugepages;
        return (A)this;
    }

    @Override
    public Boolean hasHugepages() {
        return this.hugepages != null;
    }

    @Override
    public String getInstanceTypeID() {
        return this.instanceTypeID;
    }

    @Override
    public A withInstanceTypeID(String instanceTypeID) {
        this.instanceTypeID = instanceTypeID;
        return (A)this;
    }

    @Override
    public Boolean hasInstanceTypeID() {
        return this.instanceTypeID != null;
    }

    @Override
    @Deprecated
    public A withNewInstanceTypeID(String arg0) {
        return this.withInstanceTypeID(new String(arg0));
    }

    @Override
    public Integer getMemoryMB() {
        return this.memoryMB;
    }

    @Override
    public A withMemoryMB(Integer memoryMB) {
        this.memoryMB = memoryMB;
        return (A)this;
    }

    @Override
    public Boolean hasMemoryMB() {
        return this.memoryMB != null;
    }

    @Override
    @Deprecated
    public Disk getOsDisk() {
        return this.osDisk != null ? this.osDisk.build() : null;
    }

    @Override
    public Disk buildOsDisk() {
        return this.osDisk != null ? this.osDisk.build() : null;
    }

    @Override
    public A withOsDisk(Disk osDisk) {
        this._visitables.get("osDisk").remove(this.osDisk);
        if (osDisk != null) {
            this.osDisk = new DiskBuilder(osDisk);
            this._visitables.get("osDisk").add(this.osDisk);
        }
        return (A)this;
    }

    @Override
    public Boolean hasOsDisk() {
        return this.osDisk != null;
    }

    @Override
    public A withNewOsDisk(Long sizeGB) {
        return this.withOsDisk(new Disk(sizeGB));
    }

    @Override
    public MachinePoolFluent.OsDiskNested<A> withNewOsDisk() {
        return new OsDiskNestedImpl();
    }

    @Override
    public MachinePoolFluent.OsDiskNested<A> withNewOsDiskLike(Disk item) {
        return new OsDiskNestedImpl(item);
    }

    @Override
    public MachinePoolFluent.OsDiskNested<A> editOsDisk() {
        return this.withNewOsDiskLike(this.getOsDisk());
    }

    @Override
    public MachinePoolFluent.OsDiskNested<A> editOrNewOsDisk() {
        return this.withNewOsDiskLike(this.getOsDisk() != null ? this.getOsDisk() : new DiskBuilder().build());
    }

    @Override
    public MachinePoolFluent.OsDiskNested<A> editOrNewOsDiskLike(Disk item) {
        return this.withNewOsDiskLike(this.getOsDisk() != null ? this.getOsDisk() : item);
    }

    @Override
    public String getVmType() {
        return this.vmType;
    }

    @Override
    public A withVmType(String vmType) {
        this.vmType = vmType;
        return (A)this;
    }

    @Override
    public Boolean hasVmType() {
        return this.vmType != null;
    }

    @Override
    @Deprecated
    public A withNewVmType(String arg0) {
        return this.withVmType(new String(arg0));
    }

    @Override
    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    @Override
    public Boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MachinePoolFluentImpl that = (MachinePoolFluentImpl)o;
        if (this.affinityGroupsNames != null ? !this.affinityGroupsNames.equals(that.affinityGroupsNames) : that.affinityGroupsNames != null) {
            return false;
        }
        if (this.autoPinningPolicy != null ? !this.autoPinningPolicy.equals(that.autoPinningPolicy) : that.autoPinningPolicy != null) {
            return false;
        }
        if (this.cpu != null ? !this.cpu.equals(that.cpu) : that.cpu != null) {
            return false;
        }
        if (this.hugepages != null ? !this.hugepages.equals(that.hugepages) : that.hugepages != null) {
            return false;
        }
        if (this.instanceTypeID != null ? !this.instanceTypeID.equals(that.instanceTypeID) : that.instanceTypeID != null) {
            return false;
        }
        if (this.memoryMB != null ? !this.memoryMB.equals(that.memoryMB) : that.memoryMB != null) {
            return false;
        }
        if (this.osDisk != null ? !this.osDisk.equals(that.osDisk) : that.osDisk != null) {
            return false;
        }
        if (this.vmType != null ? !this.vmType.equals(that.vmType) : that.vmType != null) {
            return false;
        }
        return !(this.additionalProperties != null ? !this.additionalProperties.equals(that.additionalProperties) : that.additionalProperties != null);
    }

    public int hashCode() {
        return Objects.hash(this.affinityGroupsNames, this.autoPinningPolicy, this.cpu, this.hugepages, this.instanceTypeID, this.memoryMB, this.osDisk, this.vmType, this.additionalProperties, super.hashCode());
    }

    public class OsDiskNestedImpl<N>
    extends DiskFluentImpl<MachinePoolFluent.OsDiskNested<N>>
    implements MachinePoolFluent.OsDiskNested<N>,
    Nested<N> {
        DiskBuilder builder;

        OsDiskNestedImpl(Disk item) {
            this.builder = new DiskBuilder(this, item);
        }

        OsDiskNestedImpl() {
            this.builder = new DiskBuilder(this);
        }

        @Override
        public N and() {
            return (N)MachinePoolFluentImpl.this.withOsDisk(this.builder.build());
        }

        @Override
        public N endOsDisk() {
            return this.and();
        }
    }

    public class CpuNestedImpl<N>
    extends CPUFluentImpl<MachinePoolFluent.CpuNested<N>>
    implements MachinePoolFluent.CpuNested<N>,
    Nested<N> {
        CPUBuilder builder;

        CpuNestedImpl(CPU item) {
            this.builder = new CPUBuilder(this, item);
        }

        CpuNestedImpl() {
            this.builder = new CPUBuilder(this);
        }

        @Override
        public N and() {
            return (N)MachinePoolFluentImpl.this.withCpu(this.builder.build());
        }

        @Override
        public N endCpu() {
            return this.and();
        }
    }
}

