/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.v5_12;

import io.fabric8.kubernetes.api.builder.v5_12.BaseFluent;
import io.fabric8.kubernetes.api.builder.v5_12.Nested;
import io.fabric8.openshift.api.model.v5_12.HubSource;
import io.fabric8.openshift.api.model.v5_12.HubSourceBuilder;
import io.fabric8.openshift.api.model.v5_12.HubSourceFluentImpl;
import io.fabric8.openshift.api.model.v5_12.OperatorHubSpec;
import io.fabric8.openshift.api.model.v5_12.OperatorHubSpecFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class OperatorHubSpecFluentImpl<A extends OperatorHubSpecFluent<A>>
extends BaseFluent<A>
implements OperatorHubSpecFluent<A> {
    private Boolean disableAllDefaultSources;
    private List<HubSourceBuilder> sources = new ArrayList<HubSourceBuilder>();
    private Map<String, Object> additionalProperties;

    public OperatorHubSpecFluentImpl() {
    }

    public OperatorHubSpecFluentImpl(OperatorHubSpec instance) {
        this.withDisableAllDefaultSources(instance.getDisableAllDefaultSources());
        this.withSources(instance.getSources());
        this.withAdditionalProperties(instance.getAdditionalProperties());
    }

    @Override
    public Boolean getDisableAllDefaultSources() {
        return this.disableAllDefaultSources;
    }

    @Override
    public A withDisableAllDefaultSources(Boolean disableAllDefaultSources) {
        this.disableAllDefaultSources = disableAllDefaultSources;
        return (A)this;
    }

    @Override
    public Boolean hasDisableAllDefaultSources() {
        return this.disableAllDefaultSources != null;
    }

    @Override
    public A addToSources(Integer index, HubSource item) {
        if (this.sources == null) {
            this.sources = new ArrayList<HubSourceBuilder>();
        }
        HubSourceBuilder builder = new HubSourceBuilder(item);
        this._visitables.get("sources").add(index >= 0 ? index.intValue() : this._visitables.get("sources").size(), builder);
        this.sources.add(index >= 0 ? index.intValue() : this.sources.size(), builder);
        return (A)this;
    }

    @Override
    public A setToSources(Integer index, HubSource item) {
        if (this.sources == null) {
            this.sources = new ArrayList<HubSourceBuilder>();
        }
        HubSourceBuilder builder = new HubSourceBuilder(item);
        if (index < 0 || index >= this._visitables.get("sources").size()) {
            this._visitables.get("sources").add(builder);
        } else {
            this._visitables.get("sources").set(index, builder);
        }
        if (index < 0 || index >= this.sources.size()) {
            this.sources.add(builder);
        } else {
            this.sources.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToSources(HubSource ... items) {
        if (this.sources == null) {
            this.sources = new ArrayList<HubSourceBuilder>();
        }
        for (HubSource item : items) {
            HubSourceBuilder builder = new HubSourceBuilder(item);
            this._visitables.get("sources").add(builder);
            this.sources.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToSources(Collection<HubSource> items) {
        if (this.sources == null) {
            this.sources = new ArrayList<HubSourceBuilder>();
        }
        for (HubSource item : items) {
            HubSourceBuilder builder = new HubSourceBuilder(item);
            this._visitables.get("sources").add(builder);
            this.sources.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromSources(HubSource ... items) {
        for (HubSource item : items) {
            HubSourceBuilder builder = new HubSourceBuilder(item);
            this._visitables.get("sources").remove(builder);
            if (this.sources == null) continue;
            this.sources.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromSources(Collection<HubSource> items) {
        for (HubSource item : items) {
            HubSourceBuilder builder = new HubSourceBuilder(item);
            this._visitables.get("sources").remove(builder);
            if (this.sources == null) continue;
            this.sources.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromSources(Predicate<HubSourceBuilder> predicate) {
        if (this.sources == null) {
            return (A)this;
        }
        Iterator<HubSourceBuilder> each = this.sources.iterator();
        Object visitables = this._visitables.get("sources");
        while (each.hasNext()) {
            HubSourceBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<HubSource> getSources() {
        return OperatorHubSpecFluentImpl.build(this.sources);
    }

    @Override
    public List<HubSource> buildSources() {
        return OperatorHubSpecFluentImpl.build(this.sources);
    }

    @Override
    public HubSource buildSource(Integer index) {
        return this.sources.get(index).build();
    }

    @Override
    public HubSource buildFirstSource() {
        return this.sources.get(0).build();
    }

    @Override
    public HubSource buildLastSource() {
        return this.sources.get(this.sources.size() - 1).build();
    }

    @Override
    public HubSource buildMatchingSource(Predicate<HubSourceBuilder> predicate) {
        for (HubSourceBuilder item : this.sources) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingSource(Predicate<HubSourceBuilder> predicate) {
        for (HubSourceBuilder item : this.sources) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withSources(List<HubSource> sources) {
        if (this.sources != null) {
            this._visitables.get("sources").removeAll(this.sources);
        }
        if (sources != null) {
            this.sources = new ArrayList<HubSourceBuilder>();
            for (HubSource item : sources) {
                this.addToSources(item);
            }
        } else {
            this.sources = null;
        }
        return (A)this;
    }

    @Override
    public A withSources(HubSource ... sources) {
        if (this.sources != null) {
            this.sources.clear();
        }
        if (sources != null) {
            for (HubSource item : sources) {
                this.addToSources(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasSources() {
        return this.sources != null && !this.sources.isEmpty();
    }

    @Override
    public A addNewSource(Boolean disabled, String name) {
        return this.addToSources(new HubSource(disabled, name));
    }

    @Override
    public OperatorHubSpecFluent.SourcesNested<A> addNewSource() {
        return new SourcesNestedImpl();
    }

    @Override
    public OperatorHubSpecFluent.SourcesNested<A> addNewSourceLike(HubSource item) {
        return new SourcesNestedImpl(-1, item);
    }

    @Override
    public OperatorHubSpecFluent.SourcesNested<A> setNewSourceLike(Integer index, HubSource item) {
        return new SourcesNestedImpl(index, item);
    }

    @Override
    public OperatorHubSpecFluent.SourcesNested<A> editSource(Integer index) {
        if (this.sources.size() <= index) {
            throw new RuntimeException("Can't edit sources. Index exceeds size.");
        }
        return this.setNewSourceLike(index, this.buildSource(index));
    }

    @Override
    public OperatorHubSpecFluent.SourcesNested<A> editFirstSource() {
        if (this.sources.size() == 0) {
            throw new RuntimeException("Can't edit first sources. The list is empty.");
        }
        return this.setNewSourceLike(0, this.buildSource(0));
    }

    @Override
    public OperatorHubSpecFluent.SourcesNested<A> editLastSource() {
        int index = this.sources.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last sources. The list is empty.");
        }
        return this.setNewSourceLike(index, this.buildSource(index));
    }

    @Override
    public OperatorHubSpecFluent.SourcesNested<A> editMatchingSource(Predicate<HubSourceBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.sources.size(); ++i) {
            if (!predicate.test(this.sources.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching sources. No match found.");
        }
        return this.setNewSourceLike(index, this.buildSource(index));
    }

    @Override
    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    @Override
    public Boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OperatorHubSpecFluentImpl that = (OperatorHubSpecFluentImpl)o;
        if (this.disableAllDefaultSources != null ? !this.disableAllDefaultSources.equals(that.disableAllDefaultSources) : that.disableAllDefaultSources != null) {
            return false;
        }
        if (this.sources != null ? !this.sources.equals(that.sources) : that.sources != null) {
            return false;
        }
        return !(this.additionalProperties != null ? !this.additionalProperties.equals(that.additionalProperties) : that.additionalProperties != null);
    }

    public int hashCode() {
        return Objects.hash(this.disableAllDefaultSources, this.sources, this.additionalProperties, super.hashCode());
    }

    public class SourcesNestedImpl<N>
    extends HubSourceFluentImpl<OperatorHubSpecFluent.SourcesNested<N>>
    implements OperatorHubSpecFluent.SourcesNested<N>,
    Nested<N> {
        HubSourceBuilder builder;
        Integer index;

        SourcesNestedImpl(Integer index, HubSource item) {
            this.index = index;
            this.builder = new HubSourceBuilder(this, item);
        }

        SourcesNestedImpl() {
            this.index = -1;
            this.builder = new HubSourceBuilder(this);
        }

        @Override
        public N and() {
            return (N)OperatorHubSpecFluentImpl.this.setToSources(this.index, this.builder.build());
        }

        @Override
        public N endSource() {
            return this.and();
        }
    }
}

