/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.clnt.v5_12.utils;

import io.fabric8.kubernetes.clnt.v5_12.Config;
import io.fabric8.kubernetes.clnt.v5_12.http.BasicBuilder;
import io.fabric8.kubernetes.clnt.v5_12.http.HttpClient;
import io.fabric8.kubernetes.clnt.v5_12.http.HttpResponse;
import io.fabric8.kubernetes.clnt.v5_12.http.Interceptor;
import io.fabric8.kubernetes.clnt.v5_12.utils.OpenIDConnectionUtils;

public class TokenRefreshInterceptor
implements Interceptor {
    public static final String NAME = "TOKEN";
    private final Config config;
    private HttpClient.Factory factory;

    public TokenRefreshInterceptor(Config config, HttpClient.Factory factory) {
        this.config = config;
        this.factory = factory;
    }

    @Override
    public boolean afterFailure(BasicBuilder headerBuilder, HttpResponse<?> response) {
        boolean resubmit = false;
        if (response.code() == 401) {
            Config newestConfig;
            String currentContextName = null;
            String newAccessToken = null;
            if (this.config.getCurrentContext() != null) {
                currentContextName = this.config.getCurrentContext().getName();
            }
            if ((newAccessToken = (newestConfig = Config.autoConfigure(currentContextName)).getAuthProvider() != null && newestConfig.getAuthProvider().getName().equalsIgnoreCase("oidc") ? OpenIDConnectionUtils.resolveOIDCTokenFromAuthConfig(newestConfig.getAuthProvider().getConfig(), this.factory.newBuilder()) : newestConfig.getOauthToken()) != null) {
                headerBuilder.setHeader("Authorization", "Bearer " + newAccessToken);
                this.config.setOauthToken(newAccessToken);
                resubmit = true;
            }
        }
        return resubmit;
    }
}

