/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.clnt.v5_12.informers.cache;

import io.fabric8.kubernetes.api.model.v5_12.HasMetadata;
import io.fabric8.kubernetes.clnt.v5_12.informers.cache.Cache;
import io.fabric8.kubernetes.clnt.v5_12.informers.cache.ProcessorListener;
import io.fabric8.kubernetes.clnt.v5_12.informers.cache.SharedProcessor;
import io.fabric8.kubernetes.clnt.v5_12.informers.cache.SyncableStore;
import java.util.List;
import java.util.Objects;
import java.util.Set;

public class ProcessorStore<T extends HasMetadata>
implements SyncableStore<T> {
    private Cache<T> cache;
    private SharedProcessor<T> processor;

    public ProcessorStore(Cache<T> cache, SharedProcessor<T> processor) {
        this.cache = cache;
        this.processor = processor;
    }

    @Override
    public void add(T obj) {
        this.update(obj);
    }

    @Override
    public void update(T obj) {
        HasMetadata oldObj = (HasMetadata)this.cache.put(obj);
        if (oldObj != null) {
            this.processor.distribute(new ProcessorListener.UpdateNotification<HasMetadata>(oldObj, (HasMetadata)obj), Objects.equals(oldObj.getMetadata().getResourceVersion(), obj.getMetadata().getResourceVersion()));
        } else {
            this.processor.distribute(new ProcessorListener.AddNotification<T>(obj), false);
        }
    }

    @Override
    public void delete(T obj) {
        T oldObj = this.cache.remove(obj);
        if (oldObj != null) {
            this.processor.distribute(new ProcessorListener.DeleteNotification<T>(obj, false), false);
        }
    }

    @Override
    public List<T> list() {
        return this.cache.list();
    }

    @Override
    public List<String> listKeys() {
        return this.cache.listKeys();
    }

    @Override
    public T get(T object) {
        return (T)((HasMetadata)this.cache.get(object));
    }

    @Override
    public T getByKey(String key) {
        return (T)((HasMetadata)this.cache.getByKey(key));
    }

    @Override
    public void retainAll(Set<String> nextKeys) {
        List<HasMetadata> current = this.cache.list();
        if (nextKeys.isEmpty() && current.isEmpty()) {
            this.processor.distribute(l -> l.getHandler().onNothing(), false);
            return;
        }
        current.forEach(v -> {
            String key = this.cache.getKey((HasMetadata)v);
            if (!nextKeys.contains(key)) {
                this.cache.remove((HasMetadata)v);
                this.processor.distribute(new ProcessorListener.DeleteNotification<HasMetadata>((HasMetadata)v, true), false);
            }
        });
    }

    @Override
    public String getKey(T obj) {
        return this.cache.getKey(obj);
    }

    @Override
    public void resync() {
        this.cache.list().forEach(i -> this.processor.distribute(new ProcessorListener.UpdateNotification<HasMetadata>((HasMetadata)i, (HasMetadata)i), true));
    }
}

