/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.clnt.v5_12.extended.leaderelection;

import io.fabric8.kubernetes.api.builder.v5_12.VisitableBuilder;
import io.fabric8.kubernetes.clnt.v5_12.extended.leaderelection.LeaderElectionConfig;
import io.fabric8.kubernetes.clnt.v5_12.extended.leaderelection.LeaderElectionConfigFluent;
import io.fabric8.kubernetes.clnt.v5_12.extended.leaderelection.LeaderElectionConfigFluentImpl;
import java.util.Objects;

public class LeaderElectionConfigBuilder
extends LeaderElectionConfigFluentImpl<LeaderElectionConfigBuilder>
implements VisitableBuilder<LeaderElectionConfig, LeaderElectionConfigBuilder> {
    LeaderElectionConfigFluent<?> fluent;
    Boolean validationEnabled;

    public LeaderElectionConfigBuilder() {
        this(false);
    }

    public LeaderElectionConfigBuilder(Boolean validationEnabled) {
        this.fluent = this;
        this.validationEnabled = validationEnabled;
    }

    public LeaderElectionConfigBuilder(LeaderElectionConfigFluent<?> fluent) {
        this(fluent, (Boolean)false);
    }

    public LeaderElectionConfigBuilder(LeaderElectionConfigFluent<?> fluent, Boolean validationEnabled) {
        this.fluent = fluent;
        this.validationEnabled = validationEnabled;
    }

    public LeaderElectionConfigBuilder(LeaderElectionConfigFluent<?> fluent, LeaderElectionConfig instance) {
        this(fluent, instance, false);
    }

    public LeaderElectionConfigBuilder(LeaderElectionConfigFluent<?> fluent, LeaderElectionConfig instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withLock(instance.getLock());
        fluent.withLeaseDuration(instance.getLeaseDuration());
        fluent.withRenewDeadline(instance.getRenewDeadline());
        fluent.withRetryPeriod(instance.getRetryPeriod());
        fluent.withLeaderCallbacks(instance.getLeaderCallbacks());
        fluent.withReleaseOnCancel(instance.isReleaseOnCancel());
        fluent.withName(instance.getName());
        this.validationEnabled = validationEnabled;
    }

    public LeaderElectionConfigBuilder(LeaderElectionConfig instance) {
        this(instance, (Boolean)false);
    }

    public LeaderElectionConfigBuilder(LeaderElectionConfig instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withLock(instance.getLock());
        this.withLeaseDuration(instance.getLeaseDuration());
        this.withRenewDeadline(instance.getRenewDeadline());
        this.withRetryPeriod(instance.getRetryPeriod());
        this.withLeaderCallbacks(instance.getLeaderCallbacks());
        this.withReleaseOnCancel(instance.isReleaseOnCancel());
        this.withName(instance.getName());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public LeaderElectionConfig build() {
        LeaderElectionConfig buildable = new LeaderElectionConfig(this.fluent.getLock(), this.fluent.getLeaseDuration(), this.fluent.getRenewDeadline(), this.fluent.getRetryPeriod(), this.fluent.getLeaderCallbacks(), this.fluent.isReleaseOnCancel(), this.fluent.getName());
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        LeaderElectionConfigBuilder that = (LeaderElectionConfigBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.fluent, this.validationEnabled, super.hashCode());
    }
}

