/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.clnt.v5_12.dsl.internal.extensions.v1beta1;

import io.fabric8.kubernetes.api.model.v5_12.Container;
import io.fabric8.kubernetes.api.model.v5_12.OwnerReference;
import io.fabric8.kubernetes.api.model.v5_12.Status;
import io.fabric8.kubernetes.api.model.v5_12.extensions.Deployment;
import io.fabric8.kubernetes.api.model.v5_12.extensions.DeploymentList;
import io.fabric8.kubernetes.api.model.v5_12.extensions.DeploymentRollback;
import io.fabric8.kubernetes.api.model.v5_12.extensions.ReplicaSet;
import io.fabric8.kubernetes.api.model.v5_12.extensions.ReplicaSetList;
import io.fabric8.kubernetes.clnt.v5_12.ClientContext;
import io.fabric8.kubernetes.clnt.v5_12.KubernetesClientException;
import io.fabric8.kubernetes.clnt.v5_12.KubernetesClientTimeoutException;
import io.fabric8.kubernetes.clnt.v5_12.dsl.LogWatch;
import io.fabric8.kubernetes.clnt.v5_12.dsl.RollableScalableResource;
import io.fabric8.kubernetes.clnt.v5_12.dsl.TimeoutImageEditReplacePatchable;
import io.fabric8.kubernetes.clnt.v5_12.dsl.base.OperationContext;
import io.fabric8.kubernetes.clnt.v5_12.dsl.base.PatchContext;
import io.fabric8.kubernetes.clnt.v5_12.dsl.internal.HasMetadataOperationsImpl;
import io.fabric8.kubernetes.clnt.v5_12.dsl.internal.RollingOperationContext;
import io.fabric8.kubernetes.clnt.v5_12.dsl.internal.apps.v1.RollableScalableResourceOperation;
import io.fabric8.kubernetes.clnt.v5_12.dsl.internal.apps.v1.RollingUpdater;
import io.fabric8.kubernetes.clnt.v5_12.dsl.internal.extensions.v1beta1.DeploymentRollingUpdater;
import io.fabric8.kubernetes.clnt.v5_12.dsl.internal.extensions.v1beta1.ReplicaSetOperationsImpl;
import io.fabric8.kubernetes.clnt.v5_12.utils.KubernetesResourceUtil;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.UnaryOperator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeploymentOperationsImpl
extends RollableScalableResourceOperation<Deployment, DeploymentList, RollableScalableResource<Deployment>>
implements TimeoutImageEditReplacePatchable<Deployment> {
    static final transient Logger LOG = LoggerFactory.getLogger(DeploymentOperationsImpl.class);
    public static final String DEPLOYMENT_KUBERNETES_IO_REVISION = "deployment.kubernetes.io/revision";

    public DeploymentOperationsImpl(ClientContext clientContext) {
        this(new RollingOperationContext(), HasMetadataOperationsImpl.defaultContext(clientContext));
    }

    public DeploymentOperationsImpl(RollingOperationContext context, OperationContext superContext) {
        super(context, superContext.withApiGroupName("extensions").withApiGroupVersion("v1beta1").withPlural("deployments"), Deployment.class, DeploymentList.class);
    }

    public DeploymentOperationsImpl newInstance(OperationContext context) {
        return new DeploymentOperationsImpl(this.rollingOperationContext, context);
    }

    public DeploymentOperationsImpl newInstance(RollingOperationContext context) {
        return new DeploymentOperationsImpl(context, this.context);
    }

    @Override
    public Deployment scale(int count, boolean wait) {
        Deployment res = this.cascading(false).accept((T d) -> d.getSpec().setReplicas(count));
        if (wait) {
            this.waitUntilDeploymentIsScaled(count);
            res = (Deployment)this.getMandatory();
        }
        return res;
    }

    @Override
    public Deployment edit(UnaryOperator<Deployment> function) {
        if (this.isCascading().booleanValue()) {
            return this.cascading(false).edit(function);
        }
        return (Deployment)super.edit((UnaryOperator)function);
    }

    @Override
    public Deployment accept(Consumer<Deployment> consumer) {
        if (this.isCascading().booleanValue()) {
            return this.cascading(false).accept(consumer);
        }
        return (Deployment)super.accept((Consumer)consumer);
    }

    @Override
    public Deployment replace(Deployment item) {
        if (this.isCascading().booleanValue()) {
            return this.cascading(false).replace(item);
        }
        return super.replace(item);
    }

    @Override
    public Deployment patch(PatchContext patchContext, Deployment item) {
        if (this.isCascading().booleanValue()) {
            return this.cascading(false).patch(patchContext, item);
        }
        return super.patch(patchContext, item);
    }

    @Override
    public Status rollback(DeploymentRollback rollback) {
        return this.handleDeploymentRollback(rollback);
    }

    @Override
    public RollingUpdater<Deployment, DeploymentList> getRollingUpdater(long rollingTimeout, TimeUnit rollingTimeUnit) {
        return new DeploymentRollingUpdater(this.context, this.getNamespace(), rollingTimeUnit.toMillis(rollingTimeout), this.config.getLoggingInterval());
    }

    @Override
    public Deployment withReplicas(int count) {
        return this.cascading(false).accept((T d) -> d.getSpec().setReplicas(count));
    }

    @Override
    public int getCurrentReplicas(Deployment current) {
        return current.getStatus().getReplicas();
    }

    @Override
    public int getDesiredReplicas(Deployment item) {
        return item.getSpec().getReplicas();
    }

    @Override
    public long getObservedGeneration(Deployment current) {
        return current != null && current.getStatus() != null && current.getStatus().getObservedGeneration() != null ? current.getStatus().getObservedGeneration() : -1L;
    }

    @Override
    public Deployment updateImage(String image) {
        Deployment oldRC = (Deployment)this.get();
        if (oldRC == null) {
            throw new KubernetesClientException("Existing replica set doesn't exist");
        }
        if (oldRC.getSpec().getTemplate().getSpec().getContainers().size() > 1) {
            throw new KubernetesClientException("updateImage(image) does not supported for multicontainer pods, use updateImage(Map<String, String>) instead");
        }
        if (oldRC.getSpec().getTemplate().getSpec().getContainers().isEmpty()) {
            throw new KubernetesClientException("Pod has no containers!");
        }
        Container container = oldRC.getSpec().getTemplate().getSpec().getContainers().iterator().next();
        return this.updateImage((Map)Collections.singletonMap(container.getName(), image));
    }

    @Override
    public Deployment updateImage(Map<String, String> containerToImageMap) {
        Deployment deployment = (Deployment)this.get();
        if (deployment == null) {
            throw new KubernetesClientException("Existing replica set doesn't exist");
        }
        if (deployment.getSpec().getTemplate().getSpec().getContainers().isEmpty()) {
            throw new KubernetesClientException("Pod has no containers!");
        }
        List<Container> containers = deployment.getSpec().getTemplate().getSpec().getContainers();
        for (Container container : containers) {
            if (!containerToImageMap.containsKey(container.getName())) continue;
            container.setImage(containerToImageMap.get(container.getName()));
        }
        deployment.getSpec().getTemplate().getSpec().setContainers(containers);
        return this.sendPatchedObject(this.get(), deployment);
    }

    @Override
    public Deployment resume() {
        return this.sendPatchedDeployment(RollingUpdater.requestPayLoadForRolloutResume());
    }

    @Override
    public Deployment pause() {
        return this.sendPatchedDeployment(RollingUpdater.requestPayLoadForRolloutPause());
    }

    @Override
    public Deployment restart() {
        return this.sendPatchedDeployment(RollingUpdater.requestPayLoadForRolloutRestart());
    }

    @Override
    public Deployment undo() {
        List<ReplicaSet> replicaSets = this.getReplicaSetListForDeployment((Deployment)this.get()).getItems();
        replicaSets.sort((o1, o2) -> {
            String revisionO1 = o1.getMetadata().getAnnotations().get(DEPLOYMENT_KUBERNETES_IO_REVISION);
            String revisionO2 = o2.getMetadata().getAnnotations().get(DEPLOYMENT_KUBERNETES_IO_REVISION);
            return Integer.parseInt(revisionO2) - Integer.parseInt(revisionO1);
        });
        ReplicaSet latestReplicaSet = replicaSets.get(0);
        ReplicaSet previousRevisionReplicaSet = replicaSets.get(1);
        Deployment deployment = (Deployment)this.get();
        deployment.getMetadata().getAnnotations().put(DEPLOYMENT_KUBERNETES_IO_REVISION, latestReplicaSet.getMetadata().getAnnotations().get(DEPLOYMENT_KUBERNETES_IO_REVISION));
        deployment.getSpec().setTemplate(previousRevisionReplicaSet.getSpec().getTemplate());
        return this.sendPatchedObject(this.get(), deployment);
    }

    private void waitUntilDeploymentIsScaled(int count) {
        AtomicReference<Integer> replicasRef = new AtomicReference<Integer>(0);
        String name = this.checkName(this.getItem());
        String namespace = this.checkNamespace(this.getItem());
        try {
            this.waitUntilCondition(deployment -> {
                long observedGeneration;
                if (deployment == null) {
                    if (count == 0) {
                        return true;
                    }
                    throw new IllegalStateException("Can't wait for Deployment: " + this.checkName(this.getItem()) + " in namespace: " + this.checkName(this.getItem()) + " to scale. Resource is no longer available.");
                }
                replicasRef.set(deployment.getStatus().getReplicas());
                int currentReplicas = deployment.getStatus().getReplicas() != null ? deployment.getStatus().getReplicas() : 0;
                long generation = deployment.getMetadata().getGeneration() != null ? deployment.getMetadata().getGeneration() : 0L;
                long l = observedGeneration = deployment.getStatus() != null && deployment.getStatus().getObservedGeneration() != null ? deployment.getStatus().getObservedGeneration() : -1L;
                if (observedGeneration >= generation && Objects.equals(deployment.getSpec().getReplicas(), currentReplicas)) {
                    return true;
                }
                LOG.debug("Only {}/{} pods scheduled for Deployment: {} in namespace: {} seconds so waiting...", new Object[]{deployment.getStatus().getReplicas(), deployment.getSpec().getReplicas(), deployment.getMetadata().getName(), namespace});
                return false;
            }, this.getConfig().getScaleTimeout(), TimeUnit.MILLISECONDS);
            LOG.debug("{}/{} pod(s) ready for Deployment: {} in namespace: {}.", new Object[]{replicasRef.get(), count, name, namespace});
        }
        catch (KubernetesClientTimeoutException e) {
            LOG.error("{}/{} pod(s) ready for Deployment: {} in namespace: {}  after waiting for {} seconds so giving up", new Object[]{replicasRef.get(), count, name, namespace, TimeUnit.MILLISECONDS.toSeconds(this.getConfig().getScaleTimeout())});
        }
    }

    @Override
    public String getLog(Boolean isPretty) {
        StringBuilder stringBuilder = new StringBuilder();
        List<RollableScalableResource<ReplicaSet>> rcList = this.doGetLog();
        for (RollableScalableResource<ReplicaSet> rcOperation : rcList) {
            stringBuilder.append(rcOperation.getLog(isPretty));
        }
        return stringBuilder.toString();
    }

    private List<RollableScalableResource<ReplicaSet>> doGetLog() {
        ArrayList<RollableScalableResource<ReplicaSet>> rcs = new ArrayList<RollableScalableResource<ReplicaSet>>();
        Deployment deployment = (Deployment)this.requireFromServer();
        String rcUid = deployment.getMetadata().getUid();
        ReplicaSetOperationsImpl rsOperations = new ReplicaSetOperationsImpl(new RollingOperationContext(this.rollingOperationContext.getContainerId(), false, 0L, null, this.rollingOperationContext.getLogWaitTimeout()), this.context.withName(null));
        ReplicaSetList rcList = (ReplicaSetList)rsOperations.withLabels((Map)DeploymentOperationsImpl.getDeploymentSelectorLabels(deployment)).list();
        for (ReplicaSet rs : rcList.getItems()) {
            OwnerReference ownerReference = KubernetesResourceUtil.getControllerUid(rs);
            if (ownerReference == null || !ownerReference.getUid().equals(rcUid)) continue;
            rcs.add((RollableScalableResource<ReplicaSet>)rsOperations.withName(rs.getMetadata().getName()));
        }
        return rcs;
    }

    @Override
    public Reader getLogReader() {
        List<RollableScalableResource<ReplicaSet>> podResources = this.doGetLog();
        if (!podResources.isEmpty()) {
            if (podResources.size() > 1) {
                LOG.debug("Found {} pods, Using first one to get log reader", (Object)podResources.size());
            }
            return podResources.get(0).getLogReader();
        }
        return null;
    }

    @Override
    public LogWatch watchLog(OutputStream out) {
        List<RollableScalableResource<ReplicaSet>> replicaSetResources = this.doGetLog();
        if (!replicaSetResources.isEmpty()) {
            if (replicaSetResources.size() > 1) {
                LOG.debug("Found {} pods, Using first one to get logs", (Object)replicaSetResources.size());
            }
            return (LogWatch)replicaSetResources.get(0).watchLog(out);
        }
        return null;
    }

    private Deployment sendPatchedDeployment(Map<String, Object> patchedUpdate) {
        Deployment oldDeployment = (Deployment)this.get();
        try {
            return this.handlePatch(oldDeployment, patchedUpdate);
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
            throw KubernetesClientException.launderThrowable(interruptedException);
        }
        catch (IOException e) {
            throw KubernetesClientException.launderThrowable(e);
        }
    }

    private ReplicaSetList getReplicaSetListForDeployment(Deployment deployment) {
        return (ReplicaSetList)new ReplicaSetOperationsImpl(this.context, this.getNamespace()).withLabels((Map)deployment.getSpec().getSelector().getMatchLabels()).list();
    }

    static Map<String, String> getDeploymentSelectorLabels(Deployment deployment) {
        HashMap<String, String> labels = new HashMap<String, String>();
        if (deployment != null && deployment.getSpec() != null && deployment.getSpec().getTemplate() != null && deployment.getSpec().getTemplate().getMetadata() != null) {
            labels.putAll(deployment.getSpec().getTemplate().getMetadata().getLabels());
        }
        return labels;
    }
}

