/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.clnt.v5_12;

import io.fabric8.kubernetes.api.builder.v5_12.VisitableBuilder;
import io.fabric8.kubernetes.clnt.v5_12.Config;
import io.fabric8.kubernetes.clnt.v5_12.ConfigFluent;
import io.fabric8.kubernetes.clnt.v5_12.ConfigFluentImpl;
import java.util.Objects;

public class ConfigBuilder
extends ConfigFluentImpl<ConfigBuilder>
implements VisitableBuilder<Config, ConfigBuilder> {
    ConfigFluent<?> fluent;
    Boolean validationEnabled;

    public ConfigBuilder() {
        this(false);
    }

    public ConfigBuilder(Boolean validationEnabled) {
        this(new Config(), validationEnabled);
    }

    public ConfigBuilder(ConfigFluent<?> fluent) {
        this(fluent, (Boolean)false);
    }

    public ConfigBuilder(ConfigFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new Config(), validationEnabled);
    }

    public ConfigBuilder(ConfigFluent<?> fluent, Config instance) {
        this(fluent, instance, false);
    }

    public ConfigBuilder(ConfigFluent<?> fluent, Config instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withMasterUrl(instance.getMasterUrl());
        fluent.withApiVersion(instance.getApiVersion());
        fluent.withNamespace(instance.getNamespace());
        fluent.withTrustCerts(instance.isTrustCerts());
        fluent.withDisableHostnameVerification(instance.isDisableHostnameVerification());
        fluent.withCaCertFile(instance.getCaCertFile());
        fluent.withCaCertData(instance.getCaCertData());
        fluent.withClientCertFile(instance.getClientCertFile());
        fluent.withClientCertData(instance.getClientCertData());
        fluent.withClientKeyFile(instance.getClientKeyFile());
        fluent.withClientKeyData(instance.getClientKeyData());
        fluent.withClientKeyAlgo(instance.getClientKeyAlgo());
        fluent.withClientKeyPassphrase(instance.getClientKeyPassphrase());
        fluent.withUsername(instance.getUsername());
        fluent.withPassword(instance.getPassword());
        fluent.withOauthToken(instance.getOauthToken());
        fluent.withWatchReconnectInterval(instance.getWatchReconnectInterval());
        fluent.withWatchReconnectLimit(instance.getWatchReconnectLimit());
        fluent.withConnectionTimeout(instance.getConnectionTimeout());
        fluent.withRequestTimeout(instance.getRequestTimeout());
        fluent.withRollingTimeout(instance.getRollingTimeout());
        fluent.withScaleTimeout(instance.getScaleTimeout());
        fluent.withLoggingInterval(instance.getLoggingInterval());
        fluent.withMaxConcurrentRequests(instance.getMaxConcurrentRequests());
        fluent.withMaxConcurrentRequestsPerHost(instance.getMaxConcurrentRequestsPerHost());
        fluent.withHttp2Disable(instance.isHttp2Disable());
        fluent.withHttpProxy(instance.getHttpProxy());
        fluent.withHttpsProxy(instance.getHttpsProxy());
        fluent.withNoProxy(instance.getNoProxy());
        fluent.withErrorMessages(instance.getErrorMessages());
        fluent.withUserAgent(instance.getUserAgent());
        fluent.withTlsVersions(instance.getTlsVersions());
        fluent.withWebsocketTimeout(instance.getWebsocketTimeout());
        fluent.withWebsocketPingInterval(instance.getWebsocketPingInterval());
        fluent.withProxyUsername(instance.getProxyUsername());
        fluent.withProxyPassword(instance.getProxyPassword());
        fluent.withTrustStoreFile(instance.getTrustStoreFile());
        fluent.withTrustStorePassphrase(instance.getTrustStorePassphrase());
        fluent.withKeyStoreFile(instance.getKeyStoreFile());
        fluent.withKeyStorePassphrase(instance.getKeyStorePassphrase());
        fluent.withImpersonateUsername(instance.getImpersonateUsername());
        fluent.withImpersonateGroups(instance.getImpersonateGroups());
        fluent.withImpersonateExtras(instance.getImpersonateExtras());
        fluent.withOauthTokenProvider(instance.getOauthTokenProvider());
        fluent.withCustomHeaders(instance.getCustomHeaders());
        fluent.withRequestRetryBackoffLimit(instance.getRequestRetryBackoffLimit());
        fluent.withRequestRetryBackoffInterval(instance.getRequestRetryBackoffInterval());
        fluent.withUploadConnectionTimeout(instance.getUploadConnectionTimeout());
        fluent.withUploadRequestTimeout(instance.getUploadRequestTimeout());
        fluent.withAuthProvider(instance.getAuthProvider());
        fluent.withContexts(instance.getContexts());
        fluent.withCurrentContext(instance.getCurrentContext());
        fluent.withImpersonateGroup(instance.getImpersonateGroup());
        this.validationEnabled = validationEnabled;
    }

    public ConfigBuilder(Config instance) {
        this(instance, (Boolean)false);
    }

    public ConfigBuilder(Config instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withMasterUrl(instance.getMasterUrl());
        this.withApiVersion(instance.getApiVersion());
        this.withNamespace(instance.getNamespace());
        this.withTrustCerts(instance.isTrustCerts());
        this.withDisableHostnameVerification(instance.isDisableHostnameVerification());
        this.withCaCertFile(instance.getCaCertFile());
        this.withCaCertData(instance.getCaCertData());
        this.withClientCertFile(instance.getClientCertFile());
        this.withClientCertData(instance.getClientCertData());
        this.withClientKeyFile(instance.getClientKeyFile());
        this.withClientKeyData(instance.getClientKeyData());
        this.withClientKeyAlgo(instance.getClientKeyAlgo());
        this.withClientKeyPassphrase(instance.getClientKeyPassphrase());
        this.withUsername(instance.getUsername());
        this.withPassword(instance.getPassword());
        this.withOauthToken(instance.getOauthToken());
        this.withWatchReconnectInterval(instance.getWatchReconnectInterval());
        this.withWatchReconnectLimit(instance.getWatchReconnectLimit());
        this.withConnectionTimeout(instance.getConnectionTimeout());
        this.withRequestTimeout(instance.getRequestTimeout());
        this.withRollingTimeout(instance.getRollingTimeout());
        this.withScaleTimeout(instance.getScaleTimeout());
        this.withLoggingInterval(instance.getLoggingInterval());
        this.withMaxConcurrentRequests(instance.getMaxConcurrentRequests());
        this.withMaxConcurrentRequestsPerHost(instance.getMaxConcurrentRequestsPerHost());
        this.withHttp2Disable(instance.isHttp2Disable());
        this.withHttpProxy(instance.getHttpProxy());
        this.withHttpsProxy(instance.getHttpsProxy());
        this.withNoProxy(instance.getNoProxy());
        this.withErrorMessages(instance.getErrorMessages());
        this.withUserAgent(instance.getUserAgent());
        this.withTlsVersions(instance.getTlsVersions());
        this.withWebsocketTimeout(instance.getWebsocketTimeout());
        this.withWebsocketPingInterval(instance.getWebsocketPingInterval());
        this.withProxyUsername(instance.getProxyUsername());
        this.withProxyPassword(instance.getProxyPassword());
        this.withTrustStoreFile(instance.getTrustStoreFile());
        this.withTrustStorePassphrase(instance.getTrustStorePassphrase());
        this.withKeyStoreFile(instance.getKeyStoreFile());
        this.withKeyStorePassphrase(instance.getKeyStorePassphrase());
        this.withImpersonateUsername(instance.getImpersonateUsername());
        this.withImpersonateGroups(instance.getImpersonateGroups());
        this.withImpersonateExtras(instance.getImpersonateExtras());
        this.withOauthTokenProvider(instance.getOauthTokenProvider());
        this.withCustomHeaders(instance.getCustomHeaders());
        this.withRequestRetryBackoffLimit(instance.getRequestRetryBackoffLimit());
        this.withRequestRetryBackoffInterval(instance.getRequestRetryBackoffInterval());
        this.withUploadConnectionTimeout(instance.getUploadConnectionTimeout());
        this.withUploadRequestTimeout(instance.getUploadRequestTimeout());
        this.withAuthProvider(instance.getAuthProvider());
        this.withContexts(instance.getContexts());
        this.withCurrentContext(instance.getCurrentContext());
        this.withImpersonateGroup(instance.getImpersonateGroup());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public Config build() {
        Config buildable = new Config(this.fluent.getMasterUrl(), this.fluent.getApiVersion(), this.fluent.getNamespace(), this.fluent.isTrustCerts(), this.fluent.isDisableHostnameVerification(), this.fluent.getCaCertFile(), this.fluent.getCaCertData(), this.fluent.getClientCertFile(), this.fluent.getClientCertData(), this.fluent.getClientKeyFile(), this.fluent.getClientKeyData(), this.fluent.getClientKeyAlgo(), this.fluent.getClientKeyPassphrase(), this.fluent.getUsername(), this.fluent.getPassword(), this.fluent.getOauthToken(), this.fluent.getWatchReconnectInterval(), this.fluent.getWatchReconnectLimit(), this.fluent.getConnectionTimeout(), this.fluent.getRequestTimeout(), this.fluent.getRollingTimeout(), this.fluent.getScaleTimeout(), this.fluent.getLoggingInterval(), this.fluent.getMaxConcurrentRequests(), this.fluent.getMaxConcurrentRequestsPerHost(), this.fluent.isHttp2Disable(), this.fluent.getHttpProxy(), this.fluent.getHttpsProxy(), this.fluent.getNoProxy(), this.fluent.getErrorMessages(), this.fluent.getUserAgent(), this.fluent.getTlsVersions(), this.fluent.getWebsocketTimeout(), this.fluent.getWebsocketPingInterval(), this.fluent.getProxyUsername(), this.fluent.getProxyPassword(), this.fluent.getTrustStoreFile(), this.fluent.getTrustStorePassphrase(), this.fluent.getKeyStoreFile(), this.fluent.getKeyStorePassphrase(), this.fluent.getImpersonateUsername(), this.fluent.getImpersonateGroups(), this.fluent.getImpersonateExtras(), this.fluent.getOauthTokenProvider(), this.fluent.getCustomHeaders(), this.fluent.getRequestRetryBackoffLimit(), this.fluent.getRequestRetryBackoffInterval(), this.fluent.getUploadConnectionTimeout(), this.fluent.getUploadRequestTimeout());
        buildable.setAuthProvider(this.fluent.getAuthProvider());
        buildable.setContexts(this.fluent.getContexts());
        buildable.setCurrentContext(this.fluent.getCurrentContext());
        buildable.setImpersonateGroup(this.fluent.getImpersonateGroup());
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ConfigBuilder that = (ConfigBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.fluent, this.validationEnabled, super.hashCode());
    }
}

