/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v5_12.autoscaling.v1;

import io.fabric8.kubernetes.api.builder.v5_12.VisitableBuilder;
import io.fabric8.kubernetes.api.model.v5_12.autoscaling.v1.HorizontalPodAutoscalerStatus;
import io.fabric8.kubernetes.api.model.v5_12.autoscaling.v1.HorizontalPodAutoscalerStatusFluent;
import io.fabric8.kubernetes.api.model.v5_12.autoscaling.v1.HorizontalPodAutoscalerStatusFluentImpl;
import java.util.Objects;

public class HorizontalPodAutoscalerStatusBuilder
extends HorizontalPodAutoscalerStatusFluentImpl<HorizontalPodAutoscalerStatusBuilder>
implements VisitableBuilder<HorizontalPodAutoscalerStatus, HorizontalPodAutoscalerStatusBuilder> {
    HorizontalPodAutoscalerStatusFluent<?> fluent;
    Boolean validationEnabled;

    public HorizontalPodAutoscalerStatusBuilder() {
        this(false);
    }

    public HorizontalPodAutoscalerStatusBuilder(Boolean validationEnabled) {
        this(new HorizontalPodAutoscalerStatus(), validationEnabled);
    }

    public HorizontalPodAutoscalerStatusBuilder(HorizontalPodAutoscalerStatusFluent<?> fluent) {
        this(fluent, (Boolean)false);
    }

    public HorizontalPodAutoscalerStatusBuilder(HorizontalPodAutoscalerStatusFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new HorizontalPodAutoscalerStatus(), validationEnabled);
    }

    public HorizontalPodAutoscalerStatusBuilder(HorizontalPodAutoscalerStatusFluent<?> fluent, HorizontalPodAutoscalerStatus instance) {
        this(fluent, instance, false);
    }

    public HorizontalPodAutoscalerStatusBuilder(HorizontalPodAutoscalerStatusFluent<?> fluent, HorizontalPodAutoscalerStatus instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withCurrentCPUUtilizationPercentage(instance.getCurrentCPUUtilizationPercentage());
        fluent.withCurrentReplicas(instance.getCurrentReplicas());
        fluent.withDesiredReplicas(instance.getDesiredReplicas());
        fluent.withLastScaleTime(instance.getLastScaleTime());
        fluent.withObservedGeneration(instance.getObservedGeneration());
        fluent.withAdditionalProperties(instance.getAdditionalProperties());
        this.validationEnabled = validationEnabled;
    }

    public HorizontalPodAutoscalerStatusBuilder(HorizontalPodAutoscalerStatus instance) {
        this(instance, (Boolean)false);
    }

    public HorizontalPodAutoscalerStatusBuilder(HorizontalPodAutoscalerStatus instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withCurrentCPUUtilizationPercentage(instance.getCurrentCPUUtilizationPercentage());
        this.withCurrentReplicas(instance.getCurrentReplicas());
        this.withDesiredReplicas(instance.getDesiredReplicas());
        this.withLastScaleTime(instance.getLastScaleTime());
        this.withObservedGeneration(instance.getObservedGeneration());
        this.withAdditionalProperties(instance.getAdditionalProperties());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public HorizontalPodAutoscalerStatus build() {
        HorizontalPodAutoscalerStatus buildable = new HorizontalPodAutoscalerStatus(this.fluent.getCurrentCPUUtilizationPercentage(), this.fluent.getCurrentReplicas(), this.fluent.getDesiredReplicas(), this.fluent.getLastScaleTime(), this.fluent.getObservedGeneration());
        buildable.setAdditionalProperties(this.fluent.getAdditionalProperties());
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        HorizontalPodAutoscalerStatusBuilder that = (HorizontalPodAutoscalerStatusBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.fluent, this.validationEnabled, super.hashCode());
    }
}

