/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v5_12;

import io.fabric8.kubernetes.api.builder.v5_12.VisitableBuilder;
import io.fabric8.kubernetes.api.model.v5_12.PodExecOptions;
import io.fabric8.kubernetes.api.model.v5_12.PodExecOptionsFluent;
import io.fabric8.kubernetes.api.model.v5_12.PodExecOptionsFluentImpl;
import java.util.Objects;

public class PodExecOptionsBuilder
extends PodExecOptionsFluentImpl<PodExecOptionsBuilder>
implements VisitableBuilder<PodExecOptions, PodExecOptionsBuilder> {
    PodExecOptionsFluent<?> fluent;
    Boolean validationEnabled;

    public PodExecOptionsBuilder() {
        this(false);
    }

    public PodExecOptionsBuilder(Boolean validationEnabled) {
        this(new PodExecOptions(), validationEnabled);
    }

    public PodExecOptionsBuilder(PodExecOptionsFluent<?> fluent) {
        this(fluent, (Boolean)false);
    }

    public PodExecOptionsBuilder(PodExecOptionsFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new PodExecOptions(), validationEnabled);
    }

    public PodExecOptionsBuilder(PodExecOptionsFluent<?> fluent, PodExecOptions instance) {
        this(fluent, instance, false);
    }

    public PodExecOptionsBuilder(PodExecOptionsFluent<?> fluent, PodExecOptions instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withApiVersion(instance.getApiVersion());
        fluent.withCommand(instance.getCommand());
        fluent.withContainer(instance.getContainer());
        fluent.withKind(instance.getKind());
        fluent.withStderr(instance.getStderr());
        fluent.withStdin(instance.getStdin());
        fluent.withStdout(instance.getStdout());
        fluent.withTty(instance.getTty());
        fluent.withAdditionalProperties(instance.getAdditionalProperties());
        this.validationEnabled = validationEnabled;
    }

    public PodExecOptionsBuilder(PodExecOptions instance) {
        this(instance, (Boolean)false);
    }

    public PodExecOptionsBuilder(PodExecOptions instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withApiVersion(instance.getApiVersion());
        this.withCommand(instance.getCommand());
        this.withContainer(instance.getContainer());
        this.withKind(instance.getKind());
        this.withStderr(instance.getStderr());
        this.withStdin(instance.getStdin());
        this.withStdout(instance.getStdout());
        this.withTty(instance.getTty());
        this.withAdditionalProperties(instance.getAdditionalProperties());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public PodExecOptions build() {
        PodExecOptions buildable = new PodExecOptions(this.fluent.getApiVersion(), this.fluent.getCommand(), this.fluent.getContainer(), this.fluent.getKind(), this.fluent.getStderr(), this.fluent.getStdin(), this.fluent.getStdout(), this.fluent.getTty());
        buildable.setAdditionalProperties(this.fluent.getAdditionalProperties());
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        PodExecOptionsBuilder that = (PodExecOptionsBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.fluent, this.validationEnabled, super.hashCode());
    }
}

