/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.client.dsl.internal.apps;

import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.autoscaling.v1.Scale;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.KubernetesClientTimeoutException;
import io.fabric8.kubernetes.client.dsl.LogWatch;
import io.fabric8.kubernetes.client.dsl.Loggable;
import io.fabric8.kubernetes.client.dsl.PodResource;
import io.fabric8.kubernetes.client.dsl.base.OperationContext;
import io.fabric8.kubernetes.client.dsl.base.PatchContext;
import io.fabric8.kubernetes.client.dsl.internal.HasMetadataOperationsImpl;
import io.fabric8.kubernetes.client.dsl.internal.LogWatchCallback;
import io.fabric8.kubernetes.client.dsl.internal.RollingOperationContext;
import io.fabric8.kubernetes.client.utils.PodOperationUtil;
import io.fabric8.kubernetes.client.utils.URLUtils;
import io.fabric8.openshift.api.model.DeploymentConfig;
import io.fabric8.openshift.api.model.DeploymentConfigList;
import io.fabric8.openshift.client.OpenshiftClientContext;
import io.fabric8.openshift.client.dsl.DeployableScalableResource;
import io.fabric8.openshift.client.dsl.internal.OpenShiftOperation;
import java.io.OutputStream;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.UnaryOperator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeploymentConfigOperationsImpl
extends OpenShiftOperation<DeploymentConfig, DeploymentConfigList, DeployableScalableResource<DeploymentConfig>>
implements DeployableScalableResource<DeploymentConfig> {
    private static final Logger LOG = LoggerFactory.getLogger(DeploymentConfigOperationsImpl.class);
    private static final Integer DEFAULT_POD_LOG_WAIT_TIMEOUT = 5;
    public static final String OPENSHIFT_IO_DEPLOYMENT_CONFIG_NAME = "openshift.io/deployment-config.name";
    private final RollingOperationContext rollingOperationContext;

    public DeploymentConfigOperationsImpl(OpenshiftClientContext clientContext) {
        this(new RollingOperationContext(), HasMetadataOperationsImpl.defaultContext(clientContext));
    }

    public DeploymentConfigOperationsImpl(RollingOperationContext context, OperationContext superContext) {
        super(superContext.withApiGroupName("apps.openshift.io").withPlural("deploymentconfigs"), DeploymentConfig.class, DeploymentConfigList.class);
        this.rollingOperationContext = context;
    }

    public DeploymentConfigOperationsImpl newInstance(OperationContext context) {
        return new DeploymentConfigOperationsImpl(this.rollingOperationContext, context);
    }

    @Override
    public DeploymentConfig edit(UnaryOperator<DeploymentConfig> function) {
        if (this.isCascading().booleanValue()) {
            return this.cascading(false).edit(function);
        }
        return (DeploymentConfig)super.edit((UnaryOperator)function);
    }

    @Override
    public DeploymentConfig accept(Consumer<DeploymentConfig> consumer) {
        if (this.isCascading().booleanValue()) {
            return this.cascading(false).accept(consumer);
        }
        return (DeploymentConfig)super.accept((Consumer)consumer);
    }

    @Override
    public DeploymentConfig replace(DeploymentConfig item) {
        if (this.isCascading().booleanValue()) {
            return this.cascading(false).replace(item);
        }
        return super.replace(item);
    }

    @Override
    public DeploymentConfig patch(PatchContext patchContext, DeploymentConfig item) {
        if (this.isCascading().booleanValue()) {
            return this.cascading(false).patch(patchContext, item);
        }
        return super.patch(patchContext, item);
    }

    @Override
    public DeploymentConfig deployLatest() {
        return this.deployLatest(false);
    }

    @Override
    public DeploymentConfig deployLatest(boolean wait) {
        Long currentVersion = ((DeploymentConfig)this.getMandatory()).getStatus().getLatestVersion();
        if (currentVersion == null) {
            currentVersion = 1L;
        }
        Long latestVersion = currentVersion + 1L;
        DeploymentConfig deployment = this.cascading(false).accept((T d) -> d.getStatus().setLatestVersion(latestVersion));
        if (wait) {
            this.waitUntilDeploymentConfigIsScaled(deployment.getSpec().getReplicas());
            deployment = (DeploymentConfig)this.getMandatory();
        }
        return deployment;
    }

    @Override
    public DeploymentConfig scale(int count) {
        return this.scale(count, false);
    }

    @Override
    public DeploymentConfig scale(int count, boolean wait) {
        DeploymentConfig deployment = this.cascading(false).accept((T d) -> d.getSpec().setReplicas(count));
        if (wait) {
            this.waitUntilDeploymentConfigIsScaled(count);
            deployment = (DeploymentConfig)this.getMandatory();
        }
        return deployment;
    }

    @Override
    public Scale scale() {
        return this.handleScale(null);
    }

    @Override
    public Scale scale(Scale scale) {
        return this.handleScale(scale);
    }

    private void waitUntilDeploymentConfigIsScaled(int count) {
        AtomicReference<Integer> replicasRef = new AtomicReference<Integer>(0);
        String name = this.checkName(this.getItem());
        String namespace = this.checkNamespace(this.getItem());
        try {
            this.waitUntilCondition(deploymentConfig -> {
                int currentReplicas;
                if (deploymentConfig == null) {
                    if (count == 0) {
                        return true;
                    }
                    throw new IllegalStateException("Can't wait for DeploymentConfig: " + this.checkName(this.getItem()) + " in namespace: " + this.checkName(this.getItem()) + " to scale. Resource is no longer available.");
                }
                replicasRef.set(deploymentConfig.getStatus().getReplicas());
                int n = currentReplicas = deploymentConfig.getStatus().getReplicas() != null ? deploymentConfig.getStatus().getReplicas() : 0;
                if (deploymentConfig.getStatus().getObservedGeneration() >= deploymentConfig.getMetadata().getGeneration() && Objects.equals(deploymentConfig.getSpec().getReplicas(), currentReplicas)) {
                    return true;
                }
                LOG.debug("Only {}/{} pods scheduled for DeploymentConfig: {} in namespace: {} seconds so waiting...", new Object[]{deploymentConfig.getStatus().getReplicas(), deploymentConfig.getSpec().getReplicas(), deploymentConfig.getMetadata().getName(), namespace});
                return false;
            }, this.getConfig().getScaleTimeout(), TimeUnit.MILLISECONDS);
            LOG.debug("{}/{} pod(s) ready for DeploymentConfig: {} in namespace: {}.", new Object[]{replicasRef.get(), count, name, namespace});
        }
        catch (KubernetesClientTimeoutException e) {
            LOG.error("{}/{} pod(s) ready for DeploymentConfig: {} in namespace: {}  after waiting for {} seconds so giving up", new Object[]{replicasRef.get(), count, name, namespace, TimeUnit.MILLISECONDS.toSeconds(this.getConfig().getScaleTimeout())});
        }
    }

    @Override
    public String getLog() {
        return this.getLog(false);
    }

    @Override
    public String getLog(Boolean isPretty) {
        return this.doGetLog(isPretty, String.class);
    }

    private <T> T doGetLog(Boolean isPretty, Class<T> type) {
        try {
            URL url = this.getResourceLogUrl(isPretty, false);
            return this.handleRawGet(url, type);
        }
        catch (Throwable t) {
            throw KubernetesClientException.launderThrowable(this.forOperationType("doGetLog"), t);
        }
    }

    @Override
    public Reader getLogReader() {
        return this.doGetLog(false, Reader.class);
    }

    @Override
    public LogWatch watchLog() {
        return this.watchLog(null);
    }

    @Override
    public LogWatch watchLog(OutputStream out) {
        try {
            this.waitUntilDeploymentConfigPodBecomesReady((DeploymentConfig)this.fromServer().get());
            URL url = this.getResourceLogUrl(false, true);
            LogWatchCallback callback = new LogWatchCallback(this.config, out);
            return callback.callAndWait(this.httpClient, url);
        }
        catch (Throwable t) {
            throw KubernetesClientException.launderThrowable(this.forOperationType("watchLog"), t);
        }
    }

    private URL getResourceLogUrl(Boolean withPrettyOutput, Boolean follow) throws MalformedURLException {
        URLUtils.URLBuilder requestUrlBuilder = new URLUtils.URLBuilder(URLUtils.join(this.getResourceUrl().toString(), "log"));
        if (Boolean.TRUE.equals(withPrettyOutput)) {
            requestUrlBuilder.addQueryParameter("pretty", withPrettyOutput.toString());
        }
        if (Boolean.TRUE.equals(follow)) {
            requestUrlBuilder.addQueryParameter("follow", "true");
        }
        return requestUrlBuilder.build();
    }

    @Override
    public Loggable<LogWatch> withLogWaitTimeout(Integer logWaitTimeout) {
        return new DeploymentConfigOperationsImpl(this.rollingOperationContext.withLogWaitTimout(logWaitTimeout), this.context);
    }

    private void waitUntilDeploymentConfigPodBecomesReady(DeploymentConfig deploymentConfig) {
        Integer podLogWaitTimeout = this.rollingOperationContext.getLogWaitTimeout();
        List<PodResource<Pod>> podOps = PodOperationUtil.getPodOperationsForController(this.context, deploymentConfig.getMetadata().getUid(), DeploymentConfigOperationsImpl.getDeploymentConfigPodLabels(deploymentConfig), false, podLogWaitTimeout, this.rollingOperationContext.getContainerId());
        DeploymentConfigOperationsImpl.waitForBuildPodToBecomeReady(podOps, podLogWaitTimeout != null ? podLogWaitTimeout : DEFAULT_POD_LOG_WAIT_TIMEOUT);
    }

    private static void waitForBuildPodToBecomeReady(List<PodResource<Pod>> podOps, Integer podLogWaitTimeout) {
        for (PodResource<Pod> podOp : podOps) {
            PodOperationUtil.waitUntilReadyBeforeFetchingLogs(podOp, podLogWaitTimeout);
        }
    }

    static Map<String, String> getDeploymentConfigPodLabels(DeploymentConfig deploymentConfig) {
        HashMap<String, String> labels = new HashMap<String, String>();
        if (deploymentConfig != null && deploymentConfig.getMetadata() != null) {
            labels.put(OPENSHIFT_IO_DEPLOYMENT_CONFIG_NAME, deploymentConfig.getMetadata().getName());
        }
        return labels;
    }

    @Override
    public Loggable<LogWatch> inContainer(String id) {
        return new DeploymentConfigOperationsImpl(this.rollingOperationContext.withContainerId(id), this.context);
    }
}

