/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.clnt.v5_12;

import io.fabric8.kubernetes.api.model.v5_12.ComponentStatus;
import io.fabric8.kubernetes.api.model.v5_12.ComponentStatusList;
import io.fabric8.kubernetes.api.model.v5_12.HasMetadata;
import io.fabric8.kubernetes.api.model.v5_12.KubernetesList;
import io.fabric8.kubernetes.api.model.v5_12.KubernetesResourceList;
import io.fabric8.kubernetes.api.model.v5_12.RootPaths;
import io.fabric8.kubernetes.clnt.v5_12.BaseKubernetesClient;
import io.fabric8.kubernetes.clnt.v5_12.ClientContext;
import io.fabric8.kubernetes.clnt.v5_12.Config;
import io.fabric8.kubernetes.clnt.v5_12.ExtensionsAPIGroupClient;
import io.fabric8.kubernetes.clnt.v5_12.Handlers;
import io.fabric8.kubernetes.clnt.v5_12.KubernetesClientException;
import io.fabric8.kubernetes.clnt.v5_12.RequestConfig;
import io.fabric8.kubernetes.clnt.v5_12.SimpleClientContext;
import io.fabric8.kubernetes.clnt.v5_12.VersionInfo;
import io.fabric8.kubernetes.clnt.v5_12.WithRequestCallable;
import io.fabric8.kubernetes.clnt.v5_12.dsl.CreateOrDeleteable;
import io.fabric8.kubernetes.clnt.v5_12.dsl.FunctionCallable;
import io.fabric8.kubernetes.clnt.v5_12.dsl.Gettable;
import io.fabric8.kubernetes.clnt.v5_12.dsl.InOutCreateable;
import io.fabric8.kubernetes.clnt.v5_12.dsl.LogWatch;
import io.fabric8.kubernetes.clnt.v5_12.dsl.MixedOperation;
import io.fabric8.kubernetes.clnt.v5_12.dsl.Nameable;
import io.fabric8.kubernetes.clnt.v5_12.dsl.NamespaceListVisitFromServerGetDeleteRecreateWaitApplicable;
import io.fabric8.kubernetes.clnt.v5_12.dsl.Namespaceable;
import io.fabric8.kubernetes.clnt.v5_12.dsl.NamespacedInOutCreateable;
import io.fabric8.kubernetes.clnt.v5_12.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.clnt.v5_12.dsl.ParameterMixedOperation;
import io.fabric8.kubernetes.clnt.v5_12.dsl.ParameterNamespaceListVisitFromServerGetDeleteRecreateWaitApplicable;
import io.fabric8.kubernetes.clnt.v5_12.dsl.Resource;
import io.fabric8.kubernetes.clnt.v5_12.dsl.base.HasMetadataOperation;
import io.fabric8.kubernetes.clnt.v5_12.dsl.internal.core.v1.ComponentStatusOperationsImpl;
import io.fabric8.kubernetes.clnt.v5_12.extended.leaderelection.LeaderElectorBuilder;
import io.fabric8.kubernetes.clnt.v5_12.http.HttpClient;
import io.fabric8.kubernetes.clnt.v5_12.okhttp.OkHttpClientImpl;
import io.fabric8.kubernetes.clnt.v5_12.utils.HttpClientUtils;
import io.fabric8.kubernetes.clnt.v5_12.utils.Serialization;
import io.fabric8.openshift.api.model.v5_12.BrokerTemplateInstance;
import io.fabric8.openshift.api.model.v5_12.BrokerTemplateInstanceList;
import io.fabric8.openshift.api.model.v5_12.Build;
import io.fabric8.openshift.api.model.v5_12.BuildConfig;
import io.fabric8.openshift.api.model.v5_12.BuildConfigList;
import io.fabric8.openshift.api.model.v5_12.BuildList;
import io.fabric8.openshift.api.model.v5_12.ClusterNetwork;
import io.fabric8.openshift.api.model.v5_12.ClusterNetworkList;
import io.fabric8.openshift.api.model.v5_12.ClusterRole;
import io.fabric8.openshift.api.model.v5_12.ClusterRoleBinding;
import io.fabric8.openshift.api.model.v5_12.ClusterRoleBindingList;
import io.fabric8.openshift.api.model.v5_12.ClusterRoleList;
import io.fabric8.openshift.api.model.v5_12.ClusterVersion;
import io.fabric8.openshift.api.model.v5_12.DeploymentConfig;
import io.fabric8.openshift.api.model.v5_12.DeploymentConfigList;
import io.fabric8.openshift.api.model.v5_12.EgressNetworkPolicy;
import io.fabric8.openshift.api.model.v5_12.EgressNetworkPolicyList;
import io.fabric8.openshift.api.model.v5_12.Group;
import io.fabric8.openshift.api.model.v5_12.GroupList;
import io.fabric8.openshift.api.model.v5_12.HelmChartRepository;
import io.fabric8.openshift.api.model.v5_12.HelmChartRepositoryList;
import io.fabric8.openshift.api.model.v5_12.HostSubnet;
import io.fabric8.openshift.api.model.v5_12.HostSubnetList;
import io.fabric8.openshift.api.model.v5_12.Identity;
import io.fabric8.openshift.api.model.v5_12.IdentityList;
import io.fabric8.openshift.api.model.v5_12.Image;
import io.fabric8.openshift.api.model.v5_12.ImageList;
import io.fabric8.openshift.api.model.v5_12.ImageSignature;
import io.fabric8.openshift.api.model.v5_12.ImageStream;
import io.fabric8.openshift.api.model.v5_12.ImageStreamImage;
import io.fabric8.openshift.api.model.v5_12.ImageStreamImport;
import io.fabric8.openshift.api.model.v5_12.ImageStreamList;
import io.fabric8.openshift.api.model.v5_12.ImageStreamMapping;
import io.fabric8.openshift.api.model.v5_12.ImageStreamTag;
import io.fabric8.openshift.api.model.v5_12.ImageStreamTagList;
import io.fabric8.openshift.api.model.v5_12.ImageTag;
import io.fabric8.openshift.api.model.v5_12.ImageTagList;
import io.fabric8.openshift.api.model.v5_12.LocalResourceAccessReview;
import io.fabric8.openshift.api.model.v5_12.LocalSubjectAccessReview;
import io.fabric8.openshift.api.model.v5_12.NetNamespace;
import io.fabric8.openshift.api.model.v5_12.NetNamespaceList;
import io.fabric8.openshift.api.model.v5_12.OAuthAccessToken;
import io.fabric8.openshift.api.model.v5_12.OAuthAccessTokenList;
import io.fabric8.openshift.api.model.v5_12.OAuthAuthorizeToken;
import io.fabric8.openshift.api.model.v5_12.OAuthAuthorizeTokenList;
import io.fabric8.openshift.api.model.v5_12.OAuthClient;
import io.fabric8.openshift.api.model.v5_12.OAuthClientAuthorization;
import io.fabric8.openshift.api.model.v5_12.OAuthClientAuthorizationList;
import io.fabric8.openshift.api.model.v5_12.OAuthClientList;
import io.fabric8.openshift.api.model.v5_12.PodSecurityPolicyReview;
import io.fabric8.openshift.api.model.v5_12.PodSecurityPolicySelfSubjectReview;
import io.fabric8.openshift.api.model.v5_12.PodSecurityPolicySubjectReview;
import io.fabric8.openshift.api.model.v5_12.RangeAllocation;
import io.fabric8.openshift.api.model.v5_12.RangeAllocationList;
import io.fabric8.openshift.api.model.v5_12.ResourceAccessReview;
import io.fabric8.openshift.api.model.v5_12.ResourceAccessReviewResponse;
import io.fabric8.openshift.api.model.v5_12.Role;
import io.fabric8.openshift.api.model.v5_12.RoleBinding;
import io.fabric8.openshift.api.model.v5_12.RoleBindingList;
import io.fabric8.openshift.api.model.v5_12.RoleBindingRestriction;
import io.fabric8.openshift.api.model.v5_12.RoleBindingRestrictionList;
import io.fabric8.openshift.api.model.v5_12.RoleList;
import io.fabric8.openshift.api.model.v5_12.Route;
import io.fabric8.openshift.api.model.v5_12.RouteList;
import io.fabric8.openshift.api.model.v5_12.SecurityContextConstraints;
import io.fabric8.openshift.api.model.v5_12.SecurityContextConstraintsList;
import io.fabric8.openshift.api.model.v5_12.SelfSubjectRulesReview;
import io.fabric8.openshift.api.model.v5_12.SubjectAccessReview;
import io.fabric8.openshift.api.model.v5_12.SubjectAccessReviewResponse;
import io.fabric8.openshift.api.model.v5_12.SubjectRulesReview;
import io.fabric8.openshift.api.model.v5_12.Template;
import io.fabric8.openshift.api.model.v5_12.TemplateInstance;
import io.fabric8.openshift.api.model.v5_12.TemplateInstanceList;
import io.fabric8.openshift.api.model.v5_12.TemplateList;
import io.fabric8.openshift.api.model.v5_12.User;
import io.fabric8.openshift.api.model.v5_12.UserIdentityMapping;
import io.fabric8.openshift.api.model.v5_12.UserList;
import io.fabric8.openshift.api.model.v5_12.UserOAuthAccessToken;
import io.fabric8.openshift.api.model.v5_12.UserOAuthAccessTokenList;
import io.fabric8.openshift.api.model.v5_12.miscellaneous.apiserver.v1.APIRequestCount;
import io.fabric8.openshift.api.model.v5_12.miscellaneous.apiserver.v1.APIRequestCountList;
import io.fabric8.openshift.api.model.v5_12.miscellaneous.cloudcredential.v1.CredentialsRequest;
import io.fabric8.openshift.api.model.v5_12.miscellaneous.cloudcredential.v1.CredentialsRequestList;
import io.fabric8.openshift.api.model.v5_12.miscellaneous.cncf.cni.v1.NetworkAttachmentDefinition;
import io.fabric8.openshift.api.model.v5_12.miscellaneous.cncf.cni.v1.NetworkAttachmentDefinitionList;
import io.fabric8.openshift.api.model.v5_12.miscellaneous.imageregistry.operator.v1.ConfigList;
import io.fabric8.openshift.api.model.v5_12.miscellaneous.metal3.v1alpha1.BareMetalHost;
import io.fabric8.openshift.api.model.v5_12.miscellaneous.metal3.v1alpha1.BareMetalHostList;
import io.fabric8.openshift.api.model.v5_12.miscellaneous.network.operator.v1.EgressRouter;
import io.fabric8.openshift.api.model.v5_12.miscellaneous.network.operator.v1.EgressRouterList;
import io.fabric8.openshift.api.model.v5_12.miscellaneous.network.operator.v1.OperatorPKI;
import io.fabric8.openshift.api.model.v5_12.miscellaneous.network.operator.v1.OperatorPKIList;
import io.fabric8.openshift.clnt.v5_12.NamespacedOpenShiftClient;
import io.fabric8.openshift.clnt.v5_12.OpenShiftClusterAutoscalingAPIGroupClient;
import io.fabric8.openshift.clnt.v5_12.OpenShiftConfig;
import io.fabric8.openshift.clnt.v5_12.OpenShiftConfigAPIGroupClient;
import io.fabric8.openshift.clnt.v5_12.OpenShiftConfigBuilder;
import io.fabric8.openshift.clnt.v5_12.OpenShiftConsoleAPIGroupClient;
import io.fabric8.openshift.clnt.v5_12.OpenShiftHandlers;
import io.fabric8.openshift.clnt.v5_12.OpenShiftHiveAPIGroupClient;
import io.fabric8.openshift.clnt.v5_12.OpenShiftMachineAPIGroupClient;
import io.fabric8.openshift.clnt.v5_12.OpenShiftMachineConfigurationAPIGroupClient;
import io.fabric8.openshift.clnt.v5_12.OpenShiftMonitoringAPIGroupClient;
import io.fabric8.openshift.clnt.v5_12.OpenShiftOperatorAPIGroupClient;
import io.fabric8.openshift.clnt.v5_12.OpenShiftOperatorHubAPIGroupClient;
import io.fabric8.openshift.clnt.v5_12.OpenShiftQuotaAPIGroupClient;
import io.fabric8.openshift.clnt.v5_12.OpenShiftStorageVersionMigratorApiGroupClient;
import io.fabric8.openshift.clnt.v5_12.OpenShiftTunedAPIGroupClient;
import io.fabric8.openshift.clnt.v5_12.OpenShiftWhereaboutsAPIGroupClient;
import io.fabric8.openshift.clnt.v5_12.OpenshiftAdapterSupport;
import io.fabric8.openshift.clnt.v5_12.OpenshiftClientContext;
import io.fabric8.openshift.clnt.v5_12.dsl.BuildConfigResource;
import io.fabric8.openshift.clnt.v5_12.dsl.BuildResource;
import io.fabric8.openshift.clnt.v5_12.dsl.DeployableScalableResource;
import io.fabric8.openshift.clnt.v5_12.dsl.MachineConfigurationAPIGroupDSL;
import io.fabric8.openshift.clnt.v5_12.dsl.NameableCreateOrDeleteable;
import io.fabric8.openshift.clnt.v5_12.dsl.OpenShiftClusterAutoscalingAPIGroupDSL;
import io.fabric8.openshift.clnt.v5_12.dsl.OpenShiftConfigAPIGroupDSL;
import io.fabric8.openshift.clnt.v5_12.dsl.OpenShiftConsoleAPIGroupDSL;
import io.fabric8.openshift.clnt.v5_12.dsl.OpenShiftHiveAPIGroupDSL;
import io.fabric8.openshift.clnt.v5_12.dsl.OpenShiftMachineAPIGroupDSL;
import io.fabric8.openshift.clnt.v5_12.dsl.OpenShiftMonitoringAPIGroupDSL;
import io.fabric8.openshift.clnt.v5_12.dsl.OpenShiftOperatorAPIGroupDSL;
import io.fabric8.openshift.clnt.v5_12.dsl.OpenShiftOperatorHubAPIGroupDSL;
import io.fabric8.openshift.clnt.v5_12.dsl.OpenShiftQuotaAPIGroupDSL;
import io.fabric8.openshift.clnt.v5_12.dsl.OpenShiftStorageVersionMigratorApiGroupDSL;
import io.fabric8.openshift.clnt.v5_12.dsl.OpenShiftTunedAPIGroupDSL;
import io.fabric8.openshift.clnt.v5_12.dsl.OpenShiftWhereaboutsAPIGroupDSL;
import io.fabric8.openshift.clnt.v5_12.dsl.ProjectOperation;
import io.fabric8.openshift.clnt.v5_12.dsl.ProjectRequestOperation;
import io.fabric8.openshift.clnt.v5_12.dsl.TemplateResource;
import io.fabric8.openshift.clnt.v5_12.dsl.internal.ProjectRequestsOperationImpl;
import io.fabric8.openshift.clnt.v5_12.dsl.internal.apps.DeploymentConfigOperationsImpl;
import io.fabric8.openshift.clnt.v5_12.dsl.internal.authorization.ClusterRoleBindingOperationsImpl;
import io.fabric8.openshift.clnt.v5_12.dsl.internal.authorization.RoleBindingOperationsImpl;
import io.fabric8.openshift.clnt.v5_12.dsl.internal.authorization.RoleOperationsImpl;
import io.fabric8.openshift.clnt.v5_12.dsl.internal.build.BuildConfigOperationsImpl;
import io.fabric8.openshift.clnt.v5_12.dsl.internal.build.BuildOperationsImpl;
import io.fabric8.openshift.clnt.v5_12.dsl.internal.core.NetworkAttachmentDefinitionOperationsImpl;
import io.fabric8.openshift.clnt.v5_12.dsl.internal.core.TemplateOperationsImpl;
import io.fabric8.openshift.clnt.v5_12.dsl.internal.oauth.OAuthAccessTokenOperationsImpl;
import io.fabric8.openshift.clnt.v5_12.dsl.internal.oauth.OAuthAuthorizeTokenOperationsImpl;
import io.fabric8.openshift.clnt.v5_12.dsl.internal.oauth.OAuthClientOperationsImpl;
import io.fabric8.openshift.clnt.v5_12.dsl.internal.project.ProjectOperationsImpl;
import io.fabric8.openshift.clnt.v5_12.dsl.internal.security.SecurityContextConstraintsOperationsImpl;
import io.fabric8.openshift.clnt.v5_12.dsl.internal.user.GroupOperationsImpl;
import io.fabric8.openshift.clnt.v5_12.dsl.internal.user.UserOperationsImpl;
import io.fabric8.openshift.clnt.v5_12.internal.OpenShiftNamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicableListImpl;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.ParseException;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import okhttp3.OkHttpClient;

public class DefaultOpenShiftClient
extends BaseKubernetesClient<NamespacedOpenShiftClient>
implements NamespacedOpenShiftClient,
OpenshiftClientContext {
    public static final String OPENSHIFT_VERSION_ENDPOINT = "version/openshift";
    private final URL openShiftUrl;

    public DefaultOpenShiftClient() {
        this(new OpenShiftConfigBuilder().build());
    }

    public DefaultOpenShiftClient(String masterUrl) {
        this(((OpenShiftConfigBuilder)new OpenShiftConfigBuilder().withMasterUrl(masterUrl)).build());
    }

    public DefaultOpenShiftClient(Config config) {
        this(new OpenShiftConfig(config));
    }

    public DefaultOpenShiftClient(OpenShiftConfig config) {
        this(HttpClientUtils.createHttpClient(config), config);
    }

    @Deprecated
    public DefaultOpenShiftClient(OkHttpClient httpClient, OpenShiftConfig config) {
        this((HttpClient)new OkHttpClientImpl(httpClient), config);
    }

    public DefaultOpenShiftClient(HttpClient httpClient, OpenShiftConfig config) {
        this(new SimpleClientContext(config, httpClient));
    }

    public DefaultOpenShiftClient(ClientContext clientContext) {
        super(clientContext);
        try {
            this.openShiftUrl = new URL(this.getConfiguration().getOpenShiftUrl());
        }
        catch (MalformedURLException e) {
            throw new KubernetesClientException("Could not create client", e);
        }
    }

    public static DefaultOpenShiftClient fromConfig(String config) {
        return new DefaultOpenShiftClient(Serialization.unmarshal(config, OpenShiftConfig.class));
    }

    public static DefaultOpenShiftClient fromConfig(InputStream is) {
        return new DefaultOpenShiftClient(Serialization.unmarshal(is, OpenShiftConfig.class));
    }

    @Override
    public URL getOpenshiftUrl() {
        return this.openShiftUrl;
    }

    @Override
    public OpenShiftConfig getConfiguration() {
        return OpenShiftConfig.wrap(super.getConfiguration());
    }

    @Override
    public OpenShiftConfigAPIGroupDSL config() {
        return this.adapt(OpenShiftConfigAPIGroupClient.class);
    }

    @Override
    public OpenShiftConsoleAPIGroupDSL console() {
        return this.adapt(OpenShiftConsoleAPIGroupClient.class);
    }

    @Override
    public OpenShiftClusterAutoscalingAPIGroupDSL clusterAutoscaling() {
        return this.adapt(OpenShiftClusterAutoscalingAPIGroupClient.class);
    }

    @Override
    public OpenShiftHiveAPIGroupDSL hive() {
        return this.adapt(OpenShiftHiveAPIGroupClient.class);
    }

    @Override
    public OpenShiftOperatorAPIGroupDSL operator() {
        return this.adapt(OpenShiftOperatorAPIGroupClient.class);
    }

    @Override
    public OpenShiftOperatorHubAPIGroupDSL operatorHub() {
        return this.adapt(OpenShiftOperatorHubAPIGroupClient.class);
    }

    public MixedOperation<ComponentStatus, ComponentStatusList, Resource<ComponentStatus>> componentstatuses() {
        return new ComponentStatusOperationsImpl(this);
    }

    @Override
    public ParameterNamespaceListVisitFromServerGetDeleteRecreateWaitApplicable<HasMetadata> load(InputStream is) {
        return new OpenShiftNamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicableListImpl(this, is);
    }

    @Override
    public NamespaceListVisitFromServerGetDeleteRecreateWaitApplicable<HasMetadata> resourceList(KubernetesResourceList item) {
        return new OpenShiftNamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicableListImpl(this, item);
    }

    @Override
    public ParameterNamespaceListVisitFromServerGetDeleteRecreateWaitApplicable<HasMetadata> resourceList(String s) {
        return new OpenShiftNamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicableListImpl(this, s);
    }

    @Override
    public MixedOperation<Build, BuildList, BuildResource<Build, LogWatch>> builds() {
        return new BuildOperationsImpl(this);
    }

    @Override
    public MixedOperation<BuildConfig, BuildConfigList, BuildConfigResource<BuildConfig, Void, Build>> buildConfigs() {
        return new BuildConfigOperationsImpl(this);
    }

    @Override
    public MixedOperation<CredentialsRequest, CredentialsRequestList, Resource<CredentialsRequest>> credentialsRequests() {
        return OpenShiftHandlers.getOperation(CredentialsRequest.class, CredentialsRequestList.class, this);
    }

    @Override
    public MixedOperation<DeploymentConfig, DeploymentConfigList, DeployableScalableResource<DeploymentConfig>> deploymentConfigs() {
        return new DeploymentConfigOperationsImpl(this);
    }

    public MixedOperation<Group, GroupList, Resource<Group>> groups() {
        return new GroupOperationsImpl(this);
    }

    @Override
    public NonNamespaceOperation<HelmChartRepository, HelmChartRepositoryList, Resource<HelmChartRepository>> helmChartRepositories() {
        return OpenShiftHandlers.getOperation(HelmChartRepository.class, HelmChartRepositoryList.class, this);
    }

    @Override
    public NonNamespaceOperation<Image, ImageList, Resource<Image>> images() {
        return OpenShiftHandlers.getOperation(Image.class, ImageList.class, this);
    }

    @Override
    public MixedOperation<ImageTag, ImageTagList, Resource<ImageTag>> imageTags() {
        return OpenShiftHandlers.getOperation(ImageTag.class, ImageTagList.class, this);
    }

    @Override
    public MixedOperation<ImageStream, ImageStreamList, Resource<ImageStream>> imageStreams() {
        return OpenShiftHandlers.getOperation(ImageStream.class, ImageStreamList.class, this);
    }

    @Override
    public MixedOperation<ImageStreamTag, ImageStreamTagList, Resource<ImageStreamTag>> imageStreamTags() {
        return OpenShiftHandlers.getOperation(ImageStreamTag.class, ImageStreamTagList.class, this);
    }

    @Override
    public NamespacedInOutCreateable<ImageStreamImport, ImageStreamImport> imageStreamImports() {
        return Handlers.getNamespacedHasMetadataCreateOnlyOperation(ImageStreamImport.class, this);
    }

    @Override
    public NamespacedInOutCreateable<ImageStreamMapping, ImageStreamMapping> imageStreamMappings() {
        return Handlers.getNamespacedHasMetadataCreateOnlyOperation(ImageStreamMapping.class, this);
    }

    @Override
    public Namespaceable<Nameable<? extends Gettable<ImageStreamImage>>> imageStreamImages() {
        HasMetadataOperation<ImageStreamImage, ?, Resource<ImageStreamImage>> operation = Handlers.getNonListingOperation(ImageStreamImage.class, this);
        return operation::inNamespace;
    }

    @Override
    public NameableCreateOrDeleteable imageSignatures() {
        final HasMetadataOperation<ImageSignature, ?, Resource<ImageSignature>> operation = Handlers.getNonListingOperation(ImageSignature.class, this);
        return new NameableCreateOrDeleteable(){

            @Override
            public Boolean delete() {
                return operation.delete();
            }

            @Override
            public ImageSignature create(ImageSignature item) {
                return (ImageSignature)operation.create(item);
            }

            @Override
            public ImageSignature create(ImageSignature ... item) {
                return (ImageSignature)operation.create(item);
            }

            @Override
            public CreateOrDeleteable<ImageSignature> withName(String name) {
                return operation.withName(name);
            }
        };
    }

    @Override
    public NonNamespaceOperation<io.fabric8.openshift.api.model.v5_12.miscellaneous.imageregistry.operator.v1.Config, ConfigList, Resource<io.fabric8.openshift.api.model.v5_12.miscellaneous.imageregistry.operator.v1.Config>> imageRegistryOperatorConfigs() {
        return OpenShiftHandlers.getOperation(io.fabric8.openshift.api.model.v5_12.miscellaneous.imageregistry.operator.v1.Config.class, ConfigList.class, this);
    }

    @Override
    public MixedOperation<NetworkAttachmentDefinition, NetworkAttachmentDefinitionList, Resource<NetworkAttachmentDefinition>> networkAttachmentDefinitions() {
        return new NetworkAttachmentDefinitionOperationsImpl(this);
    }

    @Override
    public NonNamespaceOperation<OAuthAccessToken, OAuthAccessTokenList, Resource<OAuthAccessToken>> oAuthAccessTokens() {
        return new OAuthAccessTokenOperationsImpl(this);
    }

    @Override
    public NonNamespaceOperation<OAuthAuthorizeToken, OAuthAuthorizeTokenList, Resource<OAuthAuthorizeToken>> oAuthAuthorizeTokens() {
        return new OAuthAuthorizeTokenOperationsImpl(this);
    }

    @Override
    public NonNamespaceOperation<OAuthClient, OAuthClientList, Resource<OAuthClient>> oAuthClients() {
        return new OAuthClientOperationsImpl(this);
    }

    @Override
    public NamespacedInOutCreateable<PodSecurityPolicyReview, PodSecurityPolicyReview> podSecurityPolicyReviews() {
        return OpenShiftHandlers.getCreateOnlyResourceOperation(PodSecurityPolicyReview.class, PodSecurityPolicyReview.class, this);
    }

    @Override
    public NonNamespaceOperation<OAuthClientAuthorization, OAuthClientAuthorizationList, Resource<OAuthClientAuthorization>> oAuthClientAuthorizations() {
        return OpenShiftHandlers.getOperation(OAuthClientAuthorization.class, OAuthClientAuthorizationList.class, this);
    }

    @Override
    public MixedOperation<OperatorPKI, OperatorPKIList, Resource<OperatorPKI>> operatorPKIs() {
        return OpenShiftHandlers.getOperation(OperatorPKI.class, OperatorPKIList.class, this);
    }

    @Override
    public MixedOperation<EgressRouter, EgressRouterList, Resource<EgressRouter>> egressRouters() {
        return OpenShiftHandlers.getOperation(EgressRouter.class, EgressRouterList.class, this);
    }

    @Override
    public NamespacedInOutCreateable<PodSecurityPolicySelfSubjectReview, PodSecurityPolicySelfSubjectReview> podSecurityPolicySelfSubjectReviews() {
        return OpenShiftHandlers.getCreateOnlyResourceOperation(PodSecurityPolicySelfSubjectReview.class, PodSecurityPolicySelfSubjectReview.class, this);
    }

    @Override
    public NamespacedInOutCreateable<PodSecurityPolicySubjectReview, PodSecurityPolicySubjectReview> podSecurityPolicySubjectReviews() {
        return OpenShiftHandlers.getCreateOnlyResourceOperation(PodSecurityPolicySubjectReview.class, PodSecurityPolicySubjectReview.class, this);
    }

    @Override
    public ProjectOperation projects() {
        return new ProjectOperationsImpl(this);
    }

    @Override
    public OpenShiftQuotaAPIGroupDSL quotas() {
        return this.adapt(OpenShiftQuotaAPIGroupClient.class);
    }

    @Override
    public NonNamespaceOperation<RangeAllocation, RangeAllocationList, Resource<RangeAllocation>> rangeAllocations() {
        return OpenShiftHandlers.getOperation(RangeAllocation.class, RangeAllocationList.class, this);
    }

    @Override
    public NonNamespaceOperation<SecurityContextConstraints, SecurityContextConstraintsList, Resource<SecurityContextConstraints>> securityContextConstraints() {
        return new SecurityContextConstraintsOperationsImpl(this);
    }

    @Override
    public ProjectRequestOperation projectrequests() {
        return new ProjectRequestsOperationImpl(this);
    }

    @Override
    public MixedOperation<Role, RoleList, Resource<Role>> roles() {
        return new RoleOperationsImpl(this);
    }

    @Override
    public MixedOperation<RoleBinding, RoleBindingList, Resource<RoleBinding>> roleBindings() {
        return new RoleBindingOperationsImpl(this);
    }

    @Override
    public MixedOperation<Route, RouteList, Resource<Route>> routes() {
        return OpenShiftHandlers.getOperation(Route.class, RouteList.class, this);
    }

    @Override
    public ParameterMixedOperation<Template, TemplateList, TemplateResource<Template, KubernetesList>> templates() {
        return new TemplateOperationsImpl(this);
    }

    @Override
    public MixedOperation<TemplateInstance, TemplateInstanceList, Resource<TemplateInstance>> templateInstances() {
        return OpenShiftHandlers.getOperation(TemplateInstance.class, TemplateInstanceList.class, this);
    }

    @Override
    public OpenShiftTunedAPIGroupDSL tuned() {
        return this.adapt(OpenShiftTunedAPIGroupClient.class);
    }

    @Override
    public NonNamespaceOperation<BrokerTemplateInstance, BrokerTemplateInstanceList, Resource<BrokerTemplateInstance>> brokerTemplateInstances() {
        return OpenShiftHandlers.getOperation(BrokerTemplateInstance.class, BrokerTemplateInstanceList.class, this);
    }

    public MixedOperation<User, UserList, Resource<User>> users() {
        return new UserOperationsImpl(this);
    }

    @Override
    public MixedOperation<ClusterRoleBinding, ClusterRoleBindingList, Resource<ClusterRoleBinding>> clusterRoleBindings() {
        return new ClusterRoleBindingOperationsImpl(this);
    }

    @Override
    public MixedOperation<RoleBindingRestriction, RoleBindingRestrictionList, Resource<RoleBindingRestriction>> roleBindingRestrictions() {
        return OpenShiftHandlers.getOperation(RoleBindingRestriction.class, RoleBindingRestrictionList.class, this);
    }

    @Override
    public NamespacedOpenShiftClient inNamespace(String namespace) {
        OpenShiftConfig updated = ((OpenShiftConfigBuilder)new OpenShiftConfigBuilder(this.getConfiguration()).withNamespace(namespace)).build();
        return new DefaultOpenShiftClient(this.newState(updated));
    }

    @Override
    public NamespacedOpenShiftClient inAnyNamespace() {
        return this.inNamespace(null);
    }

    @Override
    public ExtensionsAPIGroupClient extensions() {
        return this.adapt(ExtensionsAPIGroupClient.class);
    }

    @Override
    public VersionInfo getVersion() {
        for (Supplier supplier : new Supplier[]{this::getOpenShiftV3Version, this::getOpenShiftV4VersionInfo}) {
            try {
                VersionInfo vi = (VersionInfo)supplier.get();
                if (vi == null) continue;
                return vi;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return super.getVersion();
    }

    @Override
    public VersionInfo getKubernetesVersion() {
        return super.getVersion();
    }

    @Override
    public VersionInfo getOpenShiftV3Version() {
        return this.getVersionInfo(OPENSHIFT_VERSION_ENDPOINT);
    }

    private VersionInfo getOpenShiftV4VersionInfo() {
        return ((KubernetesResourceList)this.resources(ClusterVersion.class).list()).getItems().stream().findFirst().map(clusterVersion -> {
            String[] versionParts = clusterVersion.getStatus().getDesired().getVersion().split("\\.");
            VersionInfo.Builder versionInfoBuilder = new VersionInfo.Builder();
            if (versionParts.length > 2) {
                versionInfoBuilder.withMajor(versionParts[0]);
                versionInfoBuilder.withMinor(versionParts[1] + "." + versionParts[2]);
            }
            try {
                versionInfoBuilder.withBuildDate(clusterVersion.getMetadata().getCreationTimestamp());
            }
            catch (ParseException e) {
                return null;
            }
            return versionInfoBuilder.build();
        }).orElse(null);
    }

    @Override
    public String getOpenShiftV4Version() {
        return ((KubernetesResourceList)this.resources(ClusterVersion.class).list()).getItems().stream().findFirst().map(cv -> cv.getStatus().getDesired().getVersion()).orElse(null);
    }

    @Override
    public MachineConfigurationAPIGroupDSL machineConfigurations() {
        return this.adapt(OpenShiftMachineConfigurationAPIGroupClient.class);
    }

    @Override
    public OpenShiftMachineAPIGroupDSL machine() {
        return this.adapt(OpenShiftMachineAPIGroupClient.class);
    }

    @Override
    public OpenShiftMonitoringAPIGroupDSL monitoring() {
        return this.adapt(OpenShiftMonitoringAPIGroupClient.class);
    }

    @Override
    public NonNamespaceOperation<NetNamespace, NetNamespaceList, Resource<NetNamespace>> netNamespaces() {
        return OpenShiftHandlers.getOperation(NetNamespace.class, NetNamespaceList.class, this);
    }

    @Override
    public NonNamespaceOperation<ClusterNetwork, ClusterNetworkList, Resource<ClusterNetwork>> clusterNetworks() {
        return OpenShiftHandlers.getOperation(ClusterNetwork.class, ClusterNetworkList.class, this);
    }

    @Override
    public MixedOperation<EgressNetworkPolicy, EgressNetworkPolicyList, Resource<EgressNetworkPolicy>> egressNetworkPolicies() {
        return OpenShiftHandlers.getOperation(EgressNetworkPolicy.class, EgressNetworkPolicyList.class, this);
    }

    @Override
    public NonNamespaceOperation<HostSubnet, HostSubnetList, Resource<HostSubnet>> hostSubnets() {
        return OpenShiftHandlers.getOperation(HostSubnet.class, HostSubnetList.class, this);
    }

    @Override
    public NonNamespaceOperation<APIRequestCount, APIRequestCountList, Resource<APIRequestCount>> apiRequestCounts() {
        return OpenShiftHandlers.getOperation(APIRequestCount.class, APIRequestCountList.class, this);
    }

    @Override
    public MixedOperation<BareMetalHost, BareMetalHostList, Resource<BareMetalHost>> bareMetalHosts() {
        return OpenShiftHandlers.getOperation(BareMetalHost.class, BareMetalHostList.class, this);
    }

    @Override
    public InOutCreateable<SubjectAccessReview, SubjectAccessReviewResponse> subjectAccessReviews() {
        return OpenShiftHandlers.getCreateOnlyResourceOperation(SubjectAccessReview.class, SubjectAccessReviewResponse.class, this);
    }

    @Override
    public InOutCreateable<ResourceAccessReview, ResourceAccessReviewResponse> resourceAccessReviews() {
        return OpenShiftHandlers.getCreateOnlyResourceOperation(ResourceAccessReview.class, ResourceAccessReviewResponse.class, this);
    }

    @Override
    public NamespacedInOutCreateable<LocalSubjectAccessReview, SubjectAccessReviewResponse> localSubjectAccessReviews() {
        return OpenShiftHandlers.getCreateOnlyResourceOperation(LocalSubjectAccessReview.class, SubjectAccessReviewResponse.class, this);
    }

    @Override
    public NamespacedInOutCreateable<LocalResourceAccessReview, ResourceAccessReviewResponse> localResourceAccessReviews() {
        return OpenShiftHandlers.getCreateOnlyResourceOperation(LocalResourceAccessReview.class, ResourceAccessReviewResponse.class, this);
    }

    @Override
    public NamespacedInOutCreateable<SelfSubjectRulesReview, SelfSubjectRulesReview> selfSubjectRulesReviews() {
        return OpenShiftHandlers.getCreateOnlyResourceOperation(SelfSubjectRulesReview.class, SelfSubjectRulesReview.class, this);
    }

    @Override
    public NamespacedInOutCreateable<SubjectRulesReview, SubjectRulesReview> subjectRulesReviews() {
        return OpenShiftHandlers.getCreateOnlyResourceOperation(SubjectRulesReview.class, SubjectRulesReview.class, this);
    }

    @Override
    public OpenShiftStorageVersionMigratorApiGroupDSL kubeStorageVersionMigrator() {
        return this.adapt(OpenShiftStorageVersionMigratorApiGroupClient.class);
    }

    @Override
    public NonNamespaceOperation<ClusterRole, ClusterRoleList, Resource<ClusterRole>> clusterRoles() {
        return OpenShiftHandlers.getOperation(ClusterRole.class, ClusterRoleList.class, this);
    }

    public LeaderElectorBuilder<NamespacedOpenShiftClient> leaderElector() {
        return new LeaderElectorBuilder<NamespacedOpenShiftClient>(this);
    }

    @Override
    public FunctionCallable<NamespacedOpenShiftClient> withRequestConfig(RequestConfig requestConfig) {
        return new WithRequestCallable<NamespacedOpenShiftClient>(this, requestConfig);
    }

    @Override
    public User currentUser() {
        return (User)((Resource)this.users().withName("~")).get();
    }

    @Override
    public NonNamespaceOperation<Identity, IdentityList, Resource<Identity>> identities() {
        return OpenShiftHandlers.getOperation(Identity.class, IdentityList.class, this);
    }

    @Override
    public InOutCreateable<UserIdentityMapping, UserIdentityMapping> userIdentityMappings() {
        return Handlers.getNonListingOperation(UserIdentityMapping.class, this);
    }

    @Override
    public NonNamespaceOperation<UserOAuthAccessToken, UserOAuthAccessTokenList, Resource<UserOAuthAccessToken>> userOAuthAccessTokens() {
        return OpenShiftHandlers.getOperation(UserOAuthAccessToken.class, UserOAuthAccessTokenList.class, this);
    }

    @Override
    public OpenShiftWhereaboutsAPIGroupDSL whereabouts() {
        return this.adapt(OpenShiftWhereaboutsAPIGroupClient.class);
    }

    @Override
    public boolean supportsOpenShiftAPIGroup(String apiGroup) {
        List<String> paths;
        String apiGroupPath = "/apis/" + apiGroup;
        RootPaths rootPaths = this.rootPaths();
        if (rootPaths != null && (paths = rootPaths.getPaths()) != null) {
            for (String path : paths) {
                if (!Objects.equals("/oapi", path) && !Objects.equals("oapi", path) && !Objects.equals(apiGroupPath, path)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    protected void adaptState() {
        OpenShiftConfig wrapped = OpenShiftConfig.wrap(this.config);
        this.config = wrapped;
        this.httpClient = OpenshiftAdapterSupport.adaptHttpClient(this.httpClient, wrapped);
    }
}

