/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.v5_12.operator.v1;

import io.fabric8.kubernetes.api.builder.v5_12.VisitableBuilder;
import io.fabric8.openshift.api.model.v5_12.operator.v1.Config;
import io.fabric8.openshift.api.model.v5_12.operator.v1.ConfigFluent;
import io.fabric8.openshift.api.model.v5_12.operator.v1.ConfigFluentImpl;
import java.util.Objects;

public class ConfigBuilder
extends ConfigFluentImpl<ConfigBuilder>
implements VisitableBuilder<Config, ConfigBuilder> {
    ConfigFluent<?> fluent;
    Boolean validationEnabled;

    public ConfigBuilder() {
        this(false);
    }

    public ConfigBuilder(Boolean validationEnabled) {
        this(new Config(), validationEnabled);
    }

    public ConfigBuilder(ConfigFluent<?> fluent) {
        this(fluent, (Boolean)false);
    }

    public ConfigBuilder(ConfigFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new Config(), validationEnabled);
    }

    public ConfigBuilder(ConfigFluent<?> fluent, Config instance) {
        this(fluent, instance, false);
    }

    public ConfigBuilder(ConfigFluent<?> fluent, Config instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withApiVersion(instance.getApiVersion());
        fluent.withKind(instance.getKind());
        fluent.withMetadata(instance.getMetadata());
        fluent.withSpec(instance.getSpec());
        fluent.withStatus(instance.getStatus());
        fluent.withAdditionalProperties(instance.getAdditionalProperties());
        this.validationEnabled = validationEnabled;
    }

    public ConfigBuilder(Config instance) {
        this(instance, (Boolean)false);
    }

    public ConfigBuilder(Config instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withApiVersion(instance.getApiVersion());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
        this.withSpec(instance.getSpec());
        this.withStatus(instance.getStatus());
        this.withAdditionalProperties(instance.getAdditionalProperties());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public Config build() {
        Config buildable = new Config(this.fluent.getApiVersion(), this.fluent.getKind(), this.fluent.getMetadata(), this.fluent.getSpec(), this.fluent.getStatus());
        buildable.setAdditionalProperties(this.fluent.getAdditionalProperties());
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ConfigBuilder that = (ConfigBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.fluent, this.validationEnabled, super.hashCode());
    }
}

