/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.v5_12.installer.libvirt.v1;

import io.fabric8.kubernetes.api.builder.v5_12.BaseFluent;
import io.fabric8.kubernetes.api.builder.v5_12.Nested;
import io.fabric8.openshift.api.model.v5_12.installer.libvirt.v1.MachinePool;
import io.fabric8.openshift.api.model.v5_12.installer.libvirt.v1.MachinePoolBuilder;
import io.fabric8.openshift.api.model.v5_12.installer.libvirt.v1.MachinePoolFluentImpl;
import io.fabric8.openshift.api.model.v5_12.installer.libvirt.v1.Network;
import io.fabric8.openshift.api.model.v5_12.installer.libvirt.v1.NetworkBuilder;
import io.fabric8.openshift.api.model.v5_12.installer.libvirt.v1.NetworkFluentImpl;
import io.fabric8.openshift.api.model.v5_12.installer.libvirt.v1.Platform;
import io.fabric8.openshift.api.model.v5_12.installer.libvirt.v1.PlatformFluent;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;

public class PlatformFluentImpl<A extends PlatformFluent<A>>
extends BaseFluent<A>
implements PlatformFluent<A> {
    private String uri;
    private MachinePoolBuilder defaultMachinePlatform;
    private NetworkBuilder network;
    private Map<String, Object> additionalProperties;

    public PlatformFluentImpl() {
    }

    public PlatformFluentImpl(Platform instance) {
        this.withUri(instance.getUri());
        this.withDefaultMachinePlatform(instance.getDefaultMachinePlatform());
        this.withNetwork(instance.getNetwork());
        this.withAdditionalProperties(instance.getAdditionalProperties());
    }

    @Override
    public String getUri() {
        return this.uri;
    }

    @Override
    public A withUri(String uri) {
        this.uri = uri;
        return (A)this;
    }

    @Override
    public Boolean hasUri() {
        return this.uri != null;
    }

    @Override
    @Deprecated
    public A withNewUri(String arg0) {
        return this.withUri(new String(arg0));
    }

    @Override
    @Deprecated
    public MachinePool getDefaultMachinePlatform() {
        return this.defaultMachinePlatform != null ? this.defaultMachinePlatform.build() : null;
    }

    @Override
    public MachinePool buildDefaultMachinePlatform() {
        return this.defaultMachinePlatform != null ? this.defaultMachinePlatform.build() : null;
    }

    @Override
    public A withDefaultMachinePlatform(MachinePool defaultMachinePlatform) {
        this._visitables.get("defaultMachinePlatform").remove(this.defaultMachinePlatform);
        if (defaultMachinePlatform != null) {
            this.defaultMachinePlatform = new MachinePoolBuilder(defaultMachinePlatform);
            this._visitables.get("defaultMachinePlatform").add(this.defaultMachinePlatform);
        }
        return (A)this;
    }

    @Override
    public Boolean hasDefaultMachinePlatform() {
        return this.defaultMachinePlatform != null;
    }

    @Override
    public PlatformFluent.DefaultMachinePlatformNested<A> withNewDefaultMachinePlatform() {
        return new DefaultMachinePlatformNestedImpl();
    }

    @Override
    public PlatformFluent.DefaultMachinePlatformNested<A> withNewDefaultMachinePlatformLike(MachinePool item) {
        return new DefaultMachinePlatformNestedImpl(item);
    }

    @Override
    public PlatformFluent.DefaultMachinePlatformNested<A> editDefaultMachinePlatform() {
        return this.withNewDefaultMachinePlatformLike(this.getDefaultMachinePlatform());
    }

    @Override
    public PlatformFluent.DefaultMachinePlatformNested<A> editOrNewDefaultMachinePlatform() {
        return this.withNewDefaultMachinePlatformLike(this.getDefaultMachinePlatform() != null ? this.getDefaultMachinePlatform() : new MachinePoolBuilder().build());
    }

    @Override
    public PlatformFluent.DefaultMachinePlatformNested<A> editOrNewDefaultMachinePlatformLike(MachinePool item) {
        return this.withNewDefaultMachinePlatformLike(this.getDefaultMachinePlatform() != null ? this.getDefaultMachinePlatform() : item);
    }

    @Override
    @Deprecated
    public Network getNetwork() {
        return this.network != null ? this.network.build() : null;
    }

    @Override
    public Network buildNetwork() {
        return this.network != null ? this.network.build() : null;
    }

    @Override
    public A withNetwork(Network network) {
        this._visitables.get("network").remove(this.network);
        if (network != null) {
            this.network = new NetworkBuilder(network);
            this._visitables.get("network").add(this.network);
        }
        return (A)this;
    }

    @Override
    public Boolean hasNetwork() {
        return this.network != null;
    }

    @Override
    public PlatformFluent.NetworkNested<A> withNewNetwork() {
        return new NetworkNestedImpl();
    }

    @Override
    public PlatformFluent.NetworkNested<A> withNewNetworkLike(Network item) {
        return new NetworkNestedImpl(item);
    }

    @Override
    public PlatformFluent.NetworkNested<A> editNetwork() {
        return this.withNewNetworkLike(this.getNetwork());
    }

    @Override
    public PlatformFluent.NetworkNested<A> editOrNewNetwork() {
        return this.withNewNetworkLike(this.getNetwork() != null ? this.getNetwork() : new NetworkBuilder().build());
    }

    @Override
    public PlatformFluent.NetworkNested<A> editOrNewNetworkLike(Network item) {
        return this.withNewNetworkLike(this.getNetwork() != null ? this.getNetwork() : item);
    }

    @Override
    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    @Override
    public Boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PlatformFluentImpl that = (PlatformFluentImpl)o;
        if (this.uri != null ? !this.uri.equals(that.uri) : that.uri != null) {
            return false;
        }
        if (this.defaultMachinePlatform != null ? !this.defaultMachinePlatform.equals(that.defaultMachinePlatform) : that.defaultMachinePlatform != null) {
            return false;
        }
        if (this.network != null ? !this.network.equals(that.network) : that.network != null) {
            return false;
        }
        return !(this.additionalProperties != null ? !this.additionalProperties.equals(that.additionalProperties) : that.additionalProperties != null);
    }

    public int hashCode() {
        return Objects.hash(this.uri, this.defaultMachinePlatform, this.network, this.additionalProperties, super.hashCode());
    }

    public class NetworkNestedImpl<N>
    extends NetworkFluentImpl<PlatformFluent.NetworkNested<N>>
    implements PlatformFluent.NetworkNested<N>,
    Nested<N> {
        NetworkBuilder builder;

        NetworkNestedImpl(Network item) {
            this.builder = new NetworkBuilder(this, item);
        }

        NetworkNestedImpl() {
            this.builder = new NetworkBuilder(this);
        }

        @Override
        public N and() {
            return (N)PlatformFluentImpl.this.withNetwork(this.builder.build());
        }

        @Override
        public N endNetwork() {
            return this.and();
        }
    }

    public class DefaultMachinePlatformNestedImpl<N>
    extends MachinePoolFluentImpl<PlatformFluent.DefaultMachinePlatformNested<N>>
    implements PlatformFluent.DefaultMachinePlatformNested<N>,
    Nested<N> {
        MachinePoolBuilder builder;

        DefaultMachinePlatformNestedImpl(MachinePool item) {
            this.builder = new MachinePoolBuilder(this, item);
        }

        DefaultMachinePlatformNestedImpl() {
            this.builder = new MachinePoolBuilder(this);
        }

        @Override
        public N and() {
            return (N)PlatformFluentImpl.this.withDefaultMachinePlatform(this.builder.build());
        }

        @Override
        public N endDefaultMachinePlatform() {
            return this.and();
        }
    }
}

