/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.v5_12.installer.libvirt.v1;

import io.fabric8.kubernetes.api.builder.v5_12.BaseFluent;
import io.fabric8.kubernetes.api.builder.v5_12.Nested;
import io.fabric8.openshift.api.model.v5_12.installer.libvirt.v1.DnsmasqOption;
import io.fabric8.openshift.api.model.v5_12.installer.libvirt.v1.DnsmasqOptionBuilder;
import io.fabric8.openshift.api.model.v5_12.installer.libvirt.v1.DnsmasqOptionFluentImpl;
import io.fabric8.openshift.api.model.v5_12.installer.libvirt.v1.Network;
import io.fabric8.openshift.api.model.v5_12.installer.libvirt.v1.NetworkFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class NetworkFluentImpl<A extends NetworkFluent<A>>
extends BaseFluent<A>
implements NetworkFluent<A> {
    private List<DnsmasqOptionBuilder> dnsmasqOptions = new ArrayList<DnsmasqOptionBuilder>();
    private String _if;
    private Map<String, Object> additionalProperties;

    public NetworkFluentImpl() {
    }

    public NetworkFluentImpl(Network instance) {
        this.withDnsmasqOptions(instance.getDnsmasqOptions());
        this.withIf(instance.getIf());
        this.withAdditionalProperties(instance.getAdditionalProperties());
    }

    @Override
    public A addToDnsmasqOptions(Integer index, DnsmasqOption item) {
        if (this.dnsmasqOptions == null) {
            this.dnsmasqOptions = new ArrayList<DnsmasqOptionBuilder>();
        }
        DnsmasqOptionBuilder builder = new DnsmasqOptionBuilder(item);
        this._visitables.get("dnsmasqOptions").add(index >= 0 ? index.intValue() : this._visitables.get("dnsmasqOptions").size(), builder);
        this.dnsmasqOptions.add(index >= 0 ? index.intValue() : this.dnsmasqOptions.size(), builder);
        return (A)this;
    }

    @Override
    public A setToDnsmasqOptions(Integer index, DnsmasqOption item) {
        if (this.dnsmasqOptions == null) {
            this.dnsmasqOptions = new ArrayList<DnsmasqOptionBuilder>();
        }
        DnsmasqOptionBuilder builder = new DnsmasqOptionBuilder(item);
        if (index < 0 || index >= this._visitables.get("dnsmasqOptions").size()) {
            this._visitables.get("dnsmasqOptions").add(builder);
        } else {
            this._visitables.get("dnsmasqOptions").set(index, builder);
        }
        if (index < 0 || index >= this.dnsmasqOptions.size()) {
            this.dnsmasqOptions.add(builder);
        } else {
            this.dnsmasqOptions.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToDnsmasqOptions(DnsmasqOption ... items) {
        if (this.dnsmasqOptions == null) {
            this.dnsmasqOptions = new ArrayList<DnsmasqOptionBuilder>();
        }
        for (DnsmasqOption item : items) {
            DnsmasqOptionBuilder builder = new DnsmasqOptionBuilder(item);
            this._visitables.get("dnsmasqOptions").add(builder);
            this.dnsmasqOptions.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToDnsmasqOptions(Collection<DnsmasqOption> items) {
        if (this.dnsmasqOptions == null) {
            this.dnsmasqOptions = new ArrayList<DnsmasqOptionBuilder>();
        }
        for (DnsmasqOption item : items) {
            DnsmasqOptionBuilder builder = new DnsmasqOptionBuilder(item);
            this._visitables.get("dnsmasqOptions").add(builder);
            this.dnsmasqOptions.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromDnsmasqOptions(DnsmasqOption ... items) {
        for (DnsmasqOption item : items) {
            DnsmasqOptionBuilder builder = new DnsmasqOptionBuilder(item);
            this._visitables.get("dnsmasqOptions").remove(builder);
            if (this.dnsmasqOptions == null) continue;
            this.dnsmasqOptions.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromDnsmasqOptions(Collection<DnsmasqOption> items) {
        for (DnsmasqOption item : items) {
            DnsmasqOptionBuilder builder = new DnsmasqOptionBuilder(item);
            this._visitables.get("dnsmasqOptions").remove(builder);
            if (this.dnsmasqOptions == null) continue;
            this.dnsmasqOptions.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromDnsmasqOptions(Predicate<DnsmasqOptionBuilder> predicate) {
        if (this.dnsmasqOptions == null) {
            return (A)this;
        }
        Iterator<DnsmasqOptionBuilder> each = this.dnsmasqOptions.iterator();
        Object visitables = this._visitables.get("dnsmasqOptions");
        while (each.hasNext()) {
            DnsmasqOptionBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<DnsmasqOption> getDnsmasqOptions() {
        return NetworkFluentImpl.build(this.dnsmasqOptions);
    }

    @Override
    public List<DnsmasqOption> buildDnsmasqOptions() {
        return NetworkFluentImpl.build(this.dnsmasqOptions);
    }

    @Override
    public DnsmasqOption buildDnsmasqOption(Integer index) {
        return this.dnsmasqOptions.get(index).build();
    }

    @Override
    public DnsmasqOption buildFirstDnsmasqOption() {
        return this.dnsmasqOptions.get(0).build();
    }

    @Override
    public DnsmasqOption buildLastDnsmasqOption() {
        return this.dnsmasqOptions.get(this.dnsmasqOptions.size() - 1).build();
    }

    @Override
    public DnsmasqOption buildMatchingDnsmasqOption(Predicate<DnsmasqOptionBuilder> predicate) {
        for (DnsmasqOptionBuilder item : this.dnsmasqOptions) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingDnsmasqOption(Predicate<DnsmasqOptionBuilder> predicate) {
        for (DnsmasqOptionBuilder item : this.dnsmasqOptions) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withDnsmasqOptions(List<DnsmasqOption> dnsmasqOptions) {
        if (this.dnsmasqOptions != null) {
            this._visitables.get("dnsmasqOptions").removeAll(this.dnsmasqOptions);
        }
        if (dnsmasqOptions != null) {
            this.dnsmasqOptions = new ArrayList<DnsmasqOptionBuilder>();
            for (DnsmasqOption item : dnsmasqOptions) {
                this.addToDnsmasqOptions(item);
            }
        } else {
            this.dnsmasqOptions = null;
        }
        return (A)this;
    }

    @Override
    public A withDnsmasqOptions(DnsmasqOption ... dnsmasqOptions) {
        if (this.dnsmasqOptions != null) {
            this.dnsmasqOptions.clear();
        }
        if (dnsmasqOptions != null) {
            for (DnsmasqOption item : dnsmasqOptions) {
                this.addToDnsmasqOptions(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasDnsmasqOptions() {
        return this.dnsmasqOptions != null && !this.dnsmasqOptions.isEmpty();
    }

    @Override
    public A addNewDnsmasqOption(String name, String value) {
        return this.addToDnsmasqOptions(new DnsmasqOption(name, value));
    }

    @Override
    public NetworkFluent.DnsmasqOptionsNested<A> addNewDnsmasqOption() {
        return new DnsmasqOptionsNestedImpl();
    }

    @Override
    public NetworkFluent.DnsmasqOptionsNested<A> addNewDnsmasqOptionLike(DnsmasqOption item) {
        return new DnsmasqOptionsNestedImpl(-1, item);
    }

    @Override
    public NetworkFluent.DnsmasqOptionsNested<A> setNewDnsmasqOptionLike(Integer index, DnsmasqOption item) {
        return new DnsmasqOptionsNestedImpl(index, item);
    }

    @Override
    public NetworkFluent.DnsmasqOptionsNested<A> editDnsmasqOption(Integer index) {
        if (this.dnsmasqOptions.size() <= index) {
            throw new RuntimeException("Can't edit dnsmasqOptions. Index exceeds size.");
        }
        return this.setNewDnsmasqOptionLike(index, this.buildDnsmasqOption(index));
    }

    @Override
    public NetworkFluent.DnsmasqOptionsNested<A> editFirstDnsmasqOption() {
        if (this.dnsmasqOptions.size() == 0) {
            throw new RuntimeException("Can't edit first dnsmasqOptions. The list is empty.");
        }
        return this.setNewDnsmasqOptionLike(0, this.buildDnsmasqOption(0));
    }

    @Override
    public NetworkFluent.DnsmasqOptionsNested<A> editLastDnsmasqOption() {
        int index = this.dnsmasqOptions.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last dnsmasqOptions. The list is empty.");
        }
        return this.setNewDnsmasqOptionLike(index, this.buildDnsmasqOption(index));
    }

    @Override
    public NetworkFluent.DnsmasqOptionsNested<A> editMatchingDnsmasqOption(Predicate<DnsmasqOptionBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.dnsmasqOptions.size(); ++i) {
            if (!predicate.test(this.dnsmasqOptions.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching dnsmasqOptions. No match found.");
        }
        return this.setNewDnsmasqOptionLike(index, this.buildDnsmasqOption(index));
    }

    @Override
    public String getIf() {
        return this._if;
    }

    @Override
    public A withIf(String _if) {
        this._if = _if;
        return (A)this;
    }

    @Override
    public Boolean hasIf() {
        return this._if != null;
    }

    @Override
    @Deprecated
    public A withNewIf(String arg0) {
        return this.withIf(new String(arg0));
    }

    @Override
    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    @Override
    public Boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NetworkFluentImpl that = (NetworkFluentImpl)o;
        if (this.dnsmasqOptions != null ? !this.dnsmasqOptions.equals(that.dnsmasqOptions) : that.dnsmasqOptions != null) {
            return false;
        }
        if (this._if != null ? !this._if.equals(that._if) : that._if != null) {
            return false;
        }
        return !(this.additionalProperties != null ? !this.additionalProperties.equals(that.additionalProperties) : that.additionalProperties != null);
    }

    public int hashCode() {
        return Objects.hash(this.dnsmasqOptions, this._if, this.additionalProperties, super.hashCode());
    }

    public class DnsmasqOptionsNestedImpl<N>
    extends DnsmasqOptionFluentImpl<NetworkFluent.DnsmasqOptionsNested<N>>
    implements NetworkFluent.DnsmasqOptionsNested<N>,
    Nested<N> {
        DnsmasqOptionBuilder builder;
        Integer index;

        DnsmasqOptionsNestedImpl(Integer index, DnsmasqOption item) {
            this.index = index;
            this.builder = new DnsmasqOptionBuilder(this, item);
        }

        DnsmasqOptionsNestedImpl() {
            this.index = -1;
            this.builder = new DnsmasqOptionBuilder(this);
        }

        @Override
        public N and() {
            return (N)NetworkFluentImpl.this.setToDnsmasqOptions(this.index, this.builder.build());
        }

        @Override
        public N endDnsmasqOption() {
            return this.and();
        }
    }
}

