/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.clnt.v5_12.http;

public enum TlsVersion {
    TLS_1_3("TLSv1.3"),
    TLS_1_2("TLSv1.2"),
    TLS_1_1("TLSv1.1"),
    TLS_1_0("TLSv1"),
    SSL_3_0("SSLv3");

    final String javaName;

    private TlsVersion(String javaName) {
        this.javaName = javaName;
    }

    public static TlsVersion forJavaName(String string) {
        if (string.equals("SSLv3")) {
            return SSL_3_0;
        }
        if (string.equals("TLSv1")) {
            return TLS_1_0;
        }
        return TlsVersion.valueOf(string.replaceAll("[v.]", "_"));
    }

    public String javaName() {
        return this.javaName;
    }
}

