/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.clnt.v5_12;

import io.fabric8.kubernetes.api.model.v5_12.APIService;
import io.fabric8.kubernetes.api.model.v5_12.APIServiceList;
import io.fabric8.kubernetes.api.model.v5_12.Binding;
import io.fabric8.kubernetes.api.model.v5_12.ComponentStatus;
import io.fabric8.kubernetes.api.model.v5_12.ComponentStatusList;
import io.fabric8.kubernetes.api.model.v5_12.ConfigMap;
import io.fabric8.kubernetes.api.model.v5_12.ConfigMapList;
import io.fabric8.kubernetes.api.model.v5_12.Endpoints;
import io.fabric8.kubernetes.api.model.v5_12.EndpointsList;
import io.fabric8.kubernetes.api.model.v5_12.GenericKubernetesResource;
import io.fabric8.kubernetes.api.model.v5_12.GenericKubernetesResourceList;
import io.fabric8.kubernetes.api.model.v5_12.HasMetadata;
import io.fabric8.kubernetes.api.model.v5_12.KubernetesListBuilder;
import io.fabric8.kubernetes.api.model.v5_12.KubernetesResourceList;
import io.fabric8.kubernetes.api.model.v5_12.LimitRange;
import io.fabric8.kubernetes.api.model.v5_12.LimitRangeList;
import io.fabric8.kubernetes.api.model.v5_12.Namespace;
import io.fabric8.kubernetes.api.model.v5_12.NamespaceList;
import io.fabric8.kubernetes.api.model.v5_12.Node;
import io.fabric8.kubernetes.api.model.v5_12.NodeList;
import io.fabric8.kubernetes.api.model.v5_12.PersistentVolume;
import io.fabric8.kubernetes.api.model.v5_12.PersistentVolumeClaim;
import io.fabric8.kubernetes.api.model.v5_12.PersistentVolumeClaimList;
import io.fabric8.kubernetes.api.model.v5_12.PersistentVolumeList;
import io.fabric8.kubernetes.api.model.v5_12.Pod;
import io.fabric8.kubernetes.api.model.v5_12.PodList;
import io.fabric8.kubernetes.api.model.v5_12.ReplicationController;
import io.fabric8.kubernetes.api.model.v5_12.ReplicationControllerList;
import io.fabric8.kubernetes.api.model.v5_12.ResourceQuota;
import io.fabric8.kubernetes.api.model.v5_12.ResourceQuotaList;
import io.fabric8.kubernetes.api.model.v5_12.Secret;
import io.fabric8.kubernetes.api.model.v5_12.SecretList;
import io.fabric8.kubernetes.api.model.v5_12.Service;
import io.fabric8.kubernetes.api.model.v5_12.ServiceAccount;
import io.fabric8.kubernetes.api.model.v5_12.ServiceAccountList;
import io.fabric8.kubernetes.api.model.v5_12.ServiceList;
import io.fabric8.kubernetes.api.model.v5_12.apps.Deployment;
import io.fabric8.kubernetes.api.model.v5_12.apps.StatefulSet;
import io.fabric8.kubernetes.api.model.v5_12.authentication.TokenReview;
import io.fabric8.kubernetes.api.model.v5_12.batch.v1.Job;
import io.fabric8.kubernetes.api.model.v5_12.batch.v1beta1.CronJob;
import io.fabric8.kubernetes.api.model.v5_12.certificates.v1beta1.CertificateSigningRequest;
import io.fabric8.kubernetes.api.model.v5_12.certificates.v1beta1.CertificateSigningRequestList;
import io.fabric8.kubernetes.api.model.v5_12.coordination.v1.Lease;
import io.fabric8.kubernetes.api.model.v5_12.coordination.v1.LeaseList;
import io.fabric8.kubernetes.api.model.v5_12.extensions.ReplicaSet;
import io.fabric8.kubernetes.api.model.v5_12.node.v1beta1.RuntimeClass;
import io.fabric8.kubernetes.api.model.v5_12.node.v1beta1.RuntimeClassList;
import io.fabric8.kubernetes.clnt.v5_12.Adapters;
import io.fabric8.kubernetes.clnt.v5_12.AdmissionRegistrationAPIGroupClient;
import io.fabric8.kubernetes.clnt.v5_12.AdmissionRegistrationAPIGroupDSL;
import io.fabric8.kubernetes.clnt.v5_12.ApiextensionsAPIGroupClient;
import io.fabric8.kubernetes.clnt.v5_12.AppsAPIGroupClient;
import io.fabric8.kubernetes.clnt.v5_12.AuthorizationAPIGroupClient;
import io.fabric8.kubernetes.clnt.v5_12.AutoscalingAPIGroupClient;
import io.fabric8.kubernetes.clnt.v5_12.BaseClient;
import io.fabric8.kubernetes.clnt.v5_12.BatchAPIGroupClient;
import io.fabric8.kubernetes.clnt.v5_12.CertificatesAPIGroupClient;
import io.fabric8.kubernetes.clnt.v5_12.Client;
import io.fabric8.kubernetes.clnt.v5_12.ClientContext;
import io.fabric8.kubernetes.clnt.v5_12.Config;
import io.fabric8.kubernetes.clnt.v5_12.CustomResource;
import io.fabric8.kubernetes.clnt.v5_12.DiscoveryAPIGroupClient;
import io.fabric8.kubernetes.clnt.v5_12.EventingAPIGroupClient;
import io.fabric8.kubernetes.clnt.v5_12.ExtensionsAPIGroupClient;
import io.fabric8.kubernetes.clnt.v5_12.FlowControlAPIGroupClient;
import io.fabric8.kubernetes.clnt.v5_12.GenericKubernetesClient;
import io.fabric8.kubernetes.clnt.v5_12.Handlers;
import io.fabric8.kubernetes.clnt.v5_12.KubernetesClientException;
import io.fabric8.kubernetes.clnt.v5_12.MetricAPIGroupClient;
import io.fabric8.kubernetes.clnt.v5_12.NetworkAPIGroupClient;
import io.fabric8.kubernetes.clnt.v5_12.PolicyAPIGroupClient;
import io.fabric8.kubernetes.clnt.v5_12.RbacAPIGroupClient;
import io.fabric8.kubernetes.clnt.v5_12.SchedulingAPIGroupClient;
import io.fabric8.kubernetes.clnt.v5_12.StorageAPIGroupClient;
import io.fabric8.kubernetes.clnt.v5_12.V1APIGroupClient;
import io.fabric8.kubernetes.clnt.v5_12.VersionInfo;
import io.fabric8.kubernetes.clnt.v5_12.dsl.ApiextensionsAPIGroupDSL;
import io.fabric8.kubernetes.clnt.v5_12.dsl.AppsAPIGroupDSL;
import io.fabric8.kubernetes.clnt.v5_12.dsl.AuthorizationAPIGroupDSL;
import io.fabric8.kubernetes.clnt.v5_12.dsl.AutoscalingAPIGroupDSL;
import io.fabric8.kubernetes.clnt.v5_12.dsl.BatchAPIGroupDSL;
import io.fabric8.kubernetes.clnt.v5_12.dsl.CertificatesAPIGroupDSL;
import io.fabric8.kubernetes.clnt.v5_12.dsl.DiscoveryAPIGroupDSL;
import io.fabric8.kubernetes.clnt.v5_12.dsl.EventingAPIGroupDSL;
import io.fabric8.kubernetes.clnt.v5_12.dsl.ExtensionsAPIGroupDSL;
import io.fabric8.kubernetes.clnt.v5_12.dsl.FlowControlAPIGroupDSL;
import io.fabric8.kubernetes.clnt.v5_12.dsl.InOutCreateable;
import io.fabric8.kubernetes.clnt.v5_12.dsl.KubernetesListMixedOperation;
import io.fabric8.kubernetes.clnt.v5_12.dsl.MetricAPIGroupDSL;
import io.fabric8.kubernetes.clnt.v5_12.dsl.MixedOperation;
import io.fabric8.kubernetes.clnt.v5_12.dsl.NamespaceListVisitFromServerGetDeleteRecreateWaitApplicable;
import io.fabric8.kubernetes.clnt.v5_12.dsl.NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicable;
import io.fabric8.kubernetes.clnt.v5_12.dsl.NetworkAPIGroupDSL;
import io.fabric8.kubernetes.clnt.v5_12.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.clnt.v5_12.dsl.ParameterNamespaceListVisitFromServerGetDeleteRecreateWaitApplicable;
import io.fabric8.kubernetes.clnt.v5_12.dsl.PodResource;
import io.fabric8.kubernetes.clnt.v5_12.dsl.PolicyAPIGroupDSL;
import io.fabric8.kubernetes.clnt.v5_12.dsl.RbacAPIGroupDSL;
import io.fabric8.kubernetes.clnt.v5_12.dsl.Resource;
import io.fabric8.kubernetes.clnt.v5_12.dsl.RollableScalableResource;
import io.fabric8.kubernetes.clnt.v5_12.dsl.SchedulingAPIGroupDSL;
import io.fabric8.kubernetes.clnt.v5_12.dsl.ServiceResource;
import io.fabric8.kubernetes.clnt.v5_12.dsl.StorageAPIGroupDSL;
import io.fabric8.kubernetes.clnt.v5_12.dsl.V1APIGroupDSL;
import io.fabric8.kubernetes.clnt.v5_12.dsl.base.CustomResourceDefinitionContext;
import io.fabric8.kubernetes.clnt.v5_12.dsl.base.HasMetadataOperation;
import io.fabric8.kubernetes.clnt.v5_12.dsl.base.ResourceDefinitionContext;
import io.fabric8.kubernetes.clnt.v5_12.dsl.internal.HasMetadataOperationsImpl;
import io.fabric8.kubernetes.clnt.v5_12.dsl.internal.KubernetesListOperationsImpl;
import io.fabric8.kubernetes.clnt.v5_12.dsl.internal.NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicableImpl;
import io.fabric8.kubernetes.clnt.v5_12.dsl.internal.NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicableListImpl;
import io.fabric8.kubernetes.clnt.v5_12.dsl.internal.RawCustomResourceOperationsImpl;
import io.fabric8.kubernetes.clnt.v5_12.dsl.internal.apps.v1.DeploymentOperationsImpl;
import io.fabric8.kubernetes.clnt.v5_12.dsl.internal.apps.v1.StatefulSetOperationsImpl;
import io.fabric8.kubernetes.clnt.v5_12.dsl.internal.batch.v1.JobOperationsImpl;
import io.fabric8.kubernetes.clnt.v5_12.dsl.internal.batch.v1beta1.CronJobOperationsImpl;
import io.fabric8.kubernetes.clnt.v5_12.dsl.internal.certificates.v1.CertificateSigningRequestOperationsImpl;
import io.fabric8.kubernetes.clnt.v5_12.dsl.internal.core.v1.BindingOperationsImpl;
import io.fabric8.kubernetes.clnt.v5_12.dsl.internal.core.v1.ComponentStatusOperationsImpl;
import io.fabric8.kubernetes.clnt.v5_12.dsl.internal.core.v1.PodOperationsImpl;
import io.fabric8.kubernetes.clnt.v5_12.dsl.internal.core.v1.ReplicationControllerOperationsImpl;
import io.fabric8.kubernetes.clnt.v5_12.dsl.internal.core.v1.ServiceOperationsImpl;
import io.fabric8.kubernetes.clnt.v5_12.dsl.internal.extensions.v1beta1.ReplicaSetOperationsImpl;
import io.fabric8.kubernetes.clnt.v5_12.extended.run.RunConfigBuilder;
import io.fabric8.kubernetes.clnt.v5_12.extended.run.RunOperations;
import io.fabric8.kubernetes.clnt.v5_12.http.HttpClient;
import io.fabric8.kubernetes.clnt.v5_12.informers.SharedInformerFactory;
import io.fabric8.kubernetes.clnt.v5_12.utils.Serialization;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.ExecutorService;

public abstract class BaseKubernetesClient<C extends Client>
extends BaseClient
implements GenericKubernetesClient<C> {
    public static final String KUBERNETES_VERSION_ENDPOINT = "version";

    protected BaseKubernetesClient() {
    }

    protected BaseKubernetesClient(String masterUrl) {
        super(masterUrl);
    }

    protected BaseKubernetesClient(Config config) {
        super(config);
    }

    protected BaseKubernetesClient(HttpClient httpClient, Config config) {
        super(httpClient, config);
    }

    protected BaseKubernetesClient(ClientContext clientContext) {
        super(clientContext);
    }

    @Override
    public NonNamespaceOperation<ComponentStatus, ComponentStatusList, Resource<ComponentStatus>> componentstatuses() {
        return new ComponentStatusOperationsImpl(this);
    }

    @Override
    public ParameterNamespaceListVisitFromServerGetDeleteRecreateWaitApplicable<HasMetadata> load(InputStream is) {
        return this.resourceListFor(is);
    }

    @Override
    public NamespaceListVisitFromServerGetDeleteRecreateWaitApplicable<HasMetadata> resourceList(KubernetesResourceList item) {
        return this.resourceListFor(item);
    }

    public NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicableListImpl resourceListFor(Object item) {
        return new NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicableListImpl(this, item);
    }

    @Override
    public NamespaceListVisitFromServerGetDeleteRecreateWaitApplicable<HasMetadata> resourceList(HasMetadata ... items) {
        return this.resourceList(((KubernetesListBuilder)new KubernetesListBuilder().withItems(items)).build());
    }

    @Override
    public NamespaceListVisitFromServerGetDeleteRecreateWaitApplicable<HasMetadata> resourceList(Collection<HasMetadata> items) {
        return this.resourceList(((KubernetesListBuilder)new KubernetesListBuilder().withItems(new ArrayList<HasMetadata>(items))).build());
    }

    @Override
    public ParameterNamespaceListVisitFromServerGetDeleteRecreateWaitApplicable<HasMetadata> resourceList(String s) {
        return this.resourceListFor(s);
    }

    public NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicable<HasMetadata> resource(HasMetadata item) {
        return new NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicableImpl(this, item);
    }

    @Override
    public NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicable<HasMetadata> resource(String s) {
        return this.resource((HasMetadata)Serialization.unmarshal(s));
    }

    @Override
    public MixedOperation<Binding, KubernetesResourceList<Binding>, Resource<Binding>> bindings() {
        return new BindingOperationsImpl(this);
    }

    @Override
    public MixedOperation<Endpoints, EndpointsList, Resource<Endpoints>> endpoints() {
        return Handlers.getOperation(Endpoints.class, EndpointsList.class, this);
    }

    @Override
    public NonNamespaceOperation<Namespace, NamespaceList, Resource<Namespace>> namespaces() {
        return Handlers.getOperation(Namespace.class, NamespaceList.class, this);
    }

    @Override
    public NonNamespaceOperation<Node, NodeList, Resource<Node>> nodes() {
        return Handlers.getOperation(Node.class, NodeList.class, this);
    }

    @Override
    public NonNamespaceOperation<PersistentVolume, PersistentVolumeList, Resource<PersistentVolume>> persistentVolumes() {
        return Handlers.getOperation(PersistentVolume.class, PersistentVolumeList.class, this);
    }

    @Override
    public MixedOperation<PersistentVolumeClaim, PersistentVolumeClaimList, Resource<PersistentVolumeClaim>> persistentVolumeClaims() {
        return Handlers.getOperation(PersistentVolumeClaim.class, PersistentVolumeClaimList.class, this);
    }

    @Override
    public MixedOperation<Pod, PodList, PodResource<Pod>> pods() {
        return new PodOperationsImpl(this);
    }

    @Override
    public MixedOperation<ReplicationController, ReplicationControllerList, RollableScalableResource<ReplicationController>> replicationControllers() {
        return new ReplicationControllerOperationsImpl(this);
    }

    @Override
    public MixedOperation<ResourceQuota, ResourceQuotaList, Resource<ResourceQuota>> resourceQuotas() {
        return Handlers.getOperation(ResourceQuota.class, ResourceQuotaList.class, this);
    }

    @Override
    public SchedulingAPIGroupDSL scheduling() {
        return this.adapt(SchedulingAPIGroupClient.class);
    }

    @Override
    public MixedOperation<Secret, SecretList, Resource<Secret>> secrets() {
        return Handlers.getOperation(Secret.class, SecretList.class, this);
    }

    @Override
    public MixedOperation<Service, ServiceList, ServiceResource<Service>> services() {
        return new ServiceOperationsImpl(this);
    }

    @Override
    public MixedOperation<ServiceAccount, ServiceAccountList, Resource<ServiceAccount>> serviceAccounts() {
        return Handlers.getOperation(ServiceAccount.class, ServiceAccountList.class, this);
    }

    @Override
    public NonNamespaceOperation<APIService, APIServiceList, Resource<APIService>> apiServices() {
        return Handlers.getOperation(APIService.class, APIServiceList.class, this);
    }

    @Override
    public KubernetesListMixedOperation lists() {
        return new KubernetesListOperationsImpl(this);
    }

    @Override
    public MixedOperation<ConfigMap, ConfigMapList, Resource<ConfigMap>> configMaps() {
        return Handlers.getOperation(ConfigMap.class, ConfigMapList.class, this);
    }

    @Override
    public MixedOperation<LimitRange, LimitRangeList, Resource<LimitRange>> limitRanges() {
        return Handlers.getOperation(LimitRange.class, LimitRangeList.class, this);
    }

    @Override
    public ApiextensionsAPIGroupDSL apiextensions() {
        return this.adapt(ApiextensionsAPIGroupClient.class);
    }

    @Override
    public NonNamespaceOperation<CertificateSigningRequest, CertificateSigningRequestList, Resource<CertificateSigningRequest>> certificateSigningRequests() {
        return Handlers.getOperation(CertificateSigningRequest.class, CertificateSigningRequestList.class, this);
    }

    @Override
    public CertificatesAPIGroupDSL certificates() {
        return this.adapt(CertificatesAPIGroupClient.class);
    }

    @Override
    public AuthorizationAPIGroupDSL authorization() {
        return this.adapt(AuthorizationAPIGroupClient.class);
    }

    @Override
    public InOutCreateable<TokenReview, TokenReview> tokenReviews() {
        return Handlers.getNonListingOperation(TokenReview.class, this);
    }

    @Override
    public <T extends CustomResource> MixedOperation<T, KubernetesResourceList<T>, Resource<T>> customResources(Class<T> resourceType) {
        return this.customResources(resourceType, null);
    }

    @Override
    public <T extends CustomResource, L extends KubernetesResourceList<T>> MixedOperation<T, L, Resource<T>> customResources(Class<T> resourceType, Class<L> listClass) {
        return this.customResources((ResourceDefinitionContext)CustomResourceDefinitionContext.fromCustomResourceType(resourceType), (Class)resourceType, (Class)listClass);
    }

    @Override
    public MixedOperation<GenericKubernetesResource, GenericKubernetesResourceList, Resource<GenericKubernetesResource>> genericKubernetesResources(String apiVersion, String kind) {
        ResourceDefinitionContext context = Handlers.getResourceDefinitionContext(apiVersion, kind, this);
        if (context == null) {
            throw new KubernetesClientException("Could not find the metadata for the given apiVersion and kind, please pass a ResourceDefinitionContext instead");
        }
        return this.genericKubernetesResources(context);
    }

    public <T extends HasMetadata, L extends KubernetesResourceList<T>> HasMetadataOperation<T, L, Resource<T>> resources(Class<T> resourceType, Class<L> listClass) {
        try {
            return Handlers.getOperation(resourceType, listClass, this);
        }
        catch (Exception e) {
            return this.customResources(ResourceDefinitionContext.fromResourceType(resourceType), (Class)resourceType, (Class)listClass);
        }
    }

    public <T extends HasMetadata, L extends KubernetesResourceList<T>> HasMetadataOperationsImpl<T, L> customResources(ResourceDefinitionContext rdContext, Class<T> resourceType, Class<L> listClass) {
        return new HasMetadataOperationsImpl<T, L>(this, rdContext, resourceType, listClass);
    }

    @Override
    public RawCustomResourceOperationsImpl customResource(CustomResourceDefinitionContext customResourceDefinition) {
        return new RawCustomResourceOperationsImpl(this, customResourceDefinition);
    }

    @Override
    public DiscoveryAPIGroupDSL discovery() {
        return this.adapt(DiscoveryAPIGroupClient.class);
    }

    @Override
    public EventingAPIGroupDSL events() {
        return this.adapt(EventingAPIGroupClient.class);
    }

    @Override
    public C inAnyNamespace() {
        return (C)((Client)this.inNamespace(null));
    }

    @Override
    public ExtensionsAPIGroupDSL extensions() {
        return this.adapt(ExtensionsAPIGroupClient.class);
    }

    @Override
    public FlowControlAPIGroupDSL flowControl() {
        return this.adapt(FlowControlAPIGroupClient.class);
    }

    @Override
    public VersionInfo getVersion() {
        return this.getVersionInfo(KUBERNETES_VERSION_ENDPOINT);
    }

    @Override
    public VersionInfo getKubernetesVersion() {
        return this.getVersionInfo(KUBERNETES_VERSION_ENDPOINT);
    }

    @Override
    public V1APIGroupDSL v1() {
        return this.adapt(V1APIGroupClient.class);
    }

    @Override
    public AdmissionRegistrationAPIGroupDSL admissionRegistration() {
        return this.adapt(AdmissionRegistrationAPIGroupClient.class);
    }

    @Override
    public AppsAPIGroupDSL apps() {
        return this.adapt(AppsAPIGroupClient.class);
    }

    @Override
    public AutoscalingAPIGroupDSL autoscaling() {
        return this.adapt(AutoscalingAPIGroupClient.class);
    }

    @Override
    public NetworkAPIGroupDSL network() {
        return this.adapt(NetworkAPIGroupClient.class);
    }

    @Override
    public StorageAPIGroupDSL storage() {
        return this.adapt(StorageAPIGroupClient.class);
    }

    @Override
    public BatchAPIGroupDSL batch() {
        return this.adapt(BatchAPIGroupClient.class);
    }

    @Override
    public MetricAPIGroupDSL top() {
        return this.adapt(MetricAPIGroupClient.class);
    }

    @Override
    public PolicyAPIGroupDSL policy() {
        return this.adapt(PolicyAPIGroupClient.class);
    }

    @Override
    public RbacAPIGroupDSL rbac() {
        return this.adapt(RbacAPIGroupClient.class);
    }

    @Override
    public SharedInformerFactory informers() {
        return new SharedInformerFactory(this);
    }

    @Override
    public SharedInformerFactory informers(ExecutorService executorService) {
        return new SharedInformerFactory(this, executorService);
    }

    @Override
    public MixedOperation<Lease, LeaseList, Resource<Lease>> leases() {
        return Handlers.getOperation(Lease.class, LeaseList.class, this);
    }

    @Override
    public RunOperations run() {
        return new RunOperations(this, this.getNamespace(), new RunConfigBuilder());
    }

    @Override
    public NonNamespaceOperation<RuntimeClass, RuntimeClassList, Resource<RuntimeClass>> runtimeClasses() {
        return Handlers.getOperation(RuntimeClass.class, RuntimeClassList.class, this);
    }

    static {
        Handlers.register(Pod.class, PodOperationsImpl::new);
        Handlers.register(Job.class, JobOperationsImpl::new);
        Handlers.register(CronJob.class, CronJobOperationsImpl::new);
        Handlers.register(Binding.class, BindingOperationsImpl::new);
        Handlers.register(ComponentStatus.class, ComponentStatusOperationsImpl::new);
        Handlers.register(Service.class, ServiceOperationsImpl::new);
        Handlers.register(Deployment.class, DeploymentOperationsImpl::new);
        Handlers.register(io.fabric8.kubernetes.api.model.v5_12.extensions.Deployment.class, io.fabric8.kubernetes.clnt.v5_12.dsl.internal.extensions.v1beta1.DeploymentOperationsImpl::new);
        Handlers.register(io.fabric8.kubernetes.api.model.v5_12.apps.ReplicaSet.class, io.fabric8.kubernetes.clnt.v5_12.dsl.internal.apps.v1.ReplicaSetOperationsImpl::new);
        Handlers.register(ReplicaSet.class, ReplicaSetOperationsImpl::new);
        Handlers.register(ReplicationController.class, ReplicationControllerOperationsImpl::new);
        Handlers.register(StatefulSet.class, StatefulSetOperationsImpl::new);
        Handlers.register(io.fabric8.kubernetes.api.model.v5_12.certificates.v1.CertificateSigningRequest.class, CertificateSigningRequestOperationsImpl::new);
        Adapters.list(Client.class);
    }
}

