/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v5_12.rbac;

import io.fabric8.kubernetes.api.builder.v5_12.VisitableBuilder;
import io.fabric8.kubernetes.api.model.v5_12.rbac.Subject;
import io.fabric8.kubernetes.api.model.v5_12.rbac.SubjectFluent;
import io.fabric8.kubernetes.api.model.v5_12.rbac.SubjectFluentImpl;
import java.util.Objects;

public class SubjectBuilder
extends SubjectFluentImpl<SubjectBuilder>
implements VisitableBuilder<Subject, SubjectBuilder> {
    SubjectFluent<?> fluent;
    Boolean validationEnabled;

    public SubjectBuilder() {
        this(false);
    }

    public SubjectBuilder(Boolean validationEnabled) {
        this(new Subject(), validationEnabled);
    }

    public SubjectBuilder(SubjectFluent<?> fluent) {
        this(fluent, (Boolean)false);
    }

    public SubjectBuilder(SubjectFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new Subject(), validationEnabled);
    }

    public SubjectBuilder(SubjectFluent<?> fluent, Subject instance) {
        this(fluent, instance, false);
    }

    public SubjectBuilder(SubjectFluent<?> fluent, Subject instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withApiGroup(instance.getApiGroup());
        fluent.withKind(instance.getKind());
        fluent.withName(instance.getName());
        fluent.withNamespace(instance.getNamespace());
        fluent.withAdditionalProperties(instance.getAdditionalProperties());
        this.validationEnabled = validationEnabled;
    }

    public SubjectBuilder(Subject instance) {
        this(instance, (Boolean)false);
    }

    public SubjectBuilder(Subject instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withApiGroup(instance.getApiGroup());
        this.withKind(instance.getKind());
        this.withName(instance.getName());
        this.withNamespace(instance.getNamespace());
        this.withAdditionalProperties(instance.getAdditionalProperties());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public Subject build() {
        Subject buildable = new Subject(this.fluent.getApiGroup(), this.fluent.getKind(), this.fluent.getName(), this.fluent.getNamespace());
        buildable.setAdditionalProperties(this.fluent.getAdditionalProperties());
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SubjectBuilder that = (SubjectBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.fluent, this.validationEnabled, super.hashCode());
    }
}

