/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v5_12.authentication;

import io.fabric8.kubernetes.api.builder.v5_12.BaseFluent;
import io.fabric8.kubernetes.api.model.v5_12.authentication.TokenReviewSpec;
import io.fabric8.kubernetes.api.model.v5_12.authentication.TokenReviewSpecFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class TokenReviewSpecFluentImpl<A extends TokenReviewSpecFluent<A>>
extends BaseFluent<A>
implements TokenReviewSpecFluent<A> {
    private List<String> audiences = new ArrayList<String>();
    private String token;
    private Map<String, Object> additionalProperties;

    public TokenReviewSpecFluentImpl() {
    }

    public TokenReviewSpecFluentImpl(TokenReviewSpec instance) {
        this.withAudiences(instance.getAudiences());
        this.withToken(instance.getToken());
        this.withAdditionalProperties(instance.getAdditionalProperties());
    }

    @Override
    public A addToAudiences(Integer index, String item) {
        if (this.audiences == null) {
            this.audiences = new ArrayList<String>();
        }
        this.audiences.add(index, item);
        return (A)this;
    }

    @Override
    public A setToAudiences(Integer index, String item) {
        if (this.audiences == null) {
            this.audiences = new ArrayList<String>();
        }
        this.audiences.set(index, item);
        return (A)this;
    }

    @Override
    public A addToAudiences(String ... items) {
        if (this.audiences == null) {
            this.audiences = new ArrayList<String>();
        }
        for (String item : items) {
            this.audiences.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToAudiences(Collection<String> items) {
        if (this.audiences == null) {
            this.audiences = new ArrayList<String>();
        }
        for (String item : items) {
            this.audiences.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromAudiences(String ... items) {
        for (String item : items) {
            if (this.audiences == null) continue;
            this.audiences.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromAudiences(Collection<String> items) {
        for (String item : items) {
            if (this.audiences == null) continue;
            this.audiences.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getAudiences() {
        return this.audiences;
    }

    @Override
    public String getAudience(Integer index) {
        return this.audiences.get(index);
    }

    @Override
    public String getFirstAudience() {
        return this.audiences.get(0);
    }

    @Override
    public String getLastAudience() {
        return this.audiences.get(this.audiences.size() - 1);
    }

    @Override
    public String getMatchingAudience(Predicate<String> predicate) {
        for (String item : this.audiences) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingAudience(Predicate<String> predicate) {
        for (String item : this.audiences) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withAudiences(List<String> audiences) {
        if (audiences != null) {
            this.audiences = new ArrayList<String>();
            for (String item : audiences) {
                this.addToAudiences(item);
            }
        } else {
            this.audiences = null;
        }
        return (A)this;
    }

    @Override
    public A withAudiences(String ... audiences) {
        if (this.audiences != null) {
            this.audiences.clear();
        }
        if (audiences != null) {
            for (String item : audiences) {
                this.addToAudiences(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasAudiences() {
        return this.audiences != null && !this.audiences.isEmpty();
    }

    @Override
    public A addNewAudience(String arg0) {
        return this.addToAudiences(new String(arg0));
    }

    @Override
    public String getToken() {
        return this.token;
    }

    @Override
    public A withToken(String token) {
        this.token = token;
        return (A)this;
    }

    @Override
    public Boolean hasToken() {
        return this.token != null;
    }

    @Override
    @Deprecated
    public A withNewToken(String arg0) {
        return this.withToken(new String(arg0));
    }

    @Override
    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    @Override
    public Boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TokenReviewSpecFluentImpl that = (TokenReviewSpecFluentImpl)o;
        if (this.audiences != null ? !this.audiences.equals(that.audiences) : that.audiences != null) {
            return false;
        }
        if (this.token != null ? !this.token.equals(that.token) : that.token != null) {
            return false;
        }
        return !(this.additionalProperties != null ? !this.additionalProperties.equals(that.additionalProperties) : that.additionalProperties != null);
    }

    public int hashCode() {
        return Objects.hash(this.audiences, this.token, this.additionalProperties, super.hashCode());
    }
}

