/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v5_12;

import io.fabric8.kubernetes.api.builder.v5_12.VisitableBuilder;
import io.fabric8.kubernetes.api.model.v5_12.NamedContext;
import io.fabric8.kubernetes.api.model.v5_12.NamedContextFluent;
import io.fabric8.kubernetes.api.model.v5_12.NamedContextFluentImpl;
import java.util.Objects;

public class NamedContextBuilder
extends NamedContextFluentImpl<NamedContextBuilder>
implements VisitableBuilder<NamedContext, NamedContextBuilder> {
    NamedContextFluent<?> fluent;
    Boolean validationEnabled;

    public NamedContextBuilder() {
        this(false);
    }

    public NamedContextBuilder(Boolean validationEnabled) {
        this(new NamedContext(), validationEnabled);
    }

    public NamedContextBuilder(NamedContextFluent<?> fluent) {
        this(fluent, (Boolean)false);
    }

    public NamedContextBuilder(NamedContextFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new NamedContext(), validationEnabled);
    }

    public NamedContextBuilder(NamedContextFluent<?> fluent, NamedContext instance) {
        this(fluent, instance, false);
    }

    public NamedContextBuilder(NamedContextFluent<?> fluent, NamedContext instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withContext(instance.getContext());
        fluent.withName(instance.getName());
        fluent.withAdditionalProperties(instance.getAdditionalProperties());
        this.validationEnabled = validationEnabled;
    }

    public NamedContextBuilder(NamedContext instance) {
        this(instance, (Boolean)false);
    }

    public NamedContextBuilder(NamedContext instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withContext(instance.getContext());
        this.withName(instance.getName());
        this.withAdditionalProperties(instance.getAdditionalProperties());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public NamedContext build() {
        NamedContext buildable = new NamedContext(this.fluent.getContext(), this.fluent.getName());
        buildable.setAdditionalProperties(this.fluent.getAdditionalProperties());
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        NamedContextBuilder that = (NamedContextBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.fluent, this.validationEnabled, super.hashCode());
    }
}

