/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v5_12;

import io.fabric8.kubernetes.api.builder.v5_12.BaseFluent;
import io.fabric8.kubernetes.api.builder.v5_12.Nested;
import io.fabric8.kubernetes.api.model.v5_12.APIServiceSpec;
import io.fabric8.kubernetes.api.model.v5_12.APIServiceSpecFluent;
import io.fabric8.kubernetes.api.model.v5_12.ServiceReference;
import io.fabric8.kubernetes.api.model.v5_12.ServiceReferenceBuilder;
import io.fabric8.kubernetes.api.model.v5_12.ServiceReferenceFluentImpl;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;

public class APIServiceSpecFluentImpl<A extends APIServiceSpecFluent<A>>
extends BaseFluent<A>
implements APIServiceSpecFluent<A> {
    private String caBundle;
    private String group;
    private Integer groupPriorityMinimum;
    private Boolean insecureSkipTLSVerify;
    private ServiceReferenceBuilder service;
    private String version;
    private Integer versionPriority;
    private Map<String, Object> additionalProperties;

    public APIServiceSpecFluentImpl() {
    }

    public APIServiceSpecFluentImpl(APIServiceSpec instance) {
        this.withCaBundle(instance.getCaBundle());
        this.withGroup(instance.getGroup());
        this.withGroupPriorityMinimum(instance.getGroupPriorityMinimum());
        this.withInsecureSkipTLSVerify(instance.getInsecureSkipTLSVerify());
        this.withService(instance.getService());
        this.withVersion(instance.getVersion());
        this.withVersionPriority(instance.getVersionPriority());
        this.withAdditionalProperties(instance.getAdditionalProperties());
    }

    @Override
    public String getCaBundle() {
        return this.caBundle;
    }

    @Override
    public A withCaBundle(String caBundle) {
        this.caBundle = caBundle;
        return (A)this;
    }

    @Override
    public Boolean hasCaBundle() {
        return this.caBundle != null;
    }

    @Override
    @Deprecated
    public A withNewCaBundle(String arg0) {
        return this.withCaBundle(new String(arg0));
    }

    @Override
    public String getGroup() {
        return this.group;
    }

    @Override
    public A withGroup(String group) {
        this.group = group;
        return (A)this;
    }

    @Override
    public Boolean hasGroup() {
        return this.group != null;
    }

    @Override
    @Deprecated
    public A withNewGroup(String arg0) {
        return this.withGroup(new String(arg0));
    }

    @Override
    public Integer getGroupPriorityMinimum() {
        return this.groupPriorityMinimum;
    }

    @Override
    public A withGroupPriorityMinimum(Integer groupPriorityMinimum) {
        this.groupPriorityMinimum = groupPriorityMinimum;
        return (A)this;
    }

    @Override
    public Boolean hasGroupPriorityMinimum() {
        return this.groupPriorityMinimum != null;
    }

    @Override
    public Boolean getInsecureSkipTLSVerify() {
        return this.insecureSkipTLSVerify;
    }

    @Override
    public A withInsecureSkipTLSVerify(Boolean insecureSkipTLSVerify) {
        this.insecureSkipTLSVerify = insecureSkipTLSVerify;
        return (A)this;
    }

    @Override
    public Boolean hasInsecureSkipTLSVerify() {
        return this.insecureSkipTLSVerify != null;
    }

    @Override
    @Deprecated
    public ServiceReference getService() {
        return this.service != null ? this.service.build() : null;
    }

    @Override
    public ServiceReference buildService() {
        return this.service != null ? this.service.build() : null;
    }

    @Override
    public A withService(ServiceReference service) {
        this._visitables.get("service").remove(this.service);
        if (service != null) {
            this.service = new ServiceReferenceBuilder(service);
            this._visitables.get("service").add(this.service);
        }
        return (A)this;
    }

    @Override
    public Boolean hasService() {
        return this.service != null;
    }

    @Override
    public A withNewService(String name, String namespace, Integer port) {
        return this.withService(new ServiceReference(name, namespace, port));
    }

    @Override
    public APIServiceSpecFluent.ServiceNested<A> withNewService() {
        return new ServiceNestedImpl();
    }

    @Override
    public APIServiceSpecFluent.ServiceNested<A> withNewServiceLike(ServiceReference item) {
        return new ServiceNestedImpl(item);
    }

    @Override
    public APIServiceSpecFluent.ServiceNested<A> editService() {
        return this.withNewServiceLike(this.getService());
    }

    @Override
    public APIServiceSpecFluent.ServiceNested<A> editOrNewService() {
        return this.withNewServiceLike(this.getService() != null ? this.getService() : new ServiceReferenceBuilder().build());
    }

    @Override
    public APIServiceSpecFluent.ServiceNested<A> editOrNewServiceLike(ServiceReference item) {
        return this.withNewServiceLike(this.getService() != null ? this.getService() : item);
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    @Override
    public A withVersion(String version) {
        this.version = version;
        return (A)this;
    }

    @Override
    public Boolean hasVersion() {
        return this.version != null;
    }

    @Override
    @Deprecated
    public A withNewVersion(String arg0) {
        return this.withVersion(new String(arg0));
    }

    @Override
    public Integer getVersionPriority() {
        return this.versionPriority;
    }

    @Override
    public A withVersionPriority(Integer versionPriority) {
        this.versionPriority = versionPriority;
        return (A)this;
    }

    @Override
    public Boolean hasVersionPriority() {
        return this.versionPriority != null;
    }

    @Override
    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    @Override
    public Boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        APIServiceSpecFluentImpl that = (APIServiceSpecFluentImpl)o;
        if (this.caBundle != null ? !this.caBundle.equals(that.caBundle) : that.caBundle != null) {
            return false;
        }
        if (this.group != null ? !this.group.equals(that.group) : that.group != null) {
            return false;
        }
        if (this.groupPriorityMinimum != null ? !this.groupPriorityMinimum.equals(that.groupPriorityMinimum) : that.groupPriorityMinimum != null) {
            return false;
        }
        if (this.insecureSkipTLSVerify != null ? !this.insecureSkipTLSVerify.equals(that.insecureSkipTLSVerify) : that.insecureSkipTLSVerify != null) {
            return false;
        }
        if (this.service != null ? !this.service.equals(that.service) : that.service != null) {
            return false;
        }
        if (this.version != null ? !this.version.equals(that.version) : that.version != null) {
            return false;
        }
        if (this.versionPriority != null ? !this.versionPriority.equals(that.versionPriority) : that.versionPriority != null) {
            return false;
        }
        return !(this.additionalProperties != null ? !this.additionalProperties.equals(that.additionalProperties) : that.additionalProperties != null);
    }

    public int hashCode() {
        return Objects.hash(this.caBundle, this.group, this.groupPriorityMinimum, this.insecureSkipTLSVerify, this.service, this.version, this.versionPriority, this.additionalProperties, super.hashCode());
    }

    public class ServiceNestedImpl<N>
    extends ServiceReferenceFluentImpl<APIServiceSpecFluent.ServiceNested<N>>
    implements APIServiceSpecFluent.ServiceNested<N>,
    Nested<N> {
        ServiceReferenceBuilder builder;

        ServiceNestedImpl(ServiceReference item) {
            this.builder = new ServiceReferenceBuilder(this, item);
        }

        ServiceNestedImpl() {
            this.builder = new ServiceReferenceBuilder(this);
        }

        @Override
        public N and() {
            return (N)APIServiceSpecFluentImpl.this.withService(this.builder.build());
        }

        @Override
        public N endService() {
            return this.and();
        }
    }
}

