/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.installer.aws.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.openshift.api.model.installer.aws.v1.EC2RootVolume;
import io.fabric8.openshift.api.model.installer.aws.v1.EC2RootVolumeFluent;
import io.fabric8.openshift.api.model.installer.aws.v1.EC2RootVolumeFluentImpl;
import java.util.Objects;

public class EC2RootVolumeBuilder
extends EC2RootVolumeFluentImpl<EC2RootVolumeBuilder>
implements VisitableBuilder<EC2RootVolume, EC2RootVolumeBuilder> {
    EC2RootVolumeFluent<?> fluent;
    Boolean validationEnabled;

    public EC2RootVolumeBuilder() {
        this(false);
    }

    public EC2RootVolumeBuilder(Boolean validationEnabled) {
        this(new EC2RootVolume(), validationEnabled);
    }

    public EC2RootVolumeBuilder(EC2RootVolumeFluent<?> fluent) {
        this(fluent, (Boolean)false);
    }

    public EC2RootVolumeBuilder(EC2RootVolumeFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new EC2RootVolume(), validationEnabled);
    }

    public EC2RootVolumeBuilder(EC2RootVolumeFluent<?> fluent, EC2RootVolume instance) {
        this(fluent, instance, false);
    }

    public EC2RootVolumeBuilder(EC2RootVolumeFluent<?> fluent, EC2RootVolume instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withIops(instance.getIops());
        fluent.withKmsKeyARN(instance.getKmsKeyARN());
        fluent.withSize(instance.getSize());
        fluent.withType(instance.getType());
        fluent.withAdditionalProperties(instance.getAdditionalProperties());
        this.validationEnabled = validationEnabled;
    }

    public EC2RootVolumeBuilder(EC2RootVolume instance) {
        this(instance, (Boolean)false);
    }

    public EC2RootVolumeBuilder(EC2RootVolume instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withIops(instance.getIops());
        this.withKmsKeyARN(instance.getKmsKeyARN());
        this.withSize(instance.getSize());
        this.withType(instance.getType());
        this.withAdditionalProperties(instance.getAdditionalProperties());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public EC2RootVolume build() {
        EC2RootVolume buildable = new EC2RootVolume(this.fluent.getIops(), this.fluent.getKmsKeyARN(), this.fluent.getSize(), this.fluent.getType());
        buildable.setAdditionalProperties(this.fluent.getAdditionalProperties());
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        EC2RootVolumeBuilder that = (EC2RootVolumeBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.fluent, this.validationEnabled, super.hashCode());
    }
}

