/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.v5_12.operator.v1;

import io.fabric8.kubernetes.api.builder.v5_12.VisitableBuilder;
import io.fabric8.openshift.api.model.v5_12.operator.v1.ClusterNetworkEntry;
import io.fabric8.openshift.api.model.v5_12.operator.v1.ClusterNetworkEntryFluent;
import io.fabric8.openshift.api.model.v5_12.operator.v1.ClusterNetworkEntryFluentImpl;
import java.util.Objects;

public class ClusterNetworkEntryBuilder
extends ClusterNetworkEntryFluentImpl<ClusterNetworkEntryBuilder>
implements VisitableBuilder<ClusterNetworkEntry, ClusterNetworkEntryBuilder> {
    ClusterNetworkEntryFluent<?> fluent;
    Boolean validationEnabled;

    public ClusterNetworkEntryBuilder() {
        this(false);
    }

    public ClusterNetworkEntryBuilder(Boolean validationEnabled) {
        this(new ClusterNetworkEntry(), validationEnabled);
    }

    public ClusterNetworkEntryBuilder(ClusterNetworkEntryFluent<?> fluent) {
        this(fluent, (Boolean)false);
    }

    public ClusterNetworkEntryBuilder(ClusterNetworkEntryFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new ClusterNetworkEntry(), validationEnabled);
    }

    public ClusterNetworkEntryBuilder(ClusterNetworkEntryFluent<?> fluent, ClusterNetworkEntry instance) {
        this(fluent, instance, false);
    }

    public ClusterNetworkEntryBuilder(ClusterNetworkEntryFluent<?> fluent, ClusterNetworkEntry instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withCidr(instance.getCidr());
        fluent.withHostPrefix(instance.getHostPrefix());
        fluent.withAdditionalProperties(instance.getAdditionalProperties());
        this.validationEnabled = validationEnabled;
    }

    public ClusterNetworkEntryBuilder(ClusterNetworkEntry instance) {
        this(instance, (Boolean)false);
    }

    public ClusterNetworkEntryBuilder(ClusterNetworkEntry instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withCidr(instance.getCidr());
        this.withHostPrefix(instance.getHostPrefix());
        this.withAdditionalProperties(instance.getAdditionalProperties());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public ClusterNetworkEntry build() {
        ClusterNetworkEntry buildable = new ClusterNetworkEntry(this.fluent.getCidr(), this.fluent.getHostPrefix());
        buildable.setAdditionalProperties(this.fluent.getAdditionalProperties());
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ClusterNetworkEntryBuilder that = (ClusterNetworkEntryBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.fluent, this.validationEnabled, super.hashCode());
    }
}

