/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.v5_12.operator.v1;

import io.fabric8.kubernetes.api.builder.v5_12.VisitableBuilder;
import io.fabric8.openshift.api.model.v5_12.operator.v1.CloudCredential;
import io.fabric8.openshift.api.model.v5_12.operator.v1.CloudCredentialFluent;
import io.fabric8.openshift.api.model.v5_12.operator.v1.CloudCredentialFluentImpl;
import java.util.Objects;

public class CloudCredentialBuilder
extends CloudCredentialFluentImpl<CloudCredentialBuilder>
implements VisitableBuilder<CloudCredential, CloudCredentialBuilder> {
    CloudCredentialFluent<?> fluent;
    Boolean validationEnabled;

    public CloudCredentialBuilder() {
        this(false);
    }

    public CloudCredentialBuilder(Boolean validationEnabled) {
        this(new CloudCredential(), validationEnabled);
    }

    public CloudCredentialBuilder(CloudCredentialFluent<?> fluent) {
        this(fluent, (Boolean)false);
    }

    public CloudCredentialBuilder(CloudCredentialFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new CloudCredential(), validationEnabled);
    }

    public CloudCredentialBuilder(CloudCredentialFluent<?> fluent, CloudCredential instance) {
        this(fluent, instance, false);
    }

    public CloudCredentialBuilder(CloudCredentialFluent<?> fluent, CloudCredential instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withApiVersion(instance.getApiVersion());
        fluent.withKind(instance.getKind());
        fluent.withMetadata(instance.getMetadata());
        fluent.withSpec(instance.getSpec());
        fluent.withStatus(instance.getStatus());
        fluent.withAdditionalProperties(instance.getAdditionalProperties());
        this.validationEnabled = validationEnabled;
    }

    public CloudCredentialBuilder(CloudCredential instance) {
        this(instance, (Boolean)false);
    }

    public CloudCredentialBuilder(CloudCredential instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withApiVersion(instance.getApiVersion());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
        this.withSpec(instance.getSpec());
        this.withStatus(instance.getStatus());
        this.withAdditionalProperties(instance.getAdditionalProperties());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public CloudCredential build() {
        CloudCredential buildable = new CloudCredential(this.fluent.getApiVersion(), this.fluent.getKind(), this.fluent.getMetadata(), this.fluent.getSpec(), this.fluent.getStatus());
        buildable.setAdditionalProperties(this.fluent.getAdditionalProperties());
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        CloudCredentialBuilder that = (CloudCredentialBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.fluent, this.validationEnabled, super.hashCode());
    }
}

