/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.v5_12.installer.vsphere.v1;

import io.fabric8.kubernetes.api.builder.v5_12.VisitableBuilder;
import io.fabric8.openshift.api.model.v5_12.installer.vsphere.v1.OSDisk;
import io.fabric8.openshift.api.model.v5_12.installer.vsphere.v1.OSDiskFluent;
import io.fabric8.openshift.api.model.v5_12.installer.vsphere.v1.OSDiskFluentImpl;
import java.util.Objects;

public class OSDiskBuilder
extends OSDiskFluentImpl<OSDiskBuilder>
implements VisitableBuilder<OSDisk, OSDiskBuilder> {
    OSDiskFluent<?> fluent;
    Boolean validationEnabled;

    public OSDiskBuilder() {
        this(false);
    }

    public OSDiskBuilder(Boolean validationEnabled) {
        this(new OSDisk(), validationEnabled);
    }

    public OSDiskBuilder(OSDiskFluent<?> fluent) {
        this(fluent, (Boolean)false);
    }

    public OSDiskBuilder(OSDiskFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new OSDisk(), validationEnabled);
    }

    public OSDiskBuilder(OSDiskFluent<?> fluent, OSDisk instance) {
        this(fluent, instance, false);
    }

    public OSDiskBuilder(OSDiskFluent<?> fluent, OSDisk instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withDiskSizeGB(instance.getDiskSizeGB());
        fluent.withAdditionalProperties(instance.getAdditionalProperties());
        this.validationEnabled = validationEnabled;
    }

    public OSDiskBuilder(OSDisk instance) {
        this(instance, (Boolean)false);
    }

    public OSDiskBuilder(OSDisk instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withDiskSizeGB(instance.getDiskSizeGB());
        this.withAdditionalProperties(instance.getAdditionalProperties());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public OSDisk build() {
        OSDisk buildable = new OSDisk(this.fluent.getDiskSizeGB());
        buildable.setAdditionalProperties(this.fluent.getAdditionalProperties());
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        OSDiskBuilder that = (OSDiskBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.fluent, this.validationEnabled, super.hashCode());
    }
}

