/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.clnt.v5_12.utils.serialization;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.introspect.AnnotatedMember;
import com.fasterxml.jackson.databind.ser.BeanPropertyWriter;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BeanPropertyWriterDelegate
extends BeanPropertyWriter {
    private static final Logger logger = LoggerFactory.getLogger(BeanPropertyWriterDelegate.class);
    private final BeanPropertyWriter delegate;
    private final AnnotatedMember anyGetter;
    private final transient Supplier<Boolean> logDuplicateWarning;

    BeanPropertyWriterDelegate(BeanPropertyWriter delegate, AnnotatedMember anyGetter, Supplier<Boolean> logDuplicateWarning) {
        super(delegate);
        this.delegate = delegate;
        this.anyGetter = anyGetter;
        this.logDuplicateWarning = logDuplicateWarning;
    }

    public void serializeAsField(Object bean, JsonGenerator gen, SerializerProvider prov) throws Exception {
        Object valueInAnyGetter = Optional.ofNullable(this.anyGetter).map(ag -> ag.getValue(bean)).map(Map.class::cast).map(m -> m.get(this.delegate.getName())).orElse(null);
        if (valueInAnyGetter == null) {
            this.delegate.serializeAsField(bean, gen, prov);
        } else if (Boolean.TRUE.equals(this.logDuplicateWarning.get())) {
            logger.warn("Value in field '{}' ignored in favor of value in additionalProperties ({}) for {}", new Object[]{this.delegate.getName(), valueInAnyGetter, bean.getClass().getName()});
        }
    }
}

