/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v5_12;

import io.fabric8.kubernetes.api.builder.v5_12.VisitableBuilder;
import io.fabric8.kubernetes.api.model.v5_12.ContainerState;
import io.fabric8.kubernetes.api.model.v5_12.ContainerStateFluent;
import io.fabric8.kubernetes.api.model.v5_12.ContainerStateFluentImpl;
import java.util.Objects;

public class ContainerStateBuilder
extends ContainerStateFluentImpl<ContainerStateBuilder>
implements VisitableBuilder<ContainerState, ContainerStateBuilder> {
    ContainerStateFluent<?> fluent;
    Boolean validationEnabled;

    public ContainerStateBuilder() {
        this(false);
    }

    public ContainerStateBuilder(Boolean validationEnabled) {
        this(new ContainerState(), validationEnabled);
    }

    public ContainerStateBuilder(ContainerStateFluent<?> fluent) {
        this(fluent, (Boolean)false);
    }

    public ContainerStateBuilder(ContainerStateFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new ContainerState(), validationEnabled);
    }

    public ContainerStateBuilder(ContainerStateFluent<?> fluent, ContainerState instance) {
        this(fluent, instance, false);
    }

    public ContainerStateBuilder(ContainerStateFluent<?> fluent, ContainerState instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withRunning(instance.getRunning());
        fluent.withTerminated(instance.getTerminated());
        fluent.withWaiting(instance.getWaiting());
        fluent.withAdditionalProperties(instance.getAdditionalProperties());
        this.validationEnabled = validationEnabled;
    }

    public ContainerStateBuilder(ContainerState instance) {
        this(instance, (Boolean)false);
    }

    public ContainerStateBuilder(ContainerState instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withRunning(instance.getRunning());
        this.withTerminated(instance.getTerminated());
        this.withWaiting(instance.getWaiting());
        this.withAdditionalProperties(instance.getAdditionalProperties());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public ContainerState build() {
        ContainerState buildable = new ContainerState(this.fluent.getRunning(), this.fluent.getTerminated(), this.fluent.getWaiting());
        buildable.setAdditionalProperties(this.fluent.getAdditionalProperties());
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ContainerStateBuilder that = (ContainerStateBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.fluent, this.validationEnabled, super.hashCode());
    }
}

