/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.networking.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.ListMeta;
import io.fabric8.kubernetes.api.model.networking.v1.NetworkPolicy;
import io.fabric8.kubernetes.api.model.networking.v1.NetworkPolicyBuilder;
import io.fabric8.kubernetes.api.model.networking.v1.NetworkPolicyFluentImpl;
import io.fabric8.kubernetes.api.model.networking.v1.NetworkPolicyList;
import io.fabric8.kubernetes.api.model.networking.v1.NetworkPolicyListFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class NetworkPolicyListFluentImpl<A extends NetworkPolicyListFluent<A>>
extends BaseFluent<A>
implements NetworkPolicyListFluent<A> {
    private String apiVersion;
    private List<NetworkPolicyBuilder> items = new ArrayList<NetworkPolicyBuilder>();
    private String kind;
    private ListMeta metadata;
    private Map<String, Object> additionalProperties;

    public NetworkPolicyListFluentImpl() {
    }

    public NetworkPolicyListFluentImpl(NetworkPolicyList instance) {
        this.withApiVersion(instance.getApiVersion());
        this.withItems(instance.getItems());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
        this.withAdditionalProperties(instance.getAdditionalProperties());
    }

    @Override
    public String getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public A withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (A)this;
    }

    @Override
    public Boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    @Override
    @Deprecated
    public A withNewApiVersion(String arg0) {
        return this.withApiVersion(new String(arg0));
    }

    @Override
    public A addToItems(Integer index, NetworkPolicy item) {
        if (this.items == null) {
            this.items = new ArrayList<NetworkPolicyBuilder>();
        }
        NetworkPolicyBuilder builder = new NetworkPolicyBuilder(item);
        this._visitables.get("items").add(index >= 0 ? index.intValue() : this._visitables.get("items").size(), builder);
        this.items.add(index >= 0 ? index.intValue() : this.items.size(), builder);
        return (A)this;
    }

    @Override
    public A setToItems(Integer index, NetworkPolicy item) {
        if (this.items == null) {
            this.items = new ArrayList<NetworkPolicyBuilder>();
        }
        NetworkPolicyBuilder builder = new NetworkPolicyBuilder(item);
        if (index < 0 || index >= this._visitables.get("items").size()) {
            this._visitables.get("items").add(builder);
        } else {
            this._visitables.get("items").set(index, builder);
        }
        if (index < 0 || index >= this.items.size()) {
            this.items.add(builder);
        } else {
            this.items.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToItems(NetworkPolicy ... items) {
        if (this.items == null) {
            this.items = new ArrayList<NetworkPolicyBuilder>();
        }
        for (NetworkPolicy item : items) {
            NetworkPolicyBuilder builder = new NetworkPolicyBuilder(item);
            this._visitables.get("items").add(builder);
            this.items.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToItems(Collection<NetworkPolicy> items) {
        if (this.items == null) {
            this.items = new ArrayList<NetworkPolicyBuilder>();
        }
        for (NetworkPolicy item : items) {
            NetworkPolicyBuilder builder = new NetworkPolicyBuilder(item);
            this._visitables.get("items").add(builder);
            this.items.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromItems(NetworkPolicy ... items) {
        for (NetworkPolicy item : items) {
            NetworkPolicyBuilder builder = new NetworkPolicyBuilder(item);
            this._visitables.get("items").remove(builder);
            if (this.items == null) continue;
            this.items.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromItems(Collection<NetworkPolicy> items) {
        for (NetworkPolicy item : items) {
            NetworkPolicyBuilder builder = new NetworkPolicyBuilder(item);
            this._visitables.get("items").remove(builder);
            if (this.items == null) continue;
            this.items.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromItems(Predicate<NetworkPolicyBuilder> predicate) {
        if (this.items == null) {
            return (A)this;
        }
        Iterator<NetworkPolicyBuilder> each = this.items.iterator();
        Object visitables = this._visitables.get("items");
        while (each.hasNext()) {
            NetworkPolicyBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<NetworkPolicy> getItems() {
        return NetworkPolicyListFluentImpl.build(this.items);
    }

    @Override
    public List<NetworkPolicy> buildItems() {
        return NetworkPolicyListFluentImpl.build(this.items);
    }

    @Override
    public NetworkPolicy buildItem(Integer index) {
        return this.items.get(index).build();
    }

    @Override
    public NetworkPolicy buildFirstItem() {
        return this.items.get(0).build();
    }

    @Override
    public NetworkPolicy buildLastItem() {
        return this.items.get(this.items.size() - 1).build();
    }

    @Override
    public NetworkPolicy buildMatchingItem(Predicate<NetworkPolicyBuilder> predicate) {
        for (NetworkPolicyBuilder item : this.items) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingItem(Predicate<NetworkPolicyBuilder> predicate) {
        for (NetworkPolicyBuilder item : this.items) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withItems(List<NetworkPolicy> items) {
        if (this.items != null) {
            this._visitables.get("items").removeAll(this.items);
        }
        if (items != null) {
            this.items = new ArrayList<NetworkPolicyBuilder>();
            for (NetworkPolicy item : items) {
                this.addToItems(item);
            }
        } else {
            this.items = null;
        }
        return (A)this;
    }

    @Override
    public A withItems(NetworkPolicy ... items) {
        if (this.items != null) {
            this.items.clear();
        }
        if (items != null) {
            for (NetworkPolicy item : items) {
                this.addToItems(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasItems() {
        return this.items != null && !this.items.isEmpty();
    }

    @Override
    public NetworkPolicyListFluent.ItemsNested<A> addNewItem() {
        return new ItemsNestedImpl();
    }

    @Override
    public NetworkPolicyListFluent.ItemsNested<A> addNewItemLike(NetworkPolicy item) {
        return new ItemsNestedImpl(-1, item);
    }

    @Override
    public NetworkPolicyListFluent.ItemsNested<A> setNewItemLike(Integer index, NetworkPolicy item) {
        return new ItemsNestedImpl(index, item);
    }

    @Override
    public NetworkPolicyListFluent.ItemsNested<A> editItem(Integer index) {
        if (this.items.size() <= index) {
            throw new RuntimeException("Can't edit items. Index exceeds size.");
        }
        return this.setNewItemLike(index, this.buildItem(index));
    }

    @Override
    public NetworkPolicyListFluent.ItemsNested<A> editFirstItem() {
        if (this.items.size() == 0) {
            throw new RuntimeException("Can't edit first items. The list is empty.");
        }
        return this.setNewItemLike(0, this.buildItem(0));
    }

    @Override
    public NetworkPolicyListFluent.ItemsNested<A> editLastItem() {
        int index = this.items.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last items. The list is empty.");
        }
        return this.setNewItemLike(index, this.buildItem(index));
    }

    @Override
    public NetworkPolicyListFluent.ItemsNested<A> editMatchingItem(Predicate<NetworkPolicyBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.items.size(); ++i) {
            if (!predicate.test(this.items.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching items. No match found.");
        }
        return this.setNewItemLike(index, this.buildItem(index));
    }

    @Override
    public String getKind() {
        return this.kind;
    }

    @Override
    public A withKind(String kind) {
        this.kind = kind;
        return (A)this;
    }

    @Override
    public Boolean hasKind() {
        return this.kind != null;
    }

    @Override
    @Deprecated
    public A withNewKind(String arg0) {
        return this.withKind(new String(arg0));
    }

    @Override
    public ListMeta getMetadata() {
        return this.metadata;
    }

    @Override
    public A withMetadata(ListMeta metadata) {
        this.metadata = metadata;
        return (A)this;
    }

    @Override
    public Boolean hasMetadata() {
        return this.metadata != null;
    }

    @Override
    public A withNewMetadata(String _continue, Long remainingItemCount, String resourceVersion, String selfLink) {
        return this.withMetadata(new ListMeta(_continue, remainingItemCount, resourceVersion, selfLink));
    }

    @Override
    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    @Override
    public Boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NetworkPolicyListFluentImpl that = (NetworkPolicyListFluentImpl)o;
        if (this.apiVersion != null ? !this.apiVersion.equals(that.apiVersion) : that.apiVersion != null) {
            return false;
        }
        if (this.items != null ? !this.items.equals(that.items) : that.items != null) {
            return false;
        }
        if (this.kind != null ? !this.kind.equals(that.kind) : that.kind != null) {
            return false;
        }
        if (this.metadata != null ? !this.metadata.equals(that.metadata) : that.metadata != null) {
            return false;
        }
        return !(this.additionalProperties != null ? !this.additionalProperties.equals(that.additionalProperties) : that.additionalProperties != null);
    }

    public int hashCode() {
        return Objects.hash(this.apiVersion, this.items, this.kind, this.metadata, this.additionalProperties, super.hashCode());
    }

    public class ItemsNestedImpl<N>
    extends NetworkPolicyFluentImpl<NetworkPolicyListFluent.ItemsNested<N>>
    implements NetworkPolicyListFluent.ItemsNested<N>,
    Nested<N> {
        NetworkPolicyBuilder builder;
        Integer index;

        ItemsNestedImpl(Integer index, NetworkPolicy item) {
            this.index = index;
            this.builder = new NetworkPolicyBuilder(this, item);
        }

        ItemsNestedImpl() {
            this.index = -1;
            this.builder = new NetworkPolicyBuilder(this);
        }

        @Override
        public N and() {
            return (N)NetworkPolicyListFluentImpl.this.setToItems(this.index, this.builder.build());
        }

        @Override
        public N endItem() {
            return this.and();
        }
    }
}

